/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.continuous;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.ptplot.PlotPoint;
import com.agilent.tntd.eclipse.mrsgraphs.common.DatasetAttributes;
import com.agilent.tntd.eclipse.mrsgraphs.common.Epoch;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphComponent;
import java.util.Enumeration;
import java.util.Vector;

public class ContinuousPlot
extends MRSGraphComponent {
    public ContinuousPlot() {
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.graph = "Continuous";
        this._YPADDING = 0.05;
    }

    protected void plotData(int dataID, int dataset, long start, float[] data, boolean errorBars) {
        boolean connectToLastPoint;
        int length = data.length;
        String xvalues = "";
        String yvalues = "";
        switch (dataID) {
            case 0: {
                connectToLastPoint = false;
                break;
            }
            case 1: {
                connectToLastPoint = true;
                break;
            }
            default: {
                EventLog.instance().log("ERROR: " + this.toString() + ": plotData: Unrecognized data ID");
                this.trapTransientError(true);
                return;
            }
        }
        int i = 0;
        while (i < length) {
            double x = errorBars ? (double)(start + (long)(i / 3) * this.resolution) : (double)(start + (long)i * this.resolution);
            long endOfBucket = Math.round(x) + (this.resolution - 1L);
            if (this.debug && endOfBucket <= this.datasetAttributes[dataset].lastReceivedXValue) {
                EventLog.instance().log("ERROR: " + this.toString() + ": plotData: Already received data at time " + x);
            } else {
                double y = data[i];
                xvalues = String.valueOf(xvalues) + "" + Math.round(x) + ", ";
                yvalues = String.valueOf(yvalues) + "" + y + ", ";
                if (errorBars) {
                    double min = data[++i];
                    double max = data[++i];
                    if (Math.abs(y - min) < 0.001 && Math.abs(y - max) < 0.001) {
                        this.addPoint(dataset, x, y, connectToLastPoint);
                    } else {
                        this.addPointWithErrorBars(dataset, x, y, min, max, connectToLastPoint);
                    }
                } else {
                    this.addPoint(dataset, x, y, connectToLastPoint);
                }
                this.datasetAttributes[dataset].lastReceivedXValue = endOfBucket;
                this.eodMarkerLocation = Math.round(x);
                if (endOfBucket > this.maxXValueReceived) {
                    this.maxXValueReceived = endOfBucket;
                }
                connectToLastPoint = true;
            }
            ++i;
        }
        if (this.debug) {
            EventLog.instance().log("*****");
            EventLog.instance().log("DEBUG: " + this.toString() + ": plotData: Data ID = " + dataID + "; Start = " + start + "; Size = " + length);
            EventLog.instance().log("X Values = " + xvalues);
            EventLog.instance().log("Y Values = " + yvalues);
            EventLog.instance().log("Last received x value = " + this.datasetAttributes[dataset].lastReceivedXValue);
        }
        this.setCursorLocation(this.cursorLocation);
        this.updateCursorLocationValues();
    }

    protected void resetPlot() {
        this.clear(true);
        this.setGrid(false);
        this.maxXValueReceived = 0L;
        if (this.datasetAttributes != null) {
            int i = 0;
            while (i < this.datasetAttributes.length) {
                this.datasetAttributes[i].lastReceivedXValue = 0L;
                ++i;
            }
        }
        this.setXRange(this.rangeLeft, this.rangeRight);
        this.calculateXTickMarks();
    }

    public String toString() {
        return "ContinuousPlot: " + super.toString();
    }

    protected boolean updateCursorLocationValues() {
        boolean valuesFound = true;
        int i = 0;
        while (i < this.datasetAttributes.length) {
            double y = -9999.99;
            DatasetAttributes d = this.datasetAttributes[i];
            if (this._points != null && this._points.size() > 0) {
                if (i >= this._points.size()) {
                    EventLog.instance().log("ERROR: " + this.toString() + ": updateCursorLocationValues: dataset index " + i + " exceeds the size of _points");
                } else {
                    Vector pointsVector = (Vector)this._points.elementAt(i);
                    Enumeration pointsEnum = pointsVector.elements();
                    while (pointsEnum.hasMoreElements()) {
                        PlotPoint p = (PlotPoint)pointsEnum.nextElement();
                        if (p.x != (double)this.cursorLocation) continue;
                        double cfr_ignored_0 = p.x;
                        y = p.y;
                        break;
                    }
                    Epoch epoch = new Epoch(this.cursorLocation * 1000L);
                    d.cursorValue = "t = " + epoch.getDateAndTime(true, true);
                    if (y != -9999.99) {
                        d.cursorValue = String.valueOf(d.cursorValue) + "    y = " + this.formatDoubleToString(y, 3);
                    } else {
                        valuesFound = false;
                        d.cursorValue = String.valueOf(d.cursorValue) + "    y = NO DATA";
                    }
                }
            } else {
                valuesFound = false;
                EventLog.instance().log("ERROR: " + this.toString() + ": updateCursorLocationValues: _points vector is null or contains no data");
            }
            ++i;
        }
        return valuesFound;
    }
}

