/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.histogram;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.ptplot.PlotBox;
import com.agilent.tntd.eclipse.graphs.ptplot.PlotPoint;
import com.agilent.tntd.eclipse.mrsgraphs.common.DatasetAttributes;
import com.agilent.tntd.eclipse.mrsgraphs.common.Epoch;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphComponent;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class HistogramPlot
extends MRSGraphComponent {
    private transient int barWidth = 3;

    public HistogramPlot() {
        this.initialize();
    }

    protected void _drawBar(Graphics graphics, int dataset, long xpos, long l, boolean clip) {
        long ypos;
        if (clip) {
            if (l < (long)this._uly) {
                ypos = this._uly;
            }
            if (ypos > (long)this._lry) {
                ypos = this._lry;
            }
        }
        if (ypos <= (long)this._lry && xpos <= (long)this._lrx && xpos >= (long)this._ulx) {
            long zeroypos;
            int barlx = (int)(xpos - (long)(this.barWidth / 2));
            int barrx = barlx + this.barWidth;
            if (barlx < this._ulx) {
                barlx = this._ulx;
            }
            if (barrx > this._lrx) {
                barrx = this._lrx;
            }
            if (barlx >= barrx) {
                barrx = barlx + 1;
            }
            if ((long)this._lry < (zeroypos = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                zeroypos = this._lry;
            }
            if ((long)this._uly > zeroypos) {
                zeroypos = this._uly;
            }
            if (this._yMin >= 0.0 || ypos <= zeroypos) {
                graphics.fillRect(barlx, (int)ypos, barrx - barlx, (int)(zeroypos - ypos));
            } else {
                graphics.fillRect(barlx, (int)zeroypos, barrx - barlx, (int)(ypos - zeroypos));
            }
        }
    }

    protected double _getLogarithmicValue(double d) throws IllegalArgumentException {
        double value;
        if (d < 0.0) {
            throw new IllegalArgumentException("Cannot take the log of a value less than zero!");
        }
        if (d == 1.0) {
            value = 1.2;
        } else if (value == 0.0) {
            value = 1.0;
        }
        return Math.log(value) * PlotBox._LOG10SCALE;
    }

    protected void initialize() {
        super.initialize();
        this.graph = "Histogram";
    }

    protected void plotData(int dataID, int dataset, long start, float[] data, boolean errorBars) {
        if (errorBars) {
            EventLog.instance().log("ERROR: " + this.toString() + ": plotData: Error bars specified. This makes no sense in a histogram graph.");
        }
        boolean connectToLastPoint = false;
        int length = data.length;
        String xvalues = "";
        String yvalues = "";
        int i = 0;
        while (i < length) {
            double x = start + (long)i * this.resolution;
            long endOfBucket = Math.round(x) + (this.resolution - 1L);
            if (this.debug && endOfBucket <= this.datasetAttributes[dataset].lastReceivedXValue) {
                EventLog.instance().log("ERROR: " + this.toString() + ": plotData: Already received data at time " + x);
            } else {
                this.addPoint(dataset, x, data[i], connectToLastPoint);
                xvalues = String.valueOf(xvalues) + "" + Math.round(x) + ", ";
                yvalues = String.valueOf(yvalues) + "" + data[i] + ", ";
                this.datasetAttributes[dataset].lastReceivedXValue = endOfBucket;
                this.eodMarkerLocation = Math.round(x);
                if (endOfBucket > this.maxXValueReceived) {
                    this.maxXValueReceived = endOfBucket;
                }
            }
            ++i;
        }
        if (this.debug) {
            EventLog.instance().log("*****");
            EventLog.instance().log("DEBUG: " + this.toString() + ": plotData: Data ID = " + dataID + "; Start = " + start + "; Size = " + length);
            EventLog.instance().log("X Values = " + xvalues);
            EventLog.instance().log("Y Values = " + yvalues);
            EventLog.instance().log("Last received x value = " + this.datasetAttributes[dataset].lastReceivedXValue);
        }
        this.setCursorLocation(this.cursorLocation);
        this.updateCursorLocationValues();
    }

    protected void resetPlot() {
        this.clear(true);
        this.setGrid(false);
        this.maxXValueReceived = 0L;
        if (this.datasetAttributes != null) {
            int i = 0;
            while (i < this.datasetAttributes.length) {
                this.datasetAttributes[i].lastReceivedXValue = 0L;
                ++i;
            }
        }
        this.setXRange(this.rangeLeft, this.rangeRight);
        this.barWidth = 5;
        this.setBars(true);
        this.calculateXTickMarks();
        this.setYLog(true);
        this.setYRange(0.0, 4.0);
        this.addYTick("10", 1.0);
        this.addYTick("100", 2.0);
        this.addYTick("1000", 3.0);
        this.addYTick("10,000", 4.0);
    }

    public String toString() {
        return "HistogramPlot: " + super.toString();
    }

    protected boolean updateCursorLocationValues() {
        boolean valuesFound = true;
        int i = 0;
        while (i < this.datasetAttributes.length) {
            double y = -9999.99;
            DatasetAttributes d = this.datasetAttributes[i];
            if (this._points != null && this._points.size() > 0) {
                if (i >= this._points.size()) {
                    EventLog.instance().log("ERROR: " + this.toString() + ": updateCursorLocationValues: dataset index " + i + "exceeds the size of _points");
                } else {
                    Vector pointsVector = (Vector)this._points.elementAt(i);
                    Enumeration pointsEnum = pointsVector.elements();
                    while (pointsEnum.hasMoreElements()) {
                        PlotPoint p = (PlotPoint)pointsEnum.nextElement();
                        if (p.x != (double)this.cursorLocation) continue;
                        double cfr_ignored_0 = p.x;
                        y = p.y;
                        break;
                    }
                    Epoch epoch = new Epoch(this.cursorLocation * 1000L);
                    d.cursorValue = "t = " + epoch.getDateAndTime(true, true);
                    if (y != -9999.99) {
                        if (this._ylog) {
                            double value = Math.pow(10.0, y);
                            if (value == 1.0) {
                                value = 0.0;
                            } else if (value == 1.2) {
                                value = 1.0;
                            }
                            d.cursorValue = String.valueOf(d.cursorValue) + "    y = " + this.formatDoubleToString(value, 3);
                        } else {
                            d.cursorValue = String.valueOf(d.cursorValue) + "    y = " + this.formatDoubleToString(y, 3);
                        }
                    } else {
                        valuesFound = false;
                        d.cursorValue = String.valueOf(d.cursorValue) + "    y = NO DATA";
                    }
                }
            } else {
                valuesFound = false;
                EventLog.instance().log("ERROR: " + this.toString() + ": updateCursorLocationValues: _points vector is null or contains no data");
            }
            ++i;
        }
        return valuesFound;
    }
}

