/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.menu;

import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphInfo;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphManager;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphParameters;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSLatestSessionState;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSStateMonitor;
import com.agilent.tntd.eclipse.mrsgraphs.containers.FocusManagingPanePage;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphTypeHandler;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSGraphInfoDataReceiver;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSGraphWindow;
import com.agilent.tntd.eclipse.mrsgraphs.menu.MenuBridge;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.menus.EclActionMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMainMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMainMenuModel;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.EclSeparatorMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.SelfInitialisedMenuElement;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class MRSGraphMenu
extends EclMainMenu
implements CcComponent,
MaskedIntegerDataReceiver,
MRSGraphInfoDataReceiver {
    private MRSGraphWindow myWindow = null;
    private int currentGraphViewMode = -1;
    private MRSGraphInfo theGraphInfo = null;
    private MRSLatestSessionState latestSessionState = new MRSLatestSessionState();
    private boolean hasTrappedTransientError = false;
    private boolean hasTrappedPermanentError = false;
    private Component theFocusReceiver;
    private GraphTypeHandler theGraphHandler;
    private MRSStateMonitor theStateMonitor;
    private EclActionMenuItem[] theViewRangeMenuItems = null;
    private EclActionMenuItem theNextErrorMenuItem;
    private EclActionMenuItem thePreviousErrorMenuItem;
    private EclActionMenuItem thePageLeftMenuItem;
    private EclActionMenuItem thePageRightMenuItem;
    private EclActionMenuItem theStartOfDataMenuItem;
    private EclActionMenuItem theEndOfDataMenuItem;
    private EclActionMenuItem theSingleGraphTypeMenuItem;
    private EclActionMenuItem theDoubleGraphTypeMenuItem;
    private EclActionMenuItem theAddRemoveMenuItem;
    private EclActionMenuItem theSessionWindowMenuItem;
    private EclActionMenuItem theCloseMenuItem;
    private Font theDefaultMenuItemFont = null;
    private Font theBoldMenuItemFont = null;
    private MRSGraphMenuEventHandler theMenuEventHandler;
    private MRSViewRangeMenuEventHandler theViewRangeMenuEventHandler;

    public MRSGraphMenu(MRSGraphWindow w, MenuBridge aMenuBridge, MRSStateMonitor aMonitor) {
        this.myWindow = w;
        this.theStateMonitor = aMonitor;
        this.describeMainMenu(aMenuBridge);
    }

    private void createViewRangeMenuItems() {
        Font f;
        this.theViewRangeMenuItems = new EclActionMenuItem[10];
        this.theViewRangeMenuItems[0] = new EclActionMenuItem("1 minute", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[1] = new EclActionMenuItem("1 hour", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[2] = new EclActionMenuItem("12 hours", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[3] = new EclActionMenuItem("1 day", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[4] = new EclActionMenuItem("2 days", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[5] = new EclActionMenuItem("3 days", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[6] = new EclActionMenuItem("4 days", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[7] = new EclActionMenuItem("5 days", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[8] = new EclActionMenuItem("6 days", this.getMRSViewRangeMenuEventHandler());
        this.theViewRangeMenuItems[9] = new EclActionMenuItem("7 days", this.getMRSViewRangeMenuEventHandler());
        this.theDefaultMenuItemFont = f = this.theViewRangeMenuItems[0].getFont();
        this.theBoldMenuItemFont = new Font(f.getName(), 1, f.getSize());
    }

    private void describeMainMenu(MenuBridge aMenuBridge) {
        this.setEclModel(new EclMainMenuModel(null, new SelfInitialisedMenuElement[]{aMenuBridge.getSelectionMenu("Select"), new EclMenu(10, "View Range", null), this.getViewRangeMenuItem(0), this.getViewRangeMenuItem(1), this.getViewRangeMenuItem(2), this.getViewRangeMenuItem(3), this.getViewRangeMenuItem(4), this.getViewRangeMenuItem(5), this.getViewRangeMenuItem(6), this.getViewRangeMenuItem(7), this.getViewRangeMenuItem(8), this.getViewRangeMenuItem(9), new EclMenu(7, "Show", null), this.getPageLeftMenuItem(), this.getPageRightMenuItem(), this.getStartOfDataMenuItem(), this.getEndOfDataMenuItem(), new EclSeparatorMenuItem(), this.getSingleGraphTypeMenuItem(), this.getDoubleGraphTypeMenuItem(), this.getAddRemoveMenuItem(), new EclSeparatorMenuItem(), this.getCloseMenuItem()}));
    }

    private void determineMenuItemsState() {
        if (this.theGraphInfo != null && this.theGraphHandler != null && this.theGraphHandler.getType() != 0) {
            if (this.theGraphInfo.left <= this.theGraphInfo.startOfData) {
                this.getStartOfDataMenuItem().setEnabled(false);
                this.getPageLeftMenuItem().setEnabled(false);
            } else {
                this.getStartOfDataMenuItem().setEnabled(true);
                this.getPageLeftMenuItem().setEnabled(true);
            }
            if (this.theGraphInfo.right >= this.theGraphInfo.endOfData) {
                this.getEndOfDataMenuItem().setEnabled(false);
                this.getPageRightMenuItem().setEnabled(false);
            } else {
                this.getEndOfDataMenuItem().setEnabled(true);
                this.getPageRightMenuItem().setEnabled(true);
            }
            int max = this.getMaxZoomFactor(this.theGraphInfo.endOfData - this.theGraphInfo.startOfData);
            int i = 0;
            while (i <= max) {
                this.getViewRangeMenuItem(i).setEnabled(true);
                this.getViewRangeMenuItem(i).setFont(this.theDefaultMenuItemFont);
                ++i;
            }
            i = max + 1;
            while (i <= 9) {
                this.getViewRangeMenuItem(i).setEnabled(false);
                this.getViewRangeMenuItem(i).setFont(this.theDefaultMenuItemFont);
                ++i;
            }
            this.getViewRangeMenuItem(this.theGraphInfo.zoomFactor).getFont();
            this.getViewRangeMenuItem(this.theGraphInfo.zoomFactor).setFont(this.theBoldMenuItemFont);
        } else {
            this.getStartOfDataMenuItem().setEnabled(false);
            this.getPageLeftMenuItem().setEnabled(false);
            this.getEndOfDataMenuItem().setEnabled(false);
            this.getPageRightMenuItem().setEnabled(false);
            if (this.theViewRangeMenuItems != null) {
                int i = 0;
                while (i < this.theViewRangeMenuItems.length) {
                    this.getViewRangeMenuItem(i).setEnabled(false);
                    ++i;
                }
            }
        }
    }

    public void doGraphViewModeAction(ActionEvent e) {
        Component c;
        int newValue = -1;
        if (this.currentGraphViewMode == 0) {
            newValue = 1;
        } else if (this.currentGraphViewMode == 1) {
            newValue = 0;
        }
        boolean successful = this.theStateMonitor.setGraphViewMode(newValue);
        if (!successful) {
            EventLog.instance().log("ERROR: " + this.toString() + ": doGraphViewModeAction: Server refused change request for graph view mode AO");
        }
        if ((c = this.myWindow.getTheManagingPane().getComponent(0)) != null) {
            if (c instanceof FocusManagingPanePage && this.theGraphHandler != null) {
                int type = this.theGraphHandler.getType();
                MRSGraphParameters[] params = this.theGraphHandler.getGraphParameters();
                if (successful && type != 4 && type != 0) {
                    MRSGraphParameters[] singleGraphParams = new MRSGraphParameters[]{params[0]};
                    ((FocusManagingPanePage)((Object)c)).updateGraphType(type, singleGraphParams);
                } else {
                    ((FocusManagingPanePage)((Object)c)).updateGraphType(type, params);
                }
            }
            c.requestFocus();
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": doGraphViewModeAction: Unable to set the focus! The pane has no components.");
        }
    }

    public void doViewRangeAction(ActionEvent e) {
        Object source = e.getSource();
        int zoomFactor = -1;
        if (source == this.theViewRangeMenuItems[0]) {
            zoomFactor = 0;
        } else if (source == this.theViewRangeMenuItems[1]) {
            zoomFactor = 1;
        } else if (source == this.theViewRangeMenuItems[2]) {
            zoomFactor = 2;
        } else if (source == this.theViewRangeMenuItems[3]) {
            zoomFactor = 3;
        } else if (source == this.theViewRangeMenuItems[4]) {
            zoomFactor = 4;
        } else if (source == this.theViewRangeMenuItems[5]) {
            zoomFactor = 5;
        } else if (source == this.theViewRangeMenuItems[6]) {
            zoomFactor = 6;
        } else if (source == this.theViewRangeMenuItems[7]) {
            zoomFactor = 7;
        } else if (source == this.theViewRangeMenuItems[8]) {
            zoomFactor = 8;
        } else if (source == this.theViewRangeMenuItems[9]) {
            zoomFactor = 9;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": doViewRangeAction: Index is out of range!");
        }
        if (zoomFactor == -1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": doViewRangeAction: Unidentified source; CANNOT set range!");
        } else {
            MRSGraphManager.getInstance().zoom(zoomFactor);
        }
    }

    public void finishInitialise() {
        super.finishInitialise();
        this.setGraphManagerInError(false);
        if (!MRSGraphManager.getInstance().register(this)) {
            EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: Unable to register with the Graph Manager. Menu functionality will be limited.");
        }
        if (this.theStateMonitor != null) {
            this.theStateMonitor.registerForLatestStateData(this);
            this.theStateMonitor.registerForGraphViewMode(this);
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: Unable to register with the State Monitor. Menu functionality will be limited.");
        }
    }

    private EclActionMenuItem getAddRemoveMenuItem() {
        if (this.theAddRemoveMenuItem == null) {
            this.theAddRemoveMenuItem = new EclActionMenuItem("Add/Remove...", this.getMRSGraphMenuEventHandler());
        }
        return this.theAddRemoveMenuItem;
    }

    private EclActionMenuItem getCloseMenuItem() {
        if (this.theCloseMenuItem == null) {
            this.theCloseMenuItem = new EclActionMenuItem("Close", this.getMRSGraphMenuEventHandler());
        }
        return this.theCloseMenuItem;
    }

    private EclActionMenuItem getDoubleGraphTypeMenuItem() {
        if (this.theDoubleGraphTypeMenuItem == null) {
            this.theDoubleGraphTypeMenuItem = new EclActionMenuItem("Double Graph", this.getMRSGraphMenuEventHandler());
        }
        return this.theDoubleGraphTypeMenuItem;
    }

    private EclActionMenuItem getEndOfDataMenuItem() {
        if (this.theEndOfDataMenuItem == null) {
            this.theEndOfDataMenuItem = new EclActionMenuItem("End of Data", this.getMRSGraphMenuEventHandler());
        }
        return this.theEndOfDataMenuItem;
    }

    public Component getFocusReceiver() {
        return this.theFocusReceiver;
    }

    private int getMaxZoomFactor(long range) {
        int zoomFactor = range <= 60L ? 0 : (range <= 3600L ? 1 : (range <= 43200L ? 2 : (range <= 86400L ? 3 : (range <= 172800L ? 4 : (range <= 259200L ? 5 : (range <= 345600L ? 6 : (range <= 432000L ? 7 : (range <= 518400L ? 8 : 9))))))));
        return zoomFactor;
    }

    private ActionListener getMRSGraphMenuEventHandler() {
        if (this.theMenuEventHandler == null) {
            this.theMenuEventHandler = new MRSGraphMenuEventHandler(this);
        }
        return this.theMenuEventHandler;
    }

    private ActionListener getMRSViewRangeMenuEventHandler() {
        if (this.theViewRangeMenuEventHandler == null) {
            this.theViewRangeMenuEventHandler = new MRSViewRangeMenuEventHandler(this);
        }
        return this.theViewRangeMenuEventHandler;
    }

    private EclActionMenuItem getNextErrorMenuItem() {
        if (this.theNextErrorMenuItem == null) {
            this.theNextErrorMenuItem = new EclActionMenuItem("Next Error/Alarm", this.getMRSGraphMenuEventHandler());
        }
        return this.theNextErrorMenuItem;
    }

    private EclActionMenuItem getPageLeftMenuItem() {
        if (this.thePageLeftMenuItem == null) {
            this.thePageLeftMenuItem = new EclActionMenuItem("Previous Page", this.getMRSGraphMenuEventHandler());
        }
        return this.thePageLeftMenuItem;
    }

    private EclActionMenuItem getPageRightMenuItem() {
        if (this.thePageRightMenuItem == null) {
            this.thePageRightMenuItem = new EclActionMenuItem("Next Page", this.getMRSGraphMenuEventHandler());
        }
        return this.thePageRightMenuItem;
    }

    private EclActionMenuItem getPreviousErrorMenuItem() {
        if (this.thePreviousErrorMenuItem == null) {
            this.thePreviousErrorMenuItem = new EclActionMenuItem("Previous Error/Alarm", this.getMRSGraphMenuEventHandler());
        }
        return this.thePreviousErrorMenuItem;
    }

    private EclActionMenuItem getSessionWindowMenuItem() {
        if (this.theSessionWindowMenuItem == null) {
            this.theSessionWindowMenuItem = new EclActionMenuItem("Session Window", this.getMRSGraphMenuEventHandler());
        }
        return this.theSessionWindowMenuItem;
    }

    private EclActionMenuItem getSingleGraphTypeMenuItem() {
        if (this.theSingleGraphTypeMenuItem == null) {
            this.theSingleGraphTypeMenuItem = new EclActionMenuItem("Single Graph", this.getMRSGraphMenuEventHandler());
        }
        return this.theSingleGraphTypeMenuItem;
    }

    private EclActionMenuItem getStartOfDataMenuItem() {
        if (this.theStartOfDataMenuItem == null) {
            this.theStartOfDataMenuItem = new EclActionMenuItem("Start of Data", this.getMRSGraphMenuEventHandler());
        }
        return this.theStartOfDataMenuItem;
    }

    private EclActionMenuItem getViewRangeMenuItem(int index) {
        if (this.theViewRangeMenuItems == null) {
            this.createViewRangeMenuItems();
        }
        if (index < 0 || index > this.theViewRangeMenuItems.length - 1) {
            return null;
        }
        return this.theViewRangeMenuItems[index];
    }

    public void permanentError() {
        EventLog.instance().log("ERROR: " + this.toString() + ": permanentError: Permanent error occured!");
        this.hasTrappedTransientError = false;
        this.hasTrappedPermanentError = true;
        this.unregister();
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (s == this.theStateMonitor.getGraphViewModeAO()) {
            int value = v.getValue();
            if (value != this.currentGraphViewMode) {
                if (value == 0) {
                    this.getDoubleGraphTypeMenuItem().setVisible(false);
                    this.getSingleGraphTypeMenuItem().setVisible(true);
                    this.currentGraphViewMode = value;
                } else if (value == 1) {
                    this.getSingleGraphTypeMenuItem().setVisible(false);
                    this.getDoubleGraphTypeMenuItem().setVisible(true);
                    this.currentGraphViewMode = value;
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: " + value + " is an invalid value.");
                }
            }
        } else if (s == this.theStateMonitor.getLatestStateAO()) {
            int value = v.getValue();
            if (value != this.latestSessionState.getState() && value >= -1 && value <= 1) {
                if (this.getRootPopupMenu().getEclipseMenuComponent().isVisible() && value == 0 && this.latestSessionState.getState() != -2) {
                    EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: The gating state has changed. This menu is no longer valid.");
                    this.trapTransientError(true);
                }
                this.latestSessionState.setState(value);
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: " + s.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void setFocusReceiver(Component newFocusReceiver) {
        this.theFocusReceiver = newFocusReceiver;
        if (this.theFocusReceiver instanceof GraphTypeHandler) {
            this.theGraphHandler = (GraphTypeHandler)((Object)this.theFocusReceiver);
        }
        this.determineMenuItemsState();
        if (this.currentGraphViewMode == 1 && this.theGraphHandler != null && (this.theGraphHandler.getType() == 2 || this.theGraphHandler.getType() == 1) && this.theGraphHandler.getGraphParameters()[0].groupTitle != null) {
            this.getAddRemoveMenuItem().setEnabled(true);
        } else {
            this.getAddRemoveMenuItem().setEnabled(false);
        }
    }

    public void setGraphManagerInError(boolean inError) {
        if (inError) {
            EventLog.instance().log("ERROR: " + this.toString() + ": setGraphManagerInError: Graph Manager is in error.");
        }
        this.trapTransientError(inError);
    }

    public String toString() {
        return "MRSGraphMenu";
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            this.hasTrappedTransientError = isInError;
            if (this.hasTrappedTransientError && this.getRootPopupMenu().getEclipseMenuComponent().isVisible()) {
                EventLog.instance().log("ERROR: " + this.toString() + ": trapTransientError: An error has occurred. Exiting menu...");
                if (EclipseFocusManager.getInstance().getFocusedComponent() instanceof EclipseMenuElement) {
                    ((EclipseMenuElement)EclipseFocusManager.getInstance().getFocusedComponent()).hideAllPopupInSelectedPath(true);
                }
            }
        }
    }

    public void unregister() {
        MRSGraphManager.getInstance().unregister(this);
        if (this.theStateMonitor != null) {
            this.theStateMonitor.unregisterForLatestStateData(this);
            this.theStateMonitor.unregisterForGraphViewMode(this);
            this.theStateMonitor = null;
        }
        super.unregister();
    }

    public void update(MRSGraphInfo info) {
        this.theGraphInfo = info;
        this.determineMenuItemsState();
    }

    static MRSGraphWindow access$myWindow(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.myWindow;
    }

    static Component access$theFocusReceiver(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.theFocusReceiver;
    }

    static EclActionMenuItem access$getSessionWindowMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getSessionWindowMenuItem();
    }

    static EclActionMenuItem access$getEndOfDataMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getEndOfDataMenuItem();
    }

    static EclActionMenuItem access$getPageLeftMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getPageLeftMenuItem();
    }

    static EclActionMenuItem access$getAddRemoveMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getAddRemoveMenuItem();
    }

    static EclActionMenuItem access$getDoubleGraphTypeMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getDoubleGraphTypeMenuItem();
    }

    static EclActionMenuItem access$getStartOfDataMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getStartOfDataMenuItem();
    }

    static EclActionMenuItem access$getSingleGraphTypeMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getSingleGraphTypeMenuItem();
    }

    static EclActionMenuItem access$getPageRightMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getPageRightMenuItem();
    }

    static EclActionMenuItem access$getCloseMenuItem(MRSGraphMenu mRSGraphMenu) {
        return mRSGraphMenu.getCloseMenuItem();
    }

    class MRSGraphMenuEventHandler
    implements ActionListener {
        /* synthetic */ MRSGraphMenu this$0;

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MRSGraphMenu.access$getPageLeftMenuItem(this.this$0)) {
                MRSGraphManager.getInstance().pageLeft();
                this.this$0.getFocusReceiver().requestFocus();
            } else if (e.getSource() == MRSGraphMenu.access$getPageRightMenuItem(this.this$0)) {
                MRSGraphManager.getInstance().pageRight();
                this.this$0.getFocusReceiver().requestFocus();
            }
            if (e.getSource() == MRSGraphMenu.access$getStartOfDataMenuItem(this.this$0)) {
                MRSGraphManager.getInstance().gotoStart();
                this.this$0.getFocusReceiver().requestFocus();
            } else if (e.getSource() == MRSGraphMenu.access$getEndOfDataMenuItem(this.this$0)) {
                MRSGraphManager.getInstance().gotoEnd();
                this.this$0.getFocusReceiver().requestFocus();
            } else if (e.getSource() == MRSGraphMenu.access$getSingleGraphTypeMenuItem(this.this$0)) {
                this.this$0.doGraphViewModeAction(e);
            } else if (e.getSource() == MRSGraphMenu.access$getDoubleGraphTypeMenuItem(this.this$0)) {
                this.this$0.doGraphViewModeAction(e);
            } else if (e.getSource() == MRSGraphMenu.access$getAddRemoveMenuItem(this.this$0)) {
                MRSGraphMenu.access$myWindow(this.this$0).createAddRemoveDialog(MRSGraphMenu.access$theFocusReceiver(this.this$0));
            } else if (e.getSource() == MRSGraphMenu.access$getSessionWindowMenuItem(this.this$0)) {
                MRSGraphMenu.access$myWindow(this.this$0).processCancelKey(null);
                MRSGraphMenu.access$myWindow(this.this$0).createSessionWindow();
            } else if (e.getSource() == MRSGraphMenu.access$getCloseMenuItem(this.this$0)) {
                MRSGraphMenu.access$myWindow(this.this$0).processCancelKey(null);
            }
        }

        MRSGraphMenuEventHandler(MRSGraphMenu this$0) {
            this.this$0 = this$0;
        }
    }

    class MRSViewRangeMenuEventHandler
    implements ActionListener {
        /* synthetic */ MRSGraphMenu this$0;

        public void actionPerformed(ActionEvent e) {
            this.this$0.doViewRangeAction(e);
            this.this$0.getFocusReceiver().requestFocus();
        }

        MRSViewRangeMenuEventHandler(MRSGraphMenu this$0) {
            this.this$0 = this$0;
        }
    }
}

