/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.menu;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.ConnectedGraphMenuItem;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphParametersHandler;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSMenuDataReceiver;
import com.agilent.tntd.eclipse.mrsgraphs.menu.MrsMenuData;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.lookdefaults.EclMenusDefaults;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMenuItem;
import com.agilent.tntd.eclipse.viewlayer.menus.MenuElementViewer;
import com.agilent.tntd.eclipse.viewlayer.menus.SelfInitialisedMenuElement;
import java.awt.Color;
import java.awt.Component;

abstract class MRSMenuItem
extends EclMenuItem
implements ConnectedGraphMenuItem,
MRSMenuDataReceiver,
SelfInitialisedMenuElement {
    private transient ApplicationObject theApplicationObject = null;
    private transient MrsMenuData theMenuData;

    public MRSMenuItem(String text) {
        super(text);
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(((Component)((Object)this)).toString()) + " failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(((Component)((Object)this)).toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else {
            this.theApplicationObject = anAO;
        }
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("LOCAL", 0, "MRS_CONNECTED_MENU_ITEM", (ApplicationObjectObserver)this);
    }

    protected GraphParametersHandler getParametersHandler() {
        return this.theMenuData == null ? null : this.theMenuData.getParametersHandler();
    }

    private void permanentError() {
        ((Component)((Object)this)).setBackground(EclMenusDefaults.permanentErrorColour);
        this.setEnabled(false);
        this.setVisible(true);
        this.unregister();
    }

    public void receiveMRSMenuData(MrsMenuData aData, ApplicationDataSender aSender) {
        if (aSender == this.theApplicationObject) {
            this.theMenuData = aData;
            this.registerDependencies(aData);
        } else {
            EventLog.instance().log(String.valueOf(((Component)((Object)this)).toString()) + " Error: " + aSender.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    protected abstract void registerDependencies(MrsMenuData var1);

    public void setInContext(boolean inContext) {
        if (inContext != ((Component)((Object)this)).isEnabled()) {
            this.setEnabled(inContext);
            ((Component)((Object)this)).repaint();
        }
    }

    public void setInError(boolean inError) {
        if (inError) {
            ((Component)((Object)this)).setForeground(Color.red);
            ((Component)((Object)this)).setFont(EclMenusDefaults.errorFont);
        } else {
            ((Component)((Object)this)).setForeground(EclMenusDefaults.foreground);
            ((Component)((Object)this)).setFont(EclMenusDefaults.font);
        }
        ((Component)((Object)this)).repaint();
    }

    public void trapTransientError(boolean isInError) {
        if (isInError) {
            this.permanentError();
        }
    }

    public void unregister() {
        if (this.theApplicationObject != null) {
            this.theApplicationObject.unregister((ApplicationObjectObserver)this);
            this.theApplicationObject = null;
        }
        if (this.theMenuData != null) {
            this.unregisterDependencies(this.theMenuData);
            this.theMenuData = null;
        }
        if (this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible((Component)((Object)this));
        }
    }

    protected abstract void unregisterDependencies(MrsMenuData var1);

    public void update(ApplicationData v, ApplicationObject o) {
        try {
            v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(((Component)((Object)this)).toString()) + " doesn't implement the right interface to receive data = " + v.toString() + " from " + o.toString());
            this.permanentError();
        }
    }

    public abstract void informViewer(MenuElementViewer var1);

    public abstract String getInitialisationString();
}

