/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.menu;

import com.agilent.tntd.eclipse.architecture.collection.MapOfSets;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.RegistrableData;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphParameters;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphParametersHandler;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphTypeHandler;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSGraphWindow;
import com.agilent.tntd.eclipse.mrsgraphs.menu.MrsMenuData;
import com.agilent.tntd.eclipse.mrsgraphs.menu.SelectionMenu;
import com.agilent.tntd.eclipse.mrsgraphs.menu.SessionParameters;
import com.agilent.tntd.eclipse.mrsgraphs.multiline.MRSGroupListHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipseMenuElement;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.EclipsePopupMenu;
import com.agilent.tntd.eclipse.viewlayer.architecture.menus.StandAloneMainMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMainMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.EclMenu;
import com.agilent.tntd.eclipse.viewlayer.menus.EclPopupMenu;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.awt.Component;
import java.awt.event.KeyEvent;

public class MenuBridge
implements GraphParametersHandler,
CcConnectedComponent,
KnownLengthStringDataReceiver {
    private MRSGroupListHandler theGroupListHandler;
    private GraphTypeHandler theGraphTypeHandler;
    private MrsMenuData theMenuData;
    private final String sessionNameVariableName = "MRS_SESSION_SELECTED_NAME";
    private ApplicationObject theSessionNameAO = null;
    private String theInContextVariableName;
    private String theInErrorVariableName;
    private boolean hasTrappedTransientError = false;
    private SessionParameters theSessionNameType;
    private static final String popupMenuKeyLocation = "MenuBridge.popupMenuKeyLocation";
    private EclMainMenu theMenu;
    private String theMenuClassName;
    private Object theLock = new Object();
    private SessionTimesParameters theSessionTimesParameters;
    private SelectionMenu theSelectionMenu;
    private MapOfSets theGroups;

    public MenuBridge(String inContextVariableName, String inErrorVariableName, MRSGroupListHandler listHandler) {
        this.theInContextVariableName = inContextVariableName;
        this.theInErrorVariableName = inErrorVariableName;
        this.theGroupListHandler = listHandler;
        this.finishInitialise();
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (anAO.getName().equals("MRS_SESSION_SELECTED_NAME")) {
            this.theSessionNameAO = anAO;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Received an unrequested AO: " + anAO.toString());
        }
    }

    public static void clearPopupMenus() {
        EclipseSystem.instance().getPlatformMap().remove((Object)popupMenuKeyLocation);
    }

    private void createMenu(String aMenuType) {
        Map theTypeToClassMap = (Map)EclipseSystem.instance().getPlatformMap().get((Object)popupMenuKeyLocation);
        if (theTypeToClassMap != null) {
            String className = (String)theTypeToClassMap.get((Object)aMenuType);
            if (this.theMenu == null) {
                this.createMenuFromName(className);
            } else if (!this.theMenuClassName.equals(className)) {
                this.theMenu.unregister();
                this.createMenuFromName(className);
            } else {
                this.trapTransientError(false);
            }
        } else if (this.theMenu != null) {
            this.theMenu.unregister();
            this.setStandardMainMenu(null);
            this.theMenuClassName = null;
        }
    }

    private void createMenuFromName(String aString) {
        this.setStandardMainMenu(null);
        this.theMenuClassName = aString;
        try {
            this.setStandardMainMenu(((StandAloneMainMenu)Class.forName(this.theMenuClassName).newInstance()).getMainMenu());
        }
        catch (ClassNotFoundException e) {
            this.failToCreatePopup(e);
        }
        catch (InstantiationException e) {
            this.failToCreatePopup(e);
        }
        catch (IllegalAccessException e) {
            this.failToCreatePopup(e);
        }
        catch (ClassCastException e) {
            this.failToCreatePopup(e);
        }
    }

    private void failToCreatePopup(Exception e) {
        System.out.println("Impossible to instanciate this Popup Menu because: " + e.toString());
    }

    public void finishInitialise() {
        this.hasTrappedTransientError = true;
        ApplicationManager.instance().request("LOCAL", 0, "MRS_SESSION_SELECTED_NAME", (ApplicationObjectObserver)this);
    }

    public SelectionMenu getSelectionMenu(String aText) {
        if (this.theSelectionMenu == null) {
            this.theSelectionMenu = new SelectionMenu(aText, this.theMenu);
            if (this.theMenu != null) {
                this.theMenu.getEclModel().createPopupMenu((EclMenu)this.theSelectionMenu, null, true);
                this.theMenu.finishInitialise();
            }
            this.theSelectionMenu.setEnabled(!this.hasTrappedTransientError);
        }
        return this.theSelectionMenu;
    }

    private synchronized SessionParameters getSessionNameType() {
        return this.theSessionNameType;
    }

    public void loadGraphIntoGroup(String aGroupName, String aGraphName, String aServerName) {
        if (this.theGroups == null) {
            this.theGroups = new MapOfSets();
        }
        this.theGroups.add((Object)aGroupName, (Object)new MRSGraphParameters(aGroupName, aGraphName, aServerName));
    }

    private void permanentError() {
        EventLog.instance().log("ERROR: GraphManager: permanentError: Permanent error occured, graphs will be unusable");
        this.hasTrappedTransientError = true;
        this.unregister();
    }

    public void receiveKnownLengthStringData(KnownLengthStringValue v, ApplicationDataSender s) {
        if (s == this.theSessionNameAO) {
            String name = v.getValue();
            if (name != null) {
                if (this.setSessionNameType(name)) {
                    if (this.theMenuData == null) {
                        this.theMenuData = new MrsMenuData(this.theInContextVariableName, this.theInErrorVariableName, this);
                        ApplicationManager.instance().loadDataForDomain("LOCAL", "MRS_CONNECTED_MENU_ITEM", (RegistrableData)this.theMenuData);
                    }
                    if (this.theSelectionMenu != null && this.theSelectionMenu.getChildPopupMenu() != null && this.theSelectionMenu.getChildPopupMenu().getEclipseMenuComponent().isVisible() && EclipseFocusManager.getInstance().getFocusedComponent() instanceof EclipseMenuElement) {
                        ((EclipseMenuElement)EclipseFocusManager.getInstance().getFocusedComponent()).hideAllPopupInSelectedPath(true);
                    }
                    this.theMenuData.postSessionTypeObserver(this.getSessionNameType());
                }
            } else {
                if (this.theSelectionMenu != null && this.theSelectionMenu.getChildPopupMenu() != null && this.theSelectionMenu.getChildPopupMenu().getEclipseMenuComponent().isVisible() && EclipseFocusManager.getInstance().getFocusedComponent() instanceof EclipseMenuElement) {
                    ((EclipseMenuElement)EclipseFocusManager.getInstance().getFocusedComponent()).hideAllPopupInSelectedPath(true);
                }
                this.trapTransientError(true);
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveKnownLengthStringData: " + s.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public static void registerPopupMenus(String[][] aKeyValueArray) {
        if (aKeyValueArray != null) {
            HashMap aMap = new HashMap();
            int i = 0;
            while (i < aKeyValueArray.length) {
                aMap.put((Object)aKeyValueArray[i][0], (Object)aKeyValueArray[i][1]);
                ++i;
            }
            EclipseSystem.instance().getPlatformMap().put((Object)popupMenuKeyLocation, (Object)aMap);
        }
    }

    private synchronized boolean setSessionNameType(String aName) {
        boolean hasSet = false;
        if (this.theSessionNameType == null || this.theSessionNameType.getSessionName() != aName) {
            if (aName == null) {
                this.theSessionNameType = null;
            } else {
                this.theSessionNameType = new SessionParameters(aName, this);
                hasSet = true;
            }
        }
        return hasSet;
    }

    private void setStandardMainMenu(EclMainMenu aMainMenu) {
        this.theMenu = aMainMenu;
        if (aMainMenu != null) {
            if (this.theSelectionMenu != null) {
                EclPopupMenu p = aMainMenu.getEclModel().createPopupMenu((EclMenu)this.theSelectionMenu, null, true);
                this.theSelectionMenu.setPopup((EclipsePopupMenu)p);
                this.theGroupListHandler.clearGroups();
                p.finishInitialise();
                if (this.theGroups != null) {
                    this.theGroupListHandler.addGroups(this.theGroups);
                    this.theGroups.removeAll();
                    this.theGroups = null;
                }
                this.trapTransientError(false);
            } else {
                this.trapTransientError(true);
            }
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            this.hasTrappedTransientError = isInError;
            if (this.theSelectionMenu != null) {
                this.theSelectionMenu.setEnabled(!this.hasTrappedTransientError);
                ((Component)((Object)this.theSelectionMenu)).repaint();
            }
        }
    }

    public void unregister() {
        if (this.theSessionNameAO != null) {
            this.theSessionNameAO.unregister((ApplicationObjectObserver)this);
            this.theSessionNameAO = null;
            this.theSessionNameType = null;
        }
        if (this.theMenu != null) {
            this.theMenu.unregister();
            this.theMenu = null;
            this.setStandardMainMenu(null);
        }
        ApplicationManager.instance().unloadDataForDomain("LOCAL", "MRS_CONNECTED_MENU_ITEM");
        if (this.theMenuData != null) {
            this.theMenuData.unregister();
            this.theMenuData = null;
        }
        this.theMenuClassName = null;
        this.theGraphTypeHandler = null;
        this.theSelectionMenu = null;
    }

    public void update(ApplicationData v, ApplicationObject o) {
        try {
            v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": update(v,o): Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
            this.permanentError();
        }
    }

    public void updateParameters(String aGraphTitle, int aGraphType, String[][] anAlarmServerPairSet) {
        MRSGraphParameters[] params = new MRSGraphParameters[anAlarmServerPairSet.length];
        int i = 0;
        while (i < params.length) {
            params[i] = new MRSGraphParameters(aGraphTitle, anAlarmServerPairSet[i][0], anAlarmServerPairSet[i][1]);
            ++i;
        }
        this.theGraphTypeHandler.updateGraphType(aGraphType, params);
        this.theGraphTypeHandler.requestFocus();
    }

    public void updateParameters(String aGroupName, String aGraphTitle, int aGraphType, String aServerName) {
        MRSGraphParameters[] params = new MRSGraphParameters[]{new MRSGraphParameters(aGroupName, aGraphTitle, aServerName)};
        this.theGraphTypeHandler.updateGraphType(aGraphType, params);
        this.theGraphTypeHandler.requestFocus();
    }

    public void updatePopupProperties(KeyEvent e, long aStartTime, long anEndTime, MRSGraphWindow aGraphWindow) {
        if (e.getSource() instanceof GraphTypeHandler) {
            this.theGraphTypeHandler = (GraphTypeHandler)e.getSource();
            if (this.hasTrappedTransientError) {
                aGraphWindow.notifySelectionPopupReady();
            } else {
                SessionParameters param = this.getSessionNameType();
                if (param.getSessionType() == null) {
                    Object object = this.theLock;
                    synchronized (object) {
                        this.theSessionTimesParameters = new SessionTimesParameters(this, aStartTime, anEndTime, aGraphWindow);
                    }
                }
                Object object = this.theLock;
                synchronized (object) {
                    this.theSessionTimesParameters = null;
                }
                this.theMenuData.requestUpdate(param.getSessionName(), aStartTime, anEndTime);
                aGraphWindow.notifySelectionPopupReady();
            }
        } else {
            EventLog.instance().log("WARNING: " + this.toString() + "updatePopupProperties: Event received from " + e.getSource() + ", which is not of type GraphTypeHandler. Graph selection menu may not be available.");
            aGraphWindow.notifySelectionPopupReady();
        }
    }

    public void updateSessionParameters(SessionParameters param) {
        if (param == this.getSessionNameType()) {
            this.createMenu(param.getSessionType());
            if (this.theMenu != null) {
                MRSGraphWindow graphWindow = null;
                Object object = this.theLock;
                synchronized (object) {
                    if (this.theSessionTimesParameters != null) {
                        this.theMenuData.requestUpdate(param.getSessionName(), this.theSessionTimesParameters.startTime, this.theSessionTimesParameters.endTime);
                        graphWindow = this.theSessionTimesParameters.graphWindow;
                        this.theSessionTimesParameters = null;
                    }
                }
                if (graphWindow != null) {
                    graphWindow.notifySelectionPopupReady();
                }
            }
        }
    }

    class SessionTimesParameters {
        /* synthetic */ MenuBridge this$0;
        public final long startTime;
        public final long endTime;
        public final MRSGraphWindow graphWindow;

        public SessionTimesParameters(MenuBridge this$0, long s, long e, MRSGraphWindow g) {
            this.this$0 = this$0;
            this.startTime = s;
            this.endTime = e;
            this.graphWindow = g;
        }
    }
}

