/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.menu;

import com.agilent.tntd.eclipse.architecture.collection.MapOfSets;
import com.agilent.tntd.eclipse.bottomlayer.localdomain.ChangeableApplicationData;
import com.agilent.tntd.eclipse.bottomlayer.localdomain.LocalApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationDomain;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.client.appmodel.RegistrableData;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.ConnectedGraphMenuItem;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphParametersHandler;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSMenuDataReceiver;
import com.agilent.tntd.eclipse.mrsgraphs.menu.SessionParameters;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.IOException;

public class MrsMenuData
extends ChangeableApplicationData
implements CcConnectedComponent,
ApplicationGenericDataReceiver,
RegistrableData {
    private GraphParametersHandler theGraphParametersHandler;
    private String theInContextVariable;
    private ApplicationObject theContextApplicationObject = null;
    private ApplicationGenericData thePreviousContextValue = null;
    private String theInErrorVariable;
    private ApplicationObject theErrorApplicationObject = null;
    private ApplicationGenericData thePreviousErrorValue = null;
    private MapOfSets theSingleNameToMenuItemMap = new MapOfSets();
    private Map theMapOfAlarmGroup = new HashMap();
    private SessionParameters theSessionParameters;

    public MrsMenuData(String inContextVariable, String inErrorVariable, GraphParametersHandler aGraphParameterHandler) {
        this.theInContextVariable = inContextVariable;
        this.theInErrorVariable = inErrorVariable;
        this.theGraphParametersHandler = aGraphParameterHandler;
        this.finishInitialise();
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log(String.valueOf(this.toString()) + " failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (anAO.getName().equals(this.theInContextVariable)) {
            this.theContextApplicationObject = anAO;
            if (this.theContextApplicationObject.getInitialisationState() == 2) {
                this.requestSessionType();
            }
        } else {
            this.theErrorApplicationObject = anAO;
        }
    }

    public boolean change(ApplicationData data) {
        return false;
    }

    public ApplicationObject createApplicationObject(ApplicationDomain aDomain, String aName) {
        return new LocalApplicationObject(aName, aDomain, (ChangeableApplicationData)this);
    }

    private Set createGraphSet(ApplicationGenericData aData, boolean containsType) {
        HashSet aSet = null;
        PrimitiveTypesReader aReader = aData.getPrimitiveTypesReader();
        try {
            if (containsType) {
                aReader.readString();
                aReader.readString();
            }
            int c = aReader.readInt();
            aSet = new HashSet(c);
            int i = 0;
            while (i < c) {
                aSet.add((Object)aReader.readString());
                ++i;
            }
        }
        catch (IOException iOException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " could not understand data from in context or in error variable");
        }
        return aSet;
    }

    private ApplicationMetaData createMeta(String param) {
        ApplicationGenericMetaData m = new ApplicationGenericMetaData();
        PrimitiveTypesWriter writer = m.getPrimitiveTypesWriter();
        try {
            writer.write(param);
        }
        catch (IOException iOException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " could not write meta data for in context variable");
        }
        m.completedMetaDataInitialisation();
        return m;
    }

    private ApplicationMetaData createMeta(String param, long param2, long param3) {
        ApplicationGenericMetaData m = new ApplicationGenericMetaData();
        PrimitiveTypesWriter writer = m.getPrimitiveTypesWriter();
        try {
            writer.write(param);
            writer.write((int)param2);
            writer.write((int)param3);
        }
        catch (IOException iOException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " could not write meta data for in context variable");
        }
        m.completedMetaDataInitialisation();
        return m;
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("ISS", 0, this.theInContextVariable, (ApplicationObjectObserver)this);
        ApplicationManager.instance().request("ISS", 0, this.theInErrorVariable, (ApplicationObjectObserver)this);
    }

    public int getInitialisationState() {
        return 2;
    }

    public GraphParametersHandler getParametersHandler() {
        return this.theGraphParametersHandler;
    }

    private void permanentError() {
        this.unregister();
    }

    public synchronized void postSessionTypeObserver(SessionParameters newSessionParameters) {
        boolean shouldUpdate = newSessionParameters.hasDifferentSession(this.theSessionParameters);
        this.theSessionParameters = newSessionParameters;
        if (shouldUpdate && this.theContextApplicationObject.getInitialisationState() == 2) {
            this.theContextApplicationObject.asyncQuery(this.createMeta(this.theSessionParameters.getSessionName()), (ApplicationObjectObserver)this);
        }
    }

    public void receiveApplicationGenericData(ApplicationGenericData v, ApplicationDataSender o) {
        if (o == this.theContextApplicationObject) {
            if (this.theSessionParameters != null) {
                this.thePreviousContextValue = null;
                this.thePreviousErrorValue = null;
                this.updateSessionType(v);
            } else if (!v.equals((Object)this.thePreviousContextValue)) {
                this.thePreviousContextValue = v;
                this.updateContext(this.createGraphSet(v, true));
            }
        } else if (o == this.theErrorApplicationObject) {
            if (!v.equals((Object)this.thePreviousErrorValue)) {
                this.thePreviousErrorValue = v;
                this.updateError(this.createGraphSet(v, false));
            }
        } else {
            EventLog.instance().log(String.valueOf(this.toString()) + " Error: " + o.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public void receivedBy(ApplicationDataReceiver to, ApplicationDataSender from) throws BadApplicationDataReceiverException {
        if (!(to instanceof MRSMenuDataReceiver)) {
            throw new BadApplicationDataReceiverException();
        }
        MRSMenuDataReceiver m = (MRSMenuDataReceiver)to;
        m.receiveMRSMenuData(this, from);
    }

    public void registerConnectedGraphMenuItem(ConnectedGraphMenuItem aMI, String[][] aNameList) {
        ArrayList aList = new ArrayList(aNameList.length);
        int i = 0;
        while (i < aNameList.length) {
            aList.add((Object)aNameList[i][1]);
            ++i;
        }
        Map map = this.theMapOfAlarmGroup;
        synchronized (map) {
            this.theMapOfAlarmGroup.put((Object)aMI, (Object)aList);
        }
    }

    public void registerConnectedGraphMenuItem(ConnectedGraphMenuItem aMI, String aName) {
        MapOfSets mapOfSets = this.theSingleNameToMenuItemMap;
        synchronized (mapOfSets) {
            this.theSingleNameToMenuItemMap.add((Object)aName, (Object)aMI);
        }
    }

    private synchronized void requestSessionType() {
        if (this.theSessionParameters != null) {
            this.theContextApplicationObject.asyncQuery(this.createMeta(this.theSessionParameters.getSessionName()), (ApplicationObjectObserver)this);
        }
    }

    public void requestUpdate(String aSessionName, long aStartTime, long anEndTime) {
        this.theContextApplicationObject.asyncQuery(this.createMeta(aSessionName), (ApplicationObjectObserver)this);
        this.theErrorApplicationObject.asyncQuery(this.createMeta(aSessionName, aStartTime, anEndTime), (ApplicationObjectObserver)this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append("MrsMenuData[");
        b.append(this.theInContextVariable);
        b.append(" ,");
        b.append(this.theInErrorVariable);
        b.append(" ,");
        b.append(super.toString());
        b.append("]");
        return b.toString();
    }

    public void trapTransientError(boolean isInError) {
        if (isInError) {
            this.permanentError();
        }
    }

    public void unregister() {
        if (this.theContextApplicationObject != null) {
            this.theContextApplicationObject.unregister((ApplicationObjectObserver)this);
            this.theContextApplicationObject = null;
            this.thePreviousContextValue = null;
        }
        if (this.theErrorApplicationObject != null) {
            this.theErrorApplicationObject.unregister((ApplicationObjectObserver)this);
            this.theErrorApplicationObject = null;
            this.thePreviousErrorValue = null;
        }
        this.theGraphParametersHandler = null;
        this.theInContextVariable = null;
        this.theInErrorVariable = null;
        this.theSingleNameToMenuItemMap.removeAll();
        this.theSingleNameToMenuItemMap = null;
        this.theMapOfAlarmGroup.clear();
        this.theMapOfAlarmGroup = null;
    }

    public void unregisterConnectedGraphMenuItem(ConnectedGraphMenuItem aMI, String[][] aNameList) {
        ArrayList aList = new ArrayList(aNameList.length);
        int i = 0;
        while (i < aNameList.length) {
            aList.add((Object)aNameList[i][1]);
            ++i;
        }
        Map map = this.theMapOfAlarmGroup;
        synchronized (map) {
            List l = (List)this.theMapOfAlarmGroup.get((Object)aMI);
            l.clear();
            this.theMapOfAlarmGroup.remove((Object)aMI);
        }
    }

    public void unregisterConnectedGraphMenuItem(ConnectedGraphMenuItem aMI, String aName) {
        MapOfSets mapOfSets = this.theSingleNameToMenuItemMap;
        synchronized (mapOfSets) {
            this.theSingleNameToMenuItemMap.remove((Object)aName, (Object)aMI);
        }
    }

    public void update(ApplicationData v, ApplicationObject o) {
        try {
            if (v != null) {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " doesn't implement the right interface to receive data = " + v.toString() + " from " + o.toString());
            this.permanentError();
        }
    }

    private void updateContext(Set aSet) {
        ConnectedGraphMenuItem aCGMI;
        Iterator anIterator;
        MapOfSets mapOfSets = this.theSingleNameToMenuItemMap;
        synchronized (mapOfSets) {
            anIterator = this.theSingleNameToMenuItemMap.getKeyIterator();
            while (anIterator.hasNext()) {
                Object key = anIterator.next();
                boolean inContext = aSet.contains(key);
                Iterator theMIIterator = this.theSingleNameToMenuItemMap.getSet(key).iterator();
                while (theMIIterator.hasNext()) {
                    aCGMI = (ConnectedGraphMenuItem)theMIIterator.next();
                    aCGMI.setInContext(inContext);
                }
            }
        }
        mapOfSets = this.theMapOfAlarmGroup;
        synchronized (mapOfSets) {
            anIterator = this.theMapOfAlarmGroup.entrySet().iterator();
            while (anIterator.hasNext()) {
                Map.Entry anEntry = (Map.Entry)anIterator.next();
                aCGMI = (ConnectedGraphMenuItem)anEntry.getKey();
                Iterator aListIterator = ((List)anEntry.getValue()).iterator();
                boolean notFound = true;
                while (aListIterator.hasNext() && notFound) {
                    Object value = aListIterator.next();
                    if (!aSet.contains(value)) continue;
                    notFound = false;
                }
                if (!notFound) {
                    aCGMI.setInContext(true);
                    continue;
                }
                aCGMI.setInContext(false);
            }
        }
    }

    private void updateError(Set aSet) {
        ConnectedGraphMenuItem aCGMI;
        Iterator anIterator;
        MapOfSets mapOfSets = this.theSingleNameToMenuItemMap;
        synchronized (mapOfSets) {
            anIterator = this.theSingleNameToMenuItemMap.getKeyIterator();
            while (anIterator.hasNext()) {
                Object key = anIterator.next();
                boolean inContext = aSet.contains(key);
                Iterator theMIIterator = this.theSingleNameToMenuItemMap.getSet(key).iterator();
                while (theMIIterator.hasNext()) {
                    aCGMI = (ConnectedGraphMenuItem)theMIIterator.next();
                    aCGMI.setInError(inContext);
                }
            }
        }
        mapOfSets = this.theMapOfAlarmGroup;
        synchronized (mapOfSets) {
            anIterator = this.theMapOfAlarmGroup.entrySet().iterator();
            while (anIterator.hasNext()) {
                Map.Entry anEntry = (Map.Entry)anIterator.next();
                aCGMI = (ConnectedGraphMenuItem)anEntry.getKey();
                Iterator aListIterator = ((List)anEntry.getValue()).iterator();
                boolean notFound = true;
                while (aListIterator.hasNext() && notFound) {
                    Object value = aListIterator.next();
                    if (!aSet.contains(value)) continue;
                    notFound = false;
                }
                if (!notFound) {
                    aCGMI.setInError(true);
                    continue;
                }
                aCGMI.setInError(false);
            }
        }
    }

    private synchronized void updateSessionType(ApplicationGenericData aData) {
        PrimitiveTypesReader aReader = aData.getPrimitiveTypesReader();
        try {
            String sessionName = aReader.readString();
            String sessionType = aReader.readString();
            SessionParameters p = this.theSessionParameters;
            this.theSessionParameters = null;
            p.update(sessionName, sessionType);
        }
        catch (IOException iOException) {
            EventLog.instance().log(String.valueOf(this.toString()) + " could not understand the session type");
        }
    }
}

