/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.multiline;

import com.agilent.tntd.eclipse.architecture.collection.MapOfSets;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphParameters;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;

public class MRSGroupListHandler {
    private Map theMap = null;

    public MRSGroupListHandler() {
        this.initialize();
    }

    public void addGroups(MapOfSets aMapOfSets) {
        if (aMapOfSets != null) {
            Iterator aKeyIterator = aMapOfSets.getKeyIterator();
            while (aKeyIterator.hasNext()) {
                String aKey = (String)aKeyIterator.next();
                this.createGroup(aKey, aMapOfSets.getSet((Object)aKey));
            }
        }
    }

    public void clearGroups() {
        this.theMap.clear();
    }

    private void createGroup(String aGroupName, Set aSet) {
        Object[] anArray = new MRSGraphParameters[aSet.size()];
        aSet.toArray(anArray);
        this.theMap.put((Object)aGroupName, (Object)anArray);
    }

    public MRSGraphParameters[] getParameters(String group) {
        MRSGraphParameters[] params;
        try {
            params = (MRSGraphParameters[])this.theMap.get((Object)group);
        }
        catch (Exception e) {
            EventLog.instance().log("ERROR: " + this.toString() + ": getParameters: The following error occurred: " + e.getMessage() + ". Unable to retrieve parameters for group " + group);
            params = null;
        }
        return params;
    }

    private void initialize() {
        this.theMap = new HashMap();
    }

    public String toString() {
        return "MRSGroupListHandler";
    }
}

