/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.multiline;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.common.data.CcComponent;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.mrsgraphs.common.DatasetAttributes;
import com.agilent.tntd.eclipse.mrsgraphs.containers.GraphPane;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.components.line.EclLine;

public class MultipleLineGraphSupport
implements CcComponent {
    private final transient String theInclusiveGraphListVariableName = "MRS_GRAPHS_INCLUSIVE_LIST";
    private transient ApplicationObject theInclusiveGraphListAO = null;
    private transient GraphPane theGraphPane;
    private transient DatasetAttributeComponents[] datasetAttributeComponents = null;

    public void finishInitialise() {
        this.hideAllComponents();
    }

    public void hideAllComponents() {
        if (this.datasetAttributeComponents == null) {
            return;
        }
        int i = 0;
        while (i < this.datasetAttributeComponents.length) {
            this.datasetAttributeComponents[i].line.setVisible(false);
            this.datasetAttributeComponents[i].nameLabel.setVisible(false);
            this.datasetAttributeComponents[i].cursorValueLabel.setVisible(false);
            ++i;
        }
    }

    public void setDatasetAttributeComponents(EclLine[] lines, BasicLabel[] graphNameLabels, BasicLabel[] cursorValueLabels) {
        int length = lines.length;
        if (length != graphNameLabels.length || length != cursorValueLabels.length) {
            EventLog.instance().log("ERROR: " + this.toString() + ": setDatasetAttributeComponents: inconsistent dataset attributes passed in. Returning.");
            return;
        }
        this.datasetAttributeComponents = new DatasetAttributeComponents[length];
        int i = 0;
        while (i < length) {
            this.datasetAttributeComponents[i] = new DatasetAttributeComponents(this, lines[i], graphNameLabels[i], cursorValueLabels[i]);
            ++i;
        }
    }

    public void setDatasetAttributes(DatasetAttributes[] attributes) {
        int length = 0;
        if (attributes != null && (length = attributes.length) > this.datasetAttributeComponents.length) {
            EventLog.instance().log("ERROR: " + this.toString() + ": setDatasetAttributes: There are more attributes than components to display them in the graph window.");
            length = this.datasetAttributeComponents.length;
        }
        this.hideAllComponents();
        int i = 0;
        while (i < length) {
            this.datasetAttributeComponents[i].line.setVisible(true);
            this.datasetAttributeComponents[i].nameLabel.setText(attributes[i].title);
            this.datasetAttributeComponents[i].nameLabel.setVisible(true);
            this.datasetAttributeComponents[i].cursorValueLabel.setText(attributes[i].cursorValue);
            this.datasetAttributeComponents[i].cursorValueLabel.setVisible(true);
            ++i;
        }
    }

    public void setTheGraphPane(GraphPane newGraphPane) {
        this.theGraphPane = newGraphPane;
        if (this.theGraphPane != null) {
            this.theGraphPane.setMultiLineGraphSupport(this);
        }
    }

    public void unregister() {
        this.hideAllComponents();
    }

    public void updateDatasetCursorValues(String[] values) {
        int length = values.length;
        if (length > this.datasetAttributeComponents.length) {
            EventLog.instance().log("ERROR: " + this.toString() + ": updateDatasetCursorValues: There are more cursor values than components to display them in the graph window.");
            length = this.datasetAttributeComponents.length;
        }
        int i = 0;
        while (i < length) {
            this.datasetAttributeComponents[i].cursorValueLabel.setText(values[i]);
            ++i;
        }
    }

    private class DatasetAttributeComponents {
        /* synthetic */ MultipleLineGraphSupport this$0;
        public final EclLine line;
        public final BasicLabel nameLabel;
        public final BasicLabel cursorValueLabel;

        public DatasetAttributeComponents(MultipleLineGraphSupport this$0, EclLine line, BasicLabel nameLabel, BasicLabel cursorValueLabel) {
            this.this$0 = this$0;
            this.line = line;
            this.nameLabel = nameLabel;
            this.cursorValueLabel = cursorValueLabel;
        }
    }
}

