/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.windows;

import com.agilent.tntd.eclipse.bottomlayer.localdomain.LocalDomainBean;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphParameters;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSLatestSessionState;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSStateMonitor;
import com.agilent.tntd.eclipse.mrsgraphs.components.SimpleListComponent;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphTypeHandler;
import com.agilent.tntd.eclipse.mrsgraphs.multiline.MRSGroupListHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButton;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPane;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindowModel;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowHandler;
import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AddRemoveDialog
extends EclWindow
implements CcConnectedComponent,
MaskedIntegerDataReceiver {
    private final transient int ADD_REMOVE_PANE_PAGE = 0;
    private final transient int INVALID_PANE_PAGE = 1;
    private transient GraphTypeHandler theGraphHandler = null;
    private transient MRSGroupListHandler theListHandler = null;
    private MRSStateMonitor theStateMonitor;
    private MRSLatestSessionState latestSessionState = new MRSLatestSessionState();
    private int currentGraphViewMode = -1;
    private transient ArrayList theInclusiveList = null;
    private transient ArrayList theExclusiveList = null;
    private final transient String addRemovePaneDBVariableName = "MRS_ADD_REMOVE_PANE";
    private transient ApplicationObject addRemovePaneAO = null;
    private transient MaskedIntegerValue addRemovePaneValue = null;
    private transient boolean hasTrappedTransientError = false;
    private transient boolean hasTrappedPermanentError = false;
    private SimpleListComponent ivjInclusiveList = null;
    private SimpleListComponent ivjExclusiveList = null;
    private EclButton ivjMoveItemsLeftButton = null;
    private EclButton ivjMoveItemsRightButton = null;
    private EclButton ivjClose = null;
    private EclLabel ivjInvalidMessageLabel1 = null;
    private EclLabel ivjInvalidMessageLabel2 = null;
    private EclPane ivjEclPane1 = null;
    private EclPanePage ivjAddRemovePanePage = null;
    private EclPanePage ivjInvalidPanePage = null;
    private ModalWindowHandler ivjModalWindowHandler1 = null;
    private LocalDomainBean ivjLocalDomainBean1 = null;
    private EclLabel ivjExclusiveLabel = null;
    private EclLabel ivjInclusiveLabel = null;
    private BasicLabel ivjGroupLabel = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);

    public AddRemoveDialog() {
        this.initialize();
    }

    public AddRemoveDialog(GraphTypeHandler graphHandler, MRSGroupListHandler listHandler, MRSStateMonitor aMonitor) {
        this.theGraphHandler = graphHandler;
        this.theListHandler = listHandler;
        this.theStateMonitor = aMonitor;
        this.initialize();
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        } else if (anAO.getName().equals("MRS_ADD_REMOVE_PANE")) {
            this.addRemovePaneAO = anAO;
            if (this.addRemovePaneAO.getInitialisationState() == 2) {
                if (this.hasTrappedTransientError) {
                    this.addRemovePaneAO.change((ApplicationData)new MaskedIntegerValue(1));
                } else {
                    this.addRemovePaneAO.change((ApplicationData)new MaskedIntegerValue(0));
                }
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Received an unrequested AO: " + anAO.toString());
        }
    }

    public void close_Action() {
        int size;
        int type = this.theGraphHandler.getType();
        if (this.addRemovePaneValue.getValue() == 0 && this.theInclusiveList != null && (size = this.theInclusiveList.size()) > 0) {
            MRSGraphParameters[] params = new MRSGraphParameters[size];
            int i = 0;
            while (i < size) {
                params[i] = (MRSGraphParameters)this.theInclusiveList.get(i);
                ++i;
            }
            this.theGraphHandler.updateGraphType(type, params);
        }
        this.getModalWindowHandler1().removeModalWindow();
    }

    private void connEtoC1() {
        try {
            this.moveItemsLeftButton_Action();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.moveItemsRightButton_Action();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.close_Action();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.getModalWindowHandler1().setWindow((InternalWindow)this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.getEclPane1().setDomainName(this.getLocalDomainBean1().getDomainName());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void determineButtonStates() {
        if (this.getInclusiveList().getListSize() <= 1) {
            this.getMoveItemsRightButton().setGreying(true, true);
        } else {
            this.getMoveItemsRightButton().setGreying(false, true);
        }
        if (this.getExclusiveList().getListSize() < 1 || this.getInclusiveList().getListSize() >= 6) {
            this.getMoveItemsLeftButton().setGreying(true, true);
        } else {
            this.getMoveItemsLeftButton().setGreying(false, true);
        }
    }

    public void finishInitialise() {
        super.finishInitialise();
        if (this.theStateMonitor != null) {
            this.theStateMonitor.registerForLatestStateData(this);
            this.theStateMonitor.registerForGraphViewMode(this);
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise(): Unable to register with the state monitor.");
        }
        ApplicationManager.instance().request("LOCAL", 0, "MRS_ADD_REMOVE_PANE", (ApplicationObjectObserver)this);
        this.initializeLists();
    }

    private EclPanePage getAddRemovePanePage() {
        if (this.ivjAddRemovePanePage == null) {
            try {
                this.ivjAddRemovePanePage = new EclPanePage();
                this.ivjAddRemovePanePage.setName("AddRemovePanePage");
                this.ivjAddRemovePanePage.setBounds(31, 294, 400, 165);
                this.getAddRemovePanePage().add((Component)((Object)this.getInclusiveList()), ((Component)((Object)this.getInclusiveList())).getName());
                this.getAddRemovePanePage().add((Component)((Object)this.getExclusiveList()), ((Component)((Object)this.getExclusiveList())).getName());
                this.getAddRemovePanePage().add((Component)this.getMoveItemsLeftButton(), this.getMoveItemsLeftButton().getName());
                this.getAddRemovePanePage().add((Component)this.getMoveItemsRightButton(), this.getMoveItemsRightButton().getName());
                this.getAddRemovePanePage().add((Component)this.getInclusiveLabel(), this.getInclusiveLabel().getName());
                this.getAddRemovePanePage().add((Component)this.getExclusiveLabel(), this.getExclusiveLabel().getName());
                this.getAddRemovePanePage().add((Component)this.getGroupLabel(), this.getGroupLabel().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAddRemovePanePage;
    }

    private static void getBuilderData() {
    }

    private EclButton getClose() {
        if (this.ivjClose == null) {
            try {
                this.ivjClose = new EclButton();
                this.ivjClose.setName("Close");
                this.ivjClose.setLocation(168, 195);
                this.ivjClose.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "Close", null));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClose;
    }

    public Component getComponentFromMethod(Method m) throws InvocationTargetException, IllegalAccessException {
        return (Component)m.invoke((Object)this, null);
    }

    private EclPane getEclPane1() {
        if (this.ivjEclPane1 == null) {
            try {
                this.ivjEclPane1 = new EclPane();
                this.ivjEclPane1.setName("EclPane1");
                this.ivjEclPane1.setBounds(4, 24, 400, 165);
                this.ivjEclPane1.setEclModel(new EclPaneModel("MRS_ADD_REMOVE_PANE", new String[]{"AddRemovePanePage", "InvalidPanePage"}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEclPane1;
    }

    private EclLabel getExclusiveLabel() {
        if (this.ivjExclusiveLabel == null) {
            try {
                this.ivjExclusiveLabel = new EclLabel();
                this.ivjExclusiveLabel.setName("ExclusiveLabel");
                this.ivjExclusiveLabel.setBounds(258, 32, 102, 16);
                this.ivjExclusiveLabel.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"Excluded Datasets"}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExclusiveLabel;
    }

    private SimpleListComponent getExclusiveList() {
        if (this.ivjExclusiveList == null) {
            try {
                this.ivjExclusiveList = new SimpleListComponent();
                ((Component)((Object)this.ivjExclusiveList)).setName("ExclusiveList");
                this.ivjExclusiveList.setBounds(226, 50, 166, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExclusiveList;
    }

    private BasicLabel getGroupLabel() {
        if (this.ivjGroupLabel == null) {
            try {
                this.ivjGroupLabel = new BasicLabel();
                this.ivjGroupLabel.setName("GroupLabel");
                this.ivjGroupLabel.setText("Group Name");
                this.ivjGroupLabel.setBounds(29, 8, 341, 15);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGroupLabel;
    }

    private EclLabel getInclusiveLabel() {
        if (this.ivjInclusiveLabel == null) {
            try {
                this.ivjInclusiveLabel = new EclLabel();
                this.ivjInclusiveLabel.setName("InclusiveLabel");
                this.ivjInclusiveLabel.setBounds(39, 32, 102, 16);
                this.ivjInclusiveLabel.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"Included Datasets"}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInclusiveLabel;
    }

    private SimpleListComponent getInclusiveList() {
        if (this.ivjInclusiveList == null) {
            try {
                this.ivjInclusiveList = new SimpleListComponent();
                ((Component)((Object)this.ivjInclusiveList)).setName("InclusiveList");
                this.ivjInclusiveList.setBounds(7, 50, 166, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInclusiveList;
    }

    private EclLabel getInvalidMessageLabel1() {
        if (this.ivjInvalidMessageLabel1 == null) {
            try {
                this.ivjInvalidMessageLabel1 = new EclLabel();
                this.ivjInvalidMessageLabel1.setName("InvalidMessageLabel1");
                this.ivjInvalidMessageLabel1.setBounds(108, 65, 184, 20);
                this.ivjInvalidMessageLabel1.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"This window is not currently valid."}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInvalidMessageLabel1;
    }

    private EclLabel getInvalidMessageLabel2() {
        if (this.ivjInvalidMessageLabel2 == null) {
            try {
                this.ivjInvalidMessageLabel2 = new EclLabel();
                this.ivjInvalidMessageLabel2.setName("InvalidMessageLabel2");
                this.ivjInvalidMessageLabel2.setBounds(118, 85, 164, 20);
                this.ivjInvalidMessageLabel2.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"Press the Close button to exit."}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInvalidMessageLabel2;
    }

    private EclPanePage getInvalidPanePage() {
        if (this.ivjInvalidPanePage == null) {
            try {
                this.ivjInvalidPanePage = new EclPanePage();
                this.ivjInvalidPanePage.setName("InvalidPanePage");
                this.ivjInvalidPanePage.setBounds(31, 480, 400, 165);
                this.getInvalidPanePage().add((Component)this.getInvalidMessageLabel1(), this.getInvalidMessageLabel1().getName());
                this.getInvalidPanePage().add((Component)this.getInvalidMessageLabel2(), this.getInvalidMessageLabel2().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInvalidPanePage;
    }

    private LocalDomainBean getLocalDomainBean1() {
        if (this.ivjLocalDomainBean1 == null) {
            try {
                this.ivjLocalDomainBean1 = new LocalDomainBean();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLocalDomainBean1;
    }

    private ModalWindowHandler getModalWindowHandler1() {
        if (this.ivjModalWindowHandler1 == null) {
            try {
                this.ivjModalWindowHandler1 = new ModalWindowHandler();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjModalWindowHandler1;
    }

    private EclButton getMoveItemsLeftButton() {
        if (this.ivjMoveItemsLeftButton == null) {
            try {
                this.ivjMoveItemsLeftButton = new EclButton();
                this.ivjMoveItemsLeftButton.setName("MoveItemsLeftButton");
                this.ivjMoveItemsLeftButton.setFont(new Font("sansserif", 0, 14));
                this.ivjMoveItemsLeftButton.setBounds(180, 95, 39, 20);
                this.ivjMoveItemsLeftButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "<<", null));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMoveItemsLeftButton;
    }

    private EclButton getMoveItemsRightButton() {
        if (this.ivjMoveItemsRightButton == null) {
            try {
                this.ivjMoveItemsRightButton = new EclButton();
                this.ivjMoveItemsRightButton.setName("MoveItemsRightButton");
                this.ivjMoveItemsRightButton.setFont(new Font("sansserif", 0, 14));
                this.ivjMoveItemsRightButton.setBounds(180, 125, 39, 20);
                this.ivjMoveItemsRightButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, ">>", null));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMoveItemsRightButton;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getMoveItemsLeftButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getMoveItemsRightButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getClose().addActionListener((ActionListener)this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
    }

    private void initialize() {
        try {
            ((Component)((Object)this)).setName("AddRemoveDialog");
            ((Component)((Object)this)).setSize(407, 228);
            this.setEclModel(new EclWindowModel(0, 3, 2, null, "Add and Remove Datasets"));
            ((Container)((Object)this)).add((Component)this.getClose(), this.getClose().getName());
            ((Container)((Object)this)).add((Component)this.getEclPane1(), this.getEclPane1().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void initializeLists() {
        if (this.theGraphHandler == null || this.theListHandler == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": initializeLists: Graph and list handlers NOT defined. Cannot initialize lists.");
            return;
        }
        MRSGraphParameters[] params = this.theGraphHandler.getGraphParameters();
        if (params == null || params.length <= 0) {
            EventLog.instance().log("ERROR: " + this.toString() + ": initializeLists: No graph parameters for inclusive list. Cannot initialize lists.");
            this.trapTransientError(true);
            return;
        }
        this.getGroupLabel().setText(params[0].groupTitle);
        this.theInclusiveList = new ArrayList();
        int i = 0;
        while (i < params.length) {
            this.theInclusiveList.add((Object)params[i]);
            ++i;
        }
        params = this.theListHandler.getParameters(params[0].groupTitle);
        if (params == null || params.length <= 0) {
            EventLog.instance().log("ERROR: " + this.toString() + ": initializeLists: No graph parameters for exclusive list. Cannot initialize lists.");
            this.trapTransientError(true);
            return;
        }
        this.theExclusiveList = new ArrayList();
        i = 0;
        while (i < params.length) {
            this.theExclusiveList.add((Object)params[i]);
            ++i;
        }
        this.populateLists();
        this.trapTransientError(false);
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            AddRemoveDialog aAddRemoveDialog = new AddRemoveDialog(null, null, null);
            frame.add("Center", (Component)((Object)aAddRemoveDialog));
            ((Component)frame).setSize(((Component)((Object)aAddRemoveDialog)).getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow");
            exception.printStackTrace(System.out);
        }
    }

    public void moveItemsLeftButton_Action() {
        String item = this.getExclusiveList().getSelectedString();
        int i = 0;
        while (i < this.theExclusiveList.size()) {
            MRSGraphParameters params = (MRSGraphParameters)this.theExclusiveList.get(i);
            if (params.graphTitle.equals(item)) {
                this.theInclusiveList.add((Object)params);
                this.populateLists();
                break;
            }
            ++i;
        }
    }

    public void moveItemsRightButton_Action() {
        int index = this.getInclusiveList().getSelectedIndex();
        this.theInclusiveList.remove(index);
        this.populateLists();
    }

    public void permanentError() {
        this.setBackground(GraphDefaults.permanentErrorColour);
        this.setForeground(GraphDefaults.permanentErrorColour);
        this.hasTrappedPermanentError = true;
        this.hasTrappedTransientError = false;
        ((Component)((Object)this)).setVisible(true);
        this.unregister();
    }

    private void populateLists() {
        if (this.theInclusiveList == null || this.theExclusiveList == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": populateLists: Lists are null.");
            return;
        }
        int iSize = this.theInclusiveList.size();
        String[] inclusiveList = null;
        if (iSize > 0) {
            inclusiveList = new String[iSize];
            int i = 0;
            while (i < iSize) {
                inclusiveList[i] = ((MRSGraphParameters)this.theInclusiveList.get((int)i)).graphTitle;
                ++i;
            }
        }
        int eSize = this.theExclusiveList.size();
        String[] exclusiveList = null;
        if (eSize > 0) {
            ArrayList tempExclusiveList = new ArrayList();
            int i = 0;
            while (i < eSize) {
                tempExclusiveList.add((Object)((MRSGraphParameters)this.theExclusiveList.get((int)i)).graphTitle);
                ++i;
            }
            i = 0;
            while (i < iSize) {
                tempExclusiveList.remove((Object)inclusiveList[i]);
                ++i;
            }
            int tSize = tempExclusiveList.size();
            if (tSize > 0) {
                exclusiveList = new String[tSize];
                int i2 = 0;
                while (i2 < tSize) {
                    exclusiveList[i2] = tempExclusiveList.get(i2).toString();
                    ++i2;
                }
            }
        }
        this.getInclusiveList().setList(inclusiveList);
        this.getExclusiveList().setList(exclusiveList);
        this.determineButtonStates();
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (s == this.addRemovePaneAO) {
            if (v != this.addRemovePaneValue) {
                this.addRemovePaneValue = v;
            }
        } else if (s == this.theStateMonitor.getLatestStateAO()) {
            int value = v.getValue();
            if (value != this.latestSessionState.getState()) {
                this.latestSessionState.setState(value);
                if (value == 0) {
                    this.trapTransientError(true);
                }
            }
        } else if (s == this.theStateMonitor.getGraphViewModeAO()) {
            int value = v.getValue();
            if (value != this.currentGraphViewMode) {
                this.currentGraphViewMode = value;
                if (value == 0) {
                    this.trapTransientError(true);
                }
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: " + s.toString() + " should not communicate with this observer.");
            this.permanentError();
        }
    }

    public String toString() {
        return ((Component)((Object)this)).getName() == null || ((Component)((Object)this)).getName().equalsIgnoreCase("") ? "AddRemoveDialog" : ((Component)((Object)this)).getName();
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            this.hasTrappedTransientError = isInError;
            if (this.addRemovePaneAO != null && this.addRemovePaneAO.getInitialisationState() == 2) {
                if (this.hasTrappedTransientError) {
                    this.addRemovePaneAO.change((ApplicationData)new MaskedIntegerValue(1));
                } else {
                    this.addRemovePaneAO.change((ApplicationData)new MaskedIntegerValue(0));
                }
            }
        }
    }

    public void unregister() {
        if (this.theStateMonitor != null) {
            this.theStateMonitor.unregisterForLatestStateData(this);
            this.theStateMonitor.unregisterForGraphViewMode(this);
            this.theStateMonitor = null;
        }
        if (this.addRemovePaneAO != null) {
            this.addRemovePaneAO.unregister((ApplicationObjectObserver)this);
            this.addRemovePaneAO = null;
        }
        super.unregister();
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update: Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
                this.permanentError();
            }
        }
    }

    static EclButton access$getMoveItemsRightButton(AddRemoveDialog addRemoveDialog) {
        return addRemoveDialog.getMoveItemsRightButton();
    }

    static EclButton access$getClose(AddRemoveDialog addRemoveDialog) {
        return addRemoveDialog.getClose();
    }

    static void access$connEtoC3(AddRemoveDialog addRemoveDialog) {
        addRemoveDialog.connEtoC3();
    }

    static void access$connEtoC2(AddRemoveDialog addRemoveDialog) {
        addRemoveDialog.connEtoC2();
    }

    static EclButton access$getMoveItemsLeftButton(AddRemoveDialog addRemoveDialog) {
        return addRemoveDialog.getMoveItemsLeftButton();
    }

    static void access$connEtoC1(AddRemoveDialog addRemoveDialog) {
        addRemoveDialog.connEtoC1();
    }

    class IvjEventHandler
    implements ActionListener {
        /* synthetic */ AddRemoveDialog this$0;

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == AddRemoveDialog.access$getMoveItemsLeftButton(this.this$0)) {
                AddRemoveDialog.access$connEtoC1(this.this$0);
            }
            if (e.getSource() == AddRemoveDialog.access$getMoveItemsRightButton(this.this$0)) {
                AddRemoveDialog.access$connEtoC2(this.this$0);
            }
            if (e.getSource() == AddRemoveDialog.access$getClose(this.this$0)) {
                AddRemoveDialog.access$connEtoC3(this.this$0);
            }
        }

        IvjEventHandler(AddRemoveDialog this$0) {
            this.this$0 = this$0;
        }
    }
}

