/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.windows;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.mrsgraphs.alarms.AlarmPlot;
import com.agilent.tntd.eclipse.mrsgraphs.common.Epoch;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphEventHandler;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSGraphManager;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSStateMonitor;
import com.agilent.tntd.eclipse.mrsgraphs.containers.FocusManagingPanePage;
import com.agilent.tntd.eclipse.mrsgraphs.containers.GraphPane;
import com.agilent.tntd.eclipse.mrsgraphs.containers.SingleGraphPanePage;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.GraphTypeHandler;
import com.agilent.tntd.eclipse.mrsgraphs.interfaces.MRSGraphWindow;
import com.agilent.tntd.eclipse.mrsgraphs.menu.MRSGraphMenu;
import com.agilent.tntd.eclipse.mrsgraphs.menu.MenuBridge;
import com.agilent.tntd.eclipse.mrsgraphs.multiline.MRSGroupListHandler;
import com.agilent.tntd.eclipse.mrsgraphs.windows.AddRemoveDialog;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPane;
import com.agilent.tntd.eclipse.viewlayer.containers.pane.EclPaneModel;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePageModel;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindowModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GraphWindow
extends EclWindow
implements MRSGraphWindow {
    private MRSGraphMenu theGraphMenu;
    private MRSGroupListHandler theGroupListHandler;
    private MRSStateMonitor theStateMonitor;
    private MenuBridge theMenuBridge;
    private MRSGraphEventHandler ivjMRSGraphEventHandler1 = null;
    private AlarmPlot ivjAlarmSummaryGraph = null;
    private AlarmPlot ivjErrorSummaryGraph = null;
    private EclPanePage ivjSummaryGraphPanePage = null;
    private FocusManagingPanePage ivjDoubleGraphPanePage = null;
    private SingleGraphPanePage ivjSingleGraphPanePage = null;
    private GraphPane ivjGraphPane2 = null;
    private EclPane ivjEclPane1 = null;
    private GraphPane ivjGraphPane3 = null;

    public GraphWindow() {
        this.initialize();
    }

    protected void connectToWorkspace(EclipseWorkspace w) {
        this.getEclModel().connectToWorkspace(w, (UnconsumedKeyHandler)this.getMRSGraphEventHandler1());
    }

    private void connPtoP1SetTarget() {
        try {
            this.getMRSGraphEventHandler1().setWindow((InternalWindow)this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void createAddRemoveDialog(Component focusReceiver) {
        if (focusReceiver instanceof GraphTypeHandler) {
            try {
                AddRemoveDialog w = new AddRemoveDialog((GraphTypeHandler)((Object)focusReceiver), this.theGroupListHandler, this.theStateMonitor);
                WindowManager.instance().connectWindow((InternalWindow)w);
                w.finishInitialise();
            }
            catch (Throwable e) {
                EventLog.instance().log("ERROR: " + this.toString() + ": createAddRemoveDialog: Error creating Add/Remove dialog. Stack trace follows.");
                e.printStackTrace();
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": createAddRemoveDialog: Cannot create Add/Remove dialog. Focus receiver is NOT an instance of GraphTypeHandler.");
        }
    }

    public void createSessionWindow() {
        try {
            WindowManager.instance().createWindow("com.agilent.tntd.eclipse.mrsgraphs.windows.SessionWindow");
        }
        catch (Throwable e) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createSessionWindow: Error creating Session Window. Stack trace follows.");
            e.printStackTrace();
        }
    }

    public void finishInitialise() {
        super.finishInitialise();
        this.theGroupListHandler = new MRSGroupListHandler();
        this.theStateMonitor = new MRSStateMonitor();
        this.theStateMonitor.finishInitialise();
        this.theMenuBridge = new MenuBridge("MRS_INCONTEXT_NAMES", "MRS_ERRORED_NAMES", this.theGroupListHandler);
        this.getGraphMainMenu().finishInitialise();
    }

    private AlarmPlot getAlarmSummaryGraph() {
        if (this.ivjAlarmSummaryGraph == null) {
            try {
                this.ivjAlarmSummaryGraph = new AlarmPlot();
                this.ivjAlarmSummaryGraph.setName("AlarmSummaryGraph");
                this.ivjAlarmSummaryGraph.setGraphTitle("Alarms");
                this.ivjAlarmSummaryGraph.setDrawDates(false);
                this.ivjAlarmSummaryGraph.setTopGraph(true);
                this.ivjAlarmSummaryGraph.setAlarmGroupTitle("Summary Graphs");
                this.ivjAlarmSummaryGraph.setDrawTimes(false);
                this.ivjAlarmSummaryGraph.setGraph("ALARM_SUMMARY");
                this.ivjAlarmSummaryGraph.setBounds(2, 0, 626, 34);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAlarmSummaryGraph;
    }

    private static void getBuilderData() {
    }

    public Component getComponentFromMethod(Method m) throws InvocationTargetException, IllegalAccessException {
        return (Component)m.invoke((Object)this, null);
    }

    private FocusManagingPanePage getDoubleGraphPanePage() {
        if (this.ivjDoubleGraphPanePage == null) {
            try {
                this.ivjDoubleGraphPanePage = new FocusManagingPanePage();
                ((Component)((Object)this.ivjDoubleGraphPanePage)).setName("DoubleGraphPanePage");
                this.ivjDoubleGraphPanePage.setBounds(24, 526, 631, 340);
                this.ivjDoubleGraphPanePage.setEclModel(new EclPanePageModel(false, false, false, false, 0));
                ((Container)((Object)this.getDoubleGraphPanePage())).add(this.getGraphPane2(), this.getGraphPane2().getName());
                ((Container)((Object)this.getDoubleGraphPanePage())).add(this.getGraphPane3(), this.getGraphPane3().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDoubleGraphPanePage;
    }

    private EclPane getEclPane1() {
        if (this.ivjEclPane1 == null) {
            try {
                this.ivjEclPane1 = new EclPane();
                this.ivjEclPane1.setName("EclPane1");
                this.ivjEclPane1.setBounds(3, 93, 631, 340);
                this.ivjEclPane1.setEclModel(new EclPaneModel("MRS_GUI_GRAPH_MODE", new String[]{"DoubleGraphPanePage", "SingleGraphPanePage"}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEclPane1;
    }

    private AlarmPlot getErrorSummaryGraph() {
        if (this.ivjErrorSummaryGraph == null) {
            try {
                this.ivjErrorSummaryGraph = new AlarmPlot();
                this.ivjErrorSummaryGraph.setName("ErrorSummaryGraph");
                this.ivjErrorSummaryGraph.setGraphTitle("Errors");
                this.ivjErrorSummaryGraph.setDrawDates(false);
                this.ivjErrorSummaryGraph.setAlarmGroupTitle("");
                this.ivjErrorSummaryGraph.setDrawTimes(false);
                this.ivjErrorSummaryGraph.setGraph("ERROR_SUMMARY");
                this.ivjErrorSummaryGraph.setBounds(2, 38, 626, 14);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjErrorSummaryGraph;
    }

    private MRSGraphMenu getGraphMainMenu() {
        if (this.theGraphMenu == null) {
            this.theGraphMenu = new MRSGraphMenu(this, this.theMenuBridge, this.theStateMonitor);
        }
        return this.theGraphMenu;
    }

    private GraphPane getGraphPane2() {
        if (this.ivjGraphPane2 == null) {
            try {
                this.ivjGraphPane2 = new GraphPane();
                this.ivjGraphPane2.setName("GraphPane2");
                this.ivjGraphPane2.setBounds(2, 2, 626, 150);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraphPane2;
    }

    private GraphPane getGraphPane3() {
        if (this.ivjGraphPane3 == null) {
            try {
                this.ivjGraphPane3 = new GraphPane();
                this.ivjGraphPane3.setName("GraphPane3");
                this.ivjGraphPane3.setDrawTimes(true);
                this.ivjGraphPane3.setDrawDates(true);
                this.ivjGraphPane3.setBounds(2, 162, 626, 175);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjGraphPane3;
    }

    private MRSGraphEventHandler getMRSGraphEventHandler1() {
        if (this.ivjMRSGraphEventHandler1 == null) {
            try {
                this.ivjMRSGraphEventHandler1 = new MRSGraphEventHandler();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMRSGraphEventHandler1;
    }

    private SingleGraphPanePage getSingleGraphPanePage() {
        if (this.ivjSingleGraphPanePage == null) {
            try {
                this.ivjSingleGraphPanePage = new SingleGraphPanePage();
                ((Component)((Object)this.ivjSingleGraphPanePage)).setName("SingleGraphPanePage");
                ((Component)((Object)this.ivjSingleGraphPanePage)).setLocation(683, 32);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSingleGraphPanePage;
    }

    private EclPanePage getSummaryGraphPanePage() {
        if (this.ivjSummaryGraphPanePage == null) {
            try {
                this.ivjSummaryGraphPanePage = new EclPanePage();
                this.ivjSummaryGraphPanePage.setName("SummaryGraphPanePage");
                this.ivjSummaryGraphPanePage.setBounds(3, 30, 630, 55);
                this.getSummaryGraphPanePage().add((Component)this.getAlarmSummaryGraph(), this.getAlarmSummaryGraph().getName());
                this.getSummaryGraphPanePage().add((Component)this.getErrorSummaryGraph(), this.getErrorSummaryGraph().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSummaryGraphPanePage;
    }

    public EclPane getTheManagingPane() {
        return this.getEclPane1();
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.connPtoP1SetTarget();
    }

    private void initialize() {
        try {
            ((Component)((Object)this)).setName("GraphWindow");
            ((Component)((Object)this)).setSize(636, 435);
            this.setEclModel(new EclWindowModel(0, 3, 2, null, "Graph Viewer"));
            ((Container)((Object)this)).add((Component)this.getSummaryGraphPanePage(), this.getSummaryGraphPanePage().getName());
            ((Container)((Object)this)).add((Component)this.getEclPane1(), this.getEclPane1().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            GraphWindow aGraphWindow = new GraphWindow();
            frame.add("Center", (Component)((Object)aGraphWindow));
            ((Component)frame).setSize(((Component)((Object)aGraphWindow)).getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow");
            exception.printStackTrace(System.out);
        }
    }

    public void notifySelectionPopupReady() {
        this.getGraphMainMenu().getRootPopupMenu().setComponentFocusableOnClose(this.getGraphMainMenu().getFocusReceiver());
        this.getGraphMainMenu().getRootPopupMenu().showRelativeToComponent((Component)((Object)this), MRSGraphWindow.menuPosition.x, MRSGraphWindow.menuPosition.y);
        this.getGraphMainMenu().getRootPopupMenu().getEclipseMenuComponent().requestFocus();
    }

    public void printChildren() {
        String time = new Epoch(System.currentTimeMillis()).getDateAndTime(true, true);
        String output = "\n" + time + " " + this.toString() + " children:";
        output = String.valueOf(output) + "\n" + this.getAlarmSummaryGraph().toString();
        output = String.valueOf(output) + "\n" + this.getErrorSummaryGraph().toString();
        output = String.valueOf(output) + "\n" + this.getGraphPane2().childrenToString();
        output = String.valueOf(output) + "\n" + this.getGraphPane3().childrenToString();
        output = String.valueOf(output) + "\n";
        System.out.println(output);
    }

    public void processCancelKey(KeyEvent keyEvent) {
        KeyEvent e;
        if (keyEvent == null) {
            e = InstrumentKeyMappings.getCancelKeyEvent((Component)((Object)this));
        }
        this.getMRSGraphEventHandler1().processUnconsumedKeyEvents(e, null);
    }

    public void processMenuKey(KeyEvent e) {
        this.getGraphMainMenu().setFocusReceiver(e.getComponent());
        this.theMenuBridge.updatePopupProperties(e, MRSGraphManager.getInstance().getRangeLeft(), MRSGraphManager.getInstance().getRangeRight(), this);
    }

    public String toString() {
        String thisName = ((Component)((Object)this)).getName();
        return thisName == null || thisName.length() == 0 ? "GraphWindow" : thisName;
    }

    public void unregister() {
        super.unregister();
        if (this.theMenuBridge != null) {
            this.theMenuBridge.unregister();
            this.theMenuBridge = null;
        }
        if (this.theGraphMenu != null) {
            this.theGraphMenu.unregister();
            this.theGraphMenu = null;
        }
    }
}

