/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.windows;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.graphs.defaults.GraphDefaults;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSSessionWindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.EclipseWorkspace;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;

public class SessionInfoDialog
extends EclDialog
implements CcConnectedComponent,
ApplicationGenericDataReceiver,
DialogEventReceiver {
    private final transient int serverCode = 3;
    private transient String selectedSession = null;
    private transient MRSSessionWindowManager sessionManager = null;
    private transient ApplicationObject agentAO = null;
    private transient boolean hasTrappedTransientError = false;
    private transient boolean hasTrappedPermanentError = false;

    public SessionInfoDialog(String session, MRSSessionWindowManager manager) {
        ((Component)((Object)this)).setSize(600, 400);
        this.selectedSession = session;
        this.sessionManager = manager;
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else if (aReport.getErrorStatus() == 3) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because the requested domain is not available.");
            this.permanentError();
        }
    }

    protected ApplicationGenericMetaData createMetaData() {
        ApplicationGenericMetaData meta = null;
        try {
            meta = new ApplicationGenericMetaData();
            PrimitiveTypesWriter writer = meta.getPrimitiveTypesWriter();
            writer.write(3);
            writer.write(this.selectedSession);
            meta.completedMetaDataInitialisation();
        }
        catch (IOException iOException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createMetaData: Creation of meta data failed!");
        }
        return meta;
    }

    public void finishInitialise() {
        super.finishInitialise();
        if (this.sessionManager.isInError()) {
            this.permanentError();
        } else {
            this.agentAO = this.sessionManager.getAgentAO();
            if (this.agentAO != null) {
                this.agentAO.register((ApplicationObjectObserver)this);
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: Error in Agent AO. Unable to register.");
                this.permanentError();
            }
        }
    }

    public void notifyEvent(int eventType, EclDialog w) {
        this.removeModalWindow();
    }

    public void permanentError() {
        this.setBackground(GraphDefaults.permanentErrorColour);
        this.setForeground(GraphDefaults.permanentErrorColour);
        this.hasTrappedPermanentError = true;
        this.hasTrappedTransientError = false;
        ((Component)((Object)this)).setVisible(true);
        this.unregister();
    }

    public void receiveApplicationGenericData(ApplicationGenericData v, ApplicationDataSender s) {
        PrimitiveTypesReader reader = v.getPrimitiveTypesReader();
        if (reader == null) {
            this.trapTransientError(true);
        } else {
            try {
                String text = reader.readString();
                this.displayMessageWindow(false, true, false, text, "Session Information", this, GraphDefaults.messageWindowFont);
                this.trapTransientError(false);
            }
            catch (IOException iOException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": receiveApplicationGenericData: Received meaningless data from " + s.toString());
                this.trapTransientError(true);
            }
        }
    }

    public boolean removeModalWindow() {
        boolean removed = false;
        Container parent = ((Component)((Object)this)).getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent instanceof EclipseWorkspace) {
            removed = ((EclipseWorkspace)parent).removeWindow((InternalWindow)this, true);
        }
        return removed;
    }

    public String toString() {
        return ((Component)((Object)this)).getName() == null || ((Component)((Object)this)).getName().equalsIgnoreCase("") ? "SessionInfoDialog" : ((Component)((Object)this)).getName();
    }

    public void trapTransientError(boolean isInError) {
        if (this.hasTrappedTransientError != isInError) {
            this.hasTrappedTransientError = isInError;
            ((Component)((Object)this)).repaint();
        }
    }

    public void unregister() {
        super.unregister();
        if (this.agentAO != null) {
            this.agentAO.unregister((ApplicationObjectObserver)this);
            this.agentAO = null;
        }
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("ERROR: " + this.toString() + ": update(v,o): Don't have the right interface to receive data = " + v.toString() + " from " + o.toString());
                this.permanentError();
            }
        } else {
            o.asyncQuery((ApplicationMetaData)this.createMetaData(), (ApplicationObjectObserver)this);
        }
    }
}

