/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.mrsgraphs.windows;

import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.KnownLengthStringValue;
import com.agilent.tntd.eclipse.mrsgraphs.common.MRSSessionWindowManager;
import com.agilent.tntd.eclipse.mrsgraphs.windows.SessionDeleteDialog;
import com.agilent.tntd.eclipse.mrsgraphs.windows.SessionInfoDialog;
import com.agilent.tntd.eclipse.mrsgraphs.windows.SessionRenameDialog;
import com.agilent.tntd.eclipse.mrsgraphs.windows.SessionStoreDialog;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButton;
import com.agilent.tntd.eclipse.viewlayer.components.button.EclButtonModel;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntry;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntryModel;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGauge;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeModel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabel;
import com.agilent.tntd.eclipse.viewlayer.components.label.EclLabelModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTable;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumn;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumnModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableModel;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePageModel;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindowModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SessionWindow
extends EclWindow {
    private MRSSessionWindowManager sessionManager = null;
    private String defaultSession = "LATEST";
    private EclFuelGauge ivjTotalMemUsageGauge = null;
    private EclLabel ivjTotalMemUsageLabel = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);
    private EclPanePage ivjTotalMemUsagePanePage = null;
    private EclLabel ivjLatestSessionLabel = null;
    private EclLabel ivjLatestSessionMemoryUsageLabel = null;
    private EclPanePage ivjLatestSessionPanePage = null;
    private EclLabel ivjLatestSessionPercentLabel = null;
    private EclButton ivjLatestSessionStoreButton = null;
    private EclButton ivjLatestSessionViewGraphsButton = null;
    private EclButton ivjStoredSessionDeleteButton = null;
    private EclLabel ivjStoredSessionLabel = null;
    private EclPanePage ivjStoredSessionPanePage = null;
    private EclButton ivjStoredSessionViewGraphsButton = null;
    private EclButton ivjStoredSessionViewInfoButton = null;
    private EclDataEntry ivjLatestSessionPercentDataEntry = null;
    private EclTable ivjStoredSessionTable = null;
    private EclTableColumn ivjStoredSessionMemUsageTableColumn = null;
    private EclTableColumn ivjStoredSessionNameTableColumn = null;
    private EclButton ivjStoredSessionRenameButton = null;
    static Class class$com$agilent$tntd$eclipse$mrsgraphs$windows$GraphWindow;

    public SessionWindow() {
        this.initialize();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.storedSessionRenameButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.latestSessionStoreButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.latestSessionViewGraphsButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.storedSessionDeleteButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.storedSessionViewInfoButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.storedSessionViewGraphsButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void createGraphWindow() {
        try {
            WindowManager windowManager = WindowManager.instance();
            Class<?> clazz = class$com$agilent$tntd$eclipse$mrsgraphs$windows$GraphWindow;
            if (clazz == null) {
                try {
                    clazz = class$com$agilent$tntd$eclipse$mrsgraphs$windows$GraphWindow = Class.forName("com.agilent.tntd.eclipse.mrsgraphs.windows.GraphWindow");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            windowManager.createWindow(clazz.getName());
        }
        catch (Throwable e) {
            EventLog.instance().log("ERROR: " + this.toString() + ": createGraphWindow: Error creating Graph Window. Stack trace follows.");
            e.printStackTrace();
        }
    }

    public void finishInitialise() {
        super.finishInitialise();
        this.sessionManager = new MRSSessionWindowManager();
        this.sessionManager.setStoreLatestSessionButton(this.getLatestSessionStoreButton());
        this.sessionManager.setViewLatestSessionButton(this.getLatestSessionViewGraphsButton());
        this.sessionManager.setRenameStoredSessionButton(this.getStoredSessionRenameButton());
        this.sessionManager.setDeleteStoredSessionButton(this.getStoredSessionDeleteButton());
        this.sessionManager.setViewInfoStoredSessionButton(this.getStoredSessionViewInfoButton());
        this.sessionManager.setViewStoredSessionButton(this.getStoredSessionViewGraphsButton());
        this.sessionManager.setStoredSessionTable(this.getStoredSessionTable());
        this.sessionManager.finishInitialise();
    }

    private static void getBuilderData() {
    }

    private EclLabel getLatestSessionLabel() {
        if (this.ivjLatestSessionLabel == null) {
            try {
                this.ivjLatestSessionLabel = new EclLabel();
                this.ivjLatestSessionLabel.setName("LatestSessionLabel");
                this.ivjLatestSessionLabel.setBackground(Color.lightGray);
                this.ivjLatestSessionLabel.setBounds(12, 91, 85, 20);
                this.ivjLatestSessionLabel.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"Latest Session"}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLatestSessionLabel;
    }

    private EclLabel getLatestSessionMemoryUsageLabel() {
        if (this.ivjLatestSessionMemoryUsageLabel == null) {
            try {
                this.ivjLatestSessionMemoryUsageLabel = new EclLabel();
                this.ivjLatestSessionMemoryUsageLabel.setName("LatestSessionMemoryUsageLabel");
                this.ivjLatestSessionMemoryUsageLabel.setBounds(8, 15, 89, 20);
                this.ivjLatestSessionMemoryUsageLabel.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"Memory Usage:"}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLatestSessionMemoryUsageLabel;
    }

    private EclPanePage getLatestSessionPanePage() {
        if (this.ivjLatestSessionPanePage == null) {
            try {
                this.ivjLatestSessionPanePage = new EclPanePage();
                this.ivjLatestSessionPanePage.setName("LatestSessionPanePage");
                this.ivjLatestSessionPanePage.setBounds(7, 99, 621, 47);
                this.ivjLatestSessionPanePage.setEclModel(new EclPanePageModel(true, true, true, true, 2));
                this.getLatestSessionPanePage().add((Component)this.getLatestSessionMemoryUsageLabel(), this.getLatestSessionMemoryUsageLabel().getName());
                this.getLatestSessionPanePage().add((Component)this.getLatestSessionPercentDataEntry(), this.getLatestSessionPercentDataEntry().getName());
                this.getLatestSessionPanePage().add((Component)this.getLatestSessionPercentLabel(), this.getLatestSessionPercentLabel().getName());
                this.getLatestSessionPanePage().add((Component)this.getLatestSessionStoreButton(), this.getLatestSessionStoreButton().getName());
                this.getLatestSessionPanePage().add((Component)this.getLatestSessionViewGraphsButton(), this.getLatestSessionViewGraphsButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLatestSessionPanePage;
    }

    private EclDataEntry getLatestSessionPercentDataEntry() {
        if (this.ivjLatestSessionPercentDataEntry == null) {
            try {
                this.ivjLatestSessionPercentDataEntry = new EclDataEntry();
                this.ivjLatestSessionPercentDataEntry.setName("LatestSessionPercentDataEntry");
                this.ivjLatestSessionPercentDataEntry.setBounds(101, 14, 44, 20);
                this.ivjLatestSessionPercentDataEntry.setEclModel(new EclDataEntryModel(0, false, "MRS_SESSION_LATEST_MEM_USAGE", null, 3, false, "", -1, null, null));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLatestSessionPercentDataEntry;
    }

    private EclLabel getLatestSessionPercentLabel() {
        if (this.ivjLatestSessionPercentLabel == null) {
            try {
                this.ivjLatestSessionPercentLabel = new EclLabel();
                this.ivjLatestSessionPercentLabel.setName("LatestSessionPercentLabel");
                this.ivjLatestSessionPercentLabel.setBounds(150, 15, 16, 20);
                this.ivjLatestSessionPercentLabel.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"%"}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLatestSessionPercentLabel;
    }

    private EclButton getLatestSessionStoreButton() {
        if (this.ivjLatestSessionStoreButton == null) {
            try {
                this.ivjLatestSessionStoreButton = new EclButton();
                this.ivjLatestSessionStoreButton.setName("LatestSessionStoreButton");
                this.ivjLatestSessionStoreButton.setBounds(418, 15, 95, 20);
                this.ivjLatestSessionStoreButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "Store", "latest.session.store.button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLatestSessionStoreButton;
    }

    private EclButton getLatestSessionViewGraphsButton() {
        if (this.ivjLatestSessionViewGraphsButton == null) {
            try {
                this.ivjLatestSessionViewGraphsButton = new EclButton();
                this.ivjLatestSessionViewGraphsButton.setName("LatestSessionViewGraphsButton");
                this.ivjLatestSessionViewGraphsButton.setBounds(519, 15, 95, 20);
                this.ivjLatestSessionViewGraphsButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "View Graphs", "latest.session.view.graphs.button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLatestSessionViewGraphsButton;
    }

    private String getSelectedSession() {
        String selectedSession = null;
        int index = this.getStoredSessionTable().getSelectedIndex();
        if (index >= 0) {
            selectedSession = this.getStoredSessionNameTableColumn().getColumnBodyComponentAt(index).toString().trim();
        }
        return selectedSession;
    }

    private EclButton getStoredSessionDeleteButton() {
        if (this.ivjStoredSessionDeleteButton == null) {
            try {
                this.ivjStoredSessionDeleteButton = new EclButton();
                this.ivjStoredSessionDeleteButton.setName("StoredSessionDeleteButton");
                this.ivjStoredSessionDeleteButton.setBounds(519, 55, 95, 20);
                this.ivjStoredSessionDeleteButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "Delete", "stored.session.delete.button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionDeleteButton;
    }

    private EclLabel getStoredSessionLabel() {
        if (this.ivjStoredSessionLabel == null) {
            try {
                this.ivjStoredSessionLabel = new EclLabel();
                this.ivjStoredSessionLabel.setName("StoredSessionLabel");
                this.ivjStoredSessionLabel.setBackground(Color.lightGray);
                this.ivjStoredSessionLabel.setBounds(12, 153, 93, 20);
                this.ivjStoredSessionLabel.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"Stored Sessions"}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionLabel;
    }

    private EclTableColumn getStoredSessionMemUsageTableColumn() {
        if (this.ivjStoredSessionMemUsageTableColumn == null) {
            try {
                this.ivjStoredSessionMemUsageTableColumn = new EclTableColumn();
                this.ivjStoredSessionMemUsageTableColumn.setName("StoredSessionMemUsageTableColumn");
                this.ivjStoredSessionMemUsageTableColumn.setBounds(0, 0, 160, 120);
                this.ivjStoredSessionMemUsageTableColumn.setEclModel(new EclTableColumnModel("MRS_SESSION_LIST_MEM_USAGE", null, "Memory Usage %", "100"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionMemUsageTableColumn;
    }

    private EclTableColumn getStoredSessionNameTableColumn() {
        if (this.ivjStoredSessionNameTableColumn == null) {
            try {
                this.ivjStoredSessionNameTableColumn = new EclTableColumn();
                this.ivjStoredSessionNameTableColumn.setName("StoredSessionNameTableColumn");
                this.ivjStoredSessionNameTableColumn.setLocation(24, 16);
                this.ivjStoredSessionNameTableColumn.setEclModel(new EclTableColumnModel("MRS_SESSION_LIST", null, " MRS Session Name", "Session name should be very descriptive and detailed"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionNameTableColumn;
    }

    private EclPanePage getStoredSessionPanePage() {
        if (this.ivjStoredSessionPanePage == null) {
            try {
                this.ivjStoredSessionPanePage = new EclPanePage();
                this.ivjStoredSessionPanePage.setName("StoredSessionPanePage");
                this.ivjStoredSessionPanePage.setBounds(7, 161, 621, 263);
                this.ivjStoredSessionPanePage.setEclModel(new EclPanePageModel(true, true, true, true, 2));
                this.getStoredSessionPanePage().add((Component)this.getStoredSessionTable(), this.getStoredSessionTable().getName());
                this.getStoredSessionPanePage().add((Component)this.getStoredSessionRenameButton(), this.getStoredSessionRenameButton().getName());
                this.getStoredSessionPanePage().add((Component)this.getStoredSessionDeleteButton(), this.getStoredSessionDeleteButton().getName());
                this.getStoredSessionPanePage().add((Component)this.getStoredSessionViewInfoButton(), this.getStoredSessionViewInfoButton().getName());
                this.getStoredSessionPanePage().add((Component)this.getStoredSessionViewGraphsButton(), this.getStoredSessionViewGraphsButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionPanePage;
    }

    private EclButton getStoredSessionRenameButton() {
        if (this.ivjStoredSessionRenameButton == null) {
            try {
                this.ivjStoredSessionRenameButton = new EclButton();
                this.ivjStoredSessionRenameButton.setName("StoredSessionRenameButton");
                this.ivjStoredSessionRenameButton.setBounds(519, 15, 95, 20);
                this.ivjStoredSessionRenameButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "Rename", "stored.session.rename.button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionRenameButton;
    }

    private EclTable getStoredSessionTable() {
        if (this.ivjStoredSessionTable == null) {
            try {
                this.ivjStoredSessionTable = new EclTable();
                this.ivjStoredSessionTable.setName("StoredSessionTable");
                this.ivjStoredSessionTable.setBounds(7, 15, 505, 241);
                this.ivjStoredSessionTable.setEclModel(new EclTableModel(null, null, new Color(0, 0, 0), 12, true, true, true, true));
                this.getStoredSessionTable().add((Component)this.getStoredSessionNameTableColumn(), this.getStoredSessionNameTableColumn().getName());
                this.getStoredSessionTable().add((Component)this.getStoredSessionMemUsageTableColumn(), this.getStoredSessionMemUsageTableColumn().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionTable;
    }

    private EclButton getStoredSessionViewGraphsButton() {
        if (this.ivjStoredSessionViewGraphsButton == null) {
            try {
                this.ivjStoredSessionViewGraphsButton = new EclButton();
                this.ivjStoredSessionViewGraphsButton.setName("StoredSessionViewGraphsButton");
                this.ivjStoredSessionViewGraphsButton.setBounds(519, 135, 95, 20);
                this.ivjStoredSessionViewGraphsButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "View Graphs", "stored.session.view.graphs.button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionViewGraphsButton;
    }

    private EclButton getStoredSessionViewInfoButton() {
        if (this.ivjStoredSessionViewInfoButton == null) {
            try {
                this.ivjStoredSessionViewInfoButton = new EclButton();
                this.ivjStoredSessionViewInfoButton.setName("StoredSessionViewInfoButton");
                this.ivjStoredSessionViewInfoButton.setBounds(519, 95, 95, 20);
                this.ivjStoredSessionViewInfoButton.setEclModel(new EclButtonModel(null, null, null, null, -1, -1, "View Info", "stored.session.view.info.button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStoredSessionViewInfoButton;
    }

    private EclFuelGauge getTotalMemUsageGauge() {
        if (this.ivjTotalMemUsageGauge == null) {
            try {
                this.ivjTotalMemUsageGauge = new EclFuelGauge();
                this.ivjTotalMemUsageGauge.setName("TotalMemUsageGauge");
                this.ivjTotalMemUsageGauge.setBounds(8, 15, 606, 20);
                this.ivjTotalMemUsageGauge.setEclModel(new EclFuelGaugeModel("MRS_SESSION_TOTAL_MEM_USAGE", new Color(0, 0, 178), 2, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTotalMemUsageGauge;
    }

    private EclLabel getTotalMemUsageLabel() {
        if (this.ivjTotalMemUsageLabel == null) {
            try {
                this.ivjTotalMemUsageLabel = new EclLabel();
                this.ivjTotalMemUsageLabel.setName("TotalMemUsageLabel");
                this.ivjTotalMemUsageLabel.setBackground(Color.lightGray);
                this.ivjTotalMemUsageLabel.setBounds(12, 29, 115, 20);
                this.ivjTotalMemUsageLabel.setEclModel(new EclLabelModel(null, null, (String[][])new String[][]{{"Total Memory Usage"}}, -1));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTotalMemUsageLabel;
    }

    private EclPanePage getTotalMemUsagePanePage() {
        if (this.ivjTotalMemUsagePanePage == null) {
            try {
                this.ivjTotalMemUsagePanePage = new EclPanePage();
                this.ivjTotalMemUsagePanePage.setName("TotalMemUsagePanePage");
                this.ivjTotalMemUsagePanePage.setBounds(7, 37, 621, 47);
                this.ivjTotalMemUsagePanePage.setEclModel(new EclPanePageModel(true, true, true, true, 2));
                this.getTotalMemUsagePanePage().add((Component)this.getTotalMemUsageGauge(), this.getTotalMemUsageGauge().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTotalMemUsagePanePage;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getLatestSessionStoreButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getLatestSessionViewGraphsButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getStoredSessionDeleteButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getStoredSessionViewInfoButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getStoredSessionViewGraphsButton().addActionListener((ActionListener)this.ivjEventHandler);
        this.getStoredSessionRenameButton().addActionListener((ActionListener)this.ivjEventHandler);
    }

    private void initialize() {
        try {
            ((Component)((Object)this)).setName("SessionWindow");
            ((Component)((Object)this)).setSize(636, 435);
            this.setEclModel(new EclWindowModel(4, 3, 2, null, "Measurement Record - Graph Manager"));
            ((Container)((Object)this)).add((Component)this.getTotalMemUsageLabel(), this.getTotalMemUsageLabel().getName());
            ((Container)((Object)this)).add((Component)this.getTotalMemUsagePanePage(), this.getTotalMemUsagePanePage().getName());
            ((Container)((Object)this)).add((Component)this.getLatestSessionLabel(), this.getLatestSessionLabel().getName());
            ((Container)((Object)this)).add((Component)this.getLatestSessionPanePage(), this.getLatestSessionPanePage().getName());
            ((Container)((Object)this)).add((Component)this.getStoredSessionLabel(), this.getStoredSessionLabel().getName());
            ((Container)((Object)this)).add((Component)this.getStoredSessionPanePage(), this.getStoredSessionPanePage().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void latestSessionStoreButton_ActionPerformed() {
        try {
            SessionStoreDialog w = new SessionStoreDialog(this.sessionManager);
            WindowManager.instance().connectWindow((InternalWindow)w);
            w.finishInitialise();
        }
        catch (Throwable e) {
            EventLog.instance().log("ERROR: " + this.toString() + ": latestSessionStoreButton_ActionPerformed: Error creating dialog");
            e.printStackTrace();
        }
    }

    public void latestSessionViewGraphsButton_ActionPerformed() {
        if (!this.storeSession(this.defaultSession)) {
            EventLog.instance().log("ERROR: " + this.toString() + ": latestSessionViewGraphsButton_ActionPerformed: Server refused to set the selected session to LATEST");
        }
        this.createGraphWindow();
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            SessionWindow aSessionWindow = new SessionWindow();
            frame.add("Center", (Component)((Object)aSessionWindow));
            ((Component)frame).setSize(((Component)((Object)aSessionWindow)).getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow");
            exception.printStackTrace(System.out);
        }
    }

    public void storedSessionDeleteButton_ActionPerformed() {
        try {
            SessionDeleteDialog w = new SessionDeleteDialog(this.getSelectedSession(), this.sessionManager);
            WindowManager.instance().connectWindow((InternalWindow)w);
            w.finishInitialise();
        }
        catch (Throwable e) {
            EventLog.instance().log("ERROR: " + this.toString() + ": storedSessionDeleteButton_ActionPerformed: Error creating dialog");
            e.printStackTrace();
        }
    }

    public void storedSessionRenameButton_ActionPerformed() {
        String session = this.getSelectedSession();
        if (session != null) {
            try {
                SessionRenameDialog w = new SessionRenameDialog(session, this.sessionManager);
                WindowManager.instance().connectWindow((InternalWindow)w);
                w.finishInitialise();
            }
            catch (Throwable e) {
                EventLog.instance().log("ERROR: " + this.toString() + ": storedSessionRenameButton_ActionPerformed: Error creating dialog");
                e.printStackTrace();
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": storedSessionRenameButton_ActionPerformed: Stored session not selected in table; unable to create dialog.");
        }
    }

    public void storedSessionViewGraphsButton_ActionPerformed() {
        String session = this.getSelectedSession();
        if (session == null) {
            session = this.defaultSession;
            EventLog.instance().log("WARNING: " + this.toString() + ": storedSessionViewGraphsButton_ActionPerformed: No session selected! Defaulting to LATEST session (which may not exist).");
        }
        if (!this.storeSession(session)) {
            EventLog.instance().log("ERROR: " + this.toString() + ": storedSessionViewGraphsButton_ActionPerformed: Server refused to set the selected session to " + session);
        }
        this.createGraphWindow();
    }

    public void storedSessionViewInfoButton_ActionPerformed() {
        String session = this.getSelectedSession();
        if (session != null) {
            try {
                SessionInfoDialog w = new SessionInfoDialog(session, this.sessionManager);
                w.finishInitialise();
            }
            catch (Throwable e) {
                EventLog.instance().log("ERROR: " + this.toString() + ": storedSessionViewInfoButton_ActionPerformed: Error creating dialog");
                e.printStackTrace();
            }
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": storedSessionViewInfoButton_ActionPerformed: Stored session not selected in table; unable to create dialog.");
        }
    }

    private boolean storeSession(String session) {
        KnownLengthStringValue value = new KnownLengthStringValue(session);
        return this.sessionManager.sendKnownLengthStringData((ApplicationData)value);
    }

    public String toString() {
        return ((Component)((Object)this)).getName() == null || ((Component)((Object)this)).getName().equalsIgnoreCase("") ? "SessionWindow" : ((Component)((Object)this)).getName();
    }

    public void unregister() {
        super.unregister();
        this.sessionManager.unregister();
        this.sessionManager = null;
    }

    static void access$connEtoC3(SessionWindow sessionWindow, ActionEvent actionEvent) {
        sessionWindow.connEtoC3(actionEvent);
    }

    static EclButton access$getLatestSessionViewGraphsButton(SessionWindow sessionWindow) {
        return sessionWindow.getLatestSessionViewGraphsButton();
    }

    static EclButton access$getStoredSessionDeleteButton(SessionWindow sessionWindow) {
        return sessionWindow.getStoredSessionDeleteButton();
    }

    static void access$connEtoC6(SessionWindow sessionWindow, ActionEvent actionEvent) {
        sessionWindow.connEtoC6(actionEvent);
    }

    static void access$connEtoC7(SessionWindow sessionWindow, ActionEvent actionEvent) {
        sessionWindow.connEtoC7(actionEvent);
    }

    static EclButton access$getLatestSessionStoreButton(SessionWindow sessionWindow) {
        return sessionWindow.getLatestSessionStoreButton();
    }

    static EclButton access$getStoredSessionViewGraphsButton(SessionWindow sessionWindow) {
        return sessionWindow.getStoredSessionViewGraphsButton();
    }

    static EclButton access$getStoredSessionViewInfoButton(SessionWindow sessionWindow) {
        return sessionWindow.getStoredSessionViewInfoButton();
    }

    static EclButton access$getStoredSessionRenameButton(SessionWindow sessionWindow) {
        return sessionWindow.getStoredSessionRenameButton();
    }

    static void access$connEtoC5(SessionWindow sessionWindow, ActionEvent actionEvent) {
        sessionWindow.connEtoC5(actionEvent);
    }

    static void access$connEtoC2(SessionWindow sessionWindow, ActionEvent actionEvent) {
        sessionWindow.connEtoC2(actionEvent);
    }

    static void access$connEtoC1(SessionWindow sessionWindow, ActionEvent actionEvent) {
        sessionWindow.connEtoC1(actionEvent);
    }

    class IvjEventHandler
    implements ActionListener {
        /* synthetic */ SessionWindow this$0;

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SessionWindow.access$getLatestSessionStoreButton(this.this$0)) {
                SessionWindow.access$connEtoC2(this.this$0, e);
            }
            if (e.getSource() == SessionWindow.access$getLatestSessionViewGraphsButton(this.this$0)) {
                SessionWindow.access$connEtoC3(this.this$0, e);
            }
            if (e.getSource() == SessionWindow.access$getStoredSessionDeleteButton(this.this$0)) {
                SessionWindow.access$connEtoC5(this.this$0, e);
            }
            if (e.getSource() == SessionWindow.access$getStoredSessionViewInfoButton(this.this$0)) {
                SessionWindow.access$connEtoC6(this.this$0, e);
            }
            if (e.getSource() == SessionWindow.access$getStoredSessionViewGraphsButton(this.this$0)) {
                SessionWindow.access$connEtoC7(this.this$0, e);
            }
            if (e.getSource() == SessionWindow.access$getStoredSessionRenameButton(this.this$0)) {
                SessionWindow.access$connEtoC1(this.this$0, e);
            }
        }

        IvjEventHandler(SessionWindow this$0) {
            this.this$0 = this$0;
        }
    }
}

