/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.autoconfigure;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.thinclient.autoconfigure.Auto_Configure;
import com.agilent.tntd.eclipse.thinclient.autoconfigure.PatternHelper;
import com.agilent.tntd.eclipse.thinclient.autoconfigure.SignalDiscovery;
import com.agilent.tntd.eclipse.thinclient.autoconfigure.StructureScope;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ApplicationInterfaceUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowHandler;
import java.awt.AWTEvent;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.peer.ActiveEvent;
import java.beans.Beans;

public class AutoConfigureDirector
implements ApplicationInterfaceUI,
MaskedIntegerDataReceiver,
CcConnectedComponent {
    private transient Auto_Configure autoConfigureWindow = null;
    private transient ModalWindowHandler windowHandler = null;
    private transient SignalDiscovery discovery = null;
    private transient StructureScope structureScope = null;
    private transient boolean complete = false;
    private transient boolean running = false;
    private transient boolean thruModeOn = false;
    private transient ApplicationObject appRunningAO = null;
    private transient EclDialog setupResponseDialog = null;
    private static final String appRunningVariable = "STEST_APPLICATION_RUNNING";
    private transient MaskedIntegerValue lastValue = null;

    public AutoConfigureDirector() {
        if (!Beans.isDesignTime()) {
            this.buildServerConnection();
        }
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        switch (aReport.getErrorStatus()) {
            case 1: {
                EventLog.instance().log("Could not establish connection to SignalWizard server: " + anAO.toString() + " failed to initialise");
                break;
            }
            case 3: {
                EventLog.instance().log("Could not establish connection to SignalWizard server: " + anAO.toString() + " requested from unknown domain");
                break;
            }
            case 0: 
            case 2: {
                if (!anAO.getName().equals(appRunningVariable)) break;
                this.appRunningAO = anAO;
            }
        }
    }

    public void acknowledgeSuspend(boolean success) {
        if (this.setupResponseDialog == null) {
            this.setupResponseDialog = new EclDialog();
            this.setupResponseDialog.setSize(300, 120);
        }
        if (success) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new HackEvent(this));
        } else {
            this.running = true;
            this.setupResponseDialog.displayMessageWindow(false, true, false, "Failed to setup transmitter or receiver", "", new DialogEventReceiver(this){
                /* synthetic */ AutoConfigureDirector this$0;

                public void notifyEvent(int id, EclDialog d) {
                    AutoConfigureDirector.access$setupResponseDialog(this.this$0).removeFromWorkspace();
                }
                {
                    this.this$0 = this$0;
                }
            }, new Font("dialog", 0, 12));
        }
    }

    private void buildServerConnection() {
        Server.instance().initialise("SignalWizard");
        Server.instance().applicationInterface().setUI(this);
    }

    public void close() {
        this.windowHandler.setWindow((InternalWindow)this.autoConfigureWindow);
        this.windowHandler.removeModalWindow();
    }

    public void detectPattern() {
        Server.instance().applicationInterface().detectPattern();
    }

    public void doBlockingHack() {
        if (this.appRunningAO != null) {
            this.appRunningAO.change((ApplicationData)this.lastValue);
        }
        this.close();
    }

    public void finishInitialise() {
        this.running = false;
        this.complete = false;
        ApplicationManager.instance().request("ISS", 0, appRunningVariable, (ApplicationObjectObserver)this);
        Server.instance().finishInitialise();
    }

    public void intialiseProtocol() {
        if (this.takeControl()) {
            Server.instance().applicationInterface().start();
        } else {
            this.close();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void notifyDiscoveryProgress(int percent) {
        this.autoConfigureWindow.notifyDiscoveryProgress(percent);
    }

    public void notifyNoSignalsFound() {
        this.autoConfigureWindow.notifyNoSignalsFound();
    }

    public void notifyPattern(boolean success, short patternType, boolean inverted, short userWord) {
        String s = "";
        if (success) {
            if (PatternHelper.isValidPatternType(patternType)) {
                if (PatternHelper.isUserWord(patternType)) {
                    s = PatternHelper.to16BitBinaryString(userWord);
                } else {
                    s = PatternHelper.patternTypes[patternType];
                    if (PatternHelper.canBeInverted(patternType)) {
                        s = String.valueOf(s) + ", " + (inverted ? "Inverted" : "Non-Inverted");
                    }
                }
            } else {
                s = "Bad type: 0x" + Integer.toHexString(patternType);
            }
        } else {
            s = "Not detected";
        }
        this.autoConfigureWindow.setPattern(s);
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (s == this.appRunningAO) {
            this.lastValue = v;
            this.setAppRunningFlag(v.getValue() != 0);
        }
    }

    public void setAppRunningFlag(boolean isRunning) {
        if (isRunning) {
            this.running = true;
        } else if (this.running) {
            this.suspend();
        }
    }

    public void setAutoConfigureWindow(Auto_Configure newWindow) {
        this.autoConfigureWindow = newWindow;
        this.windowHandler = new ModalWindowHandler();
        this.windowHandler.setWindow((InternalWindow)this.autoConfigureWindow);
    }

    public void setDiscovery(SignalDiscovery s) {
        this.discovery = s;
        this.discovery.setDirector(this);
        Server.instance().signalDiscovery().setUI(this.discovery);
    }

    public void setFramingType(String f) {
        this.autoConfigureWindow.setFramingType(f);
        if (this.complete) {
            this.autoConfigureWindow.signalComplete();
        }
    }

    public void setLeafName(String l) {
        this.autoConfigureWindow.setLeafName(l);
    }

    public void setRootName(String r) {
        this.autoConfigureWindow.setRootName(r);
    }

    public void setSelectedPortName(String name) {
        this.autoConfigureWindow.setPortName(name);
    }

    public void setStructureScope(StructureScope s) {
        this.structureScope = s;
        this.structureScope.setDirector(this);
        Server.instance().structureScope().setUI(this.structureScope);
    }

    public void signalComplete() {
        this.autoConfigureWindow.stopSettling();
        this.autoConfigureWindow.signalComplete();
    }

    public void startDiscovery() {
        this.autoConfigureWindow.startSignalDiscovery();
    }

    public void startSettling() {
        this.autoConfigureWindow.startSettling();
    }

    public void startStructureScope() {
        this.autoConfigureWindow.startStructureScope();
    }

    public void stopSettling() {
        this.autoConfigureWindow.stopSettling();
    }

    public void suspend() {
        if (this.running) {
            this.running = false;
            this.close();
        }
    }

    public void suspendSetupRx() {
        this.running = false;
        Server.instance().applicationInterface().suspendSetupRx();
    }

    public void suspendSetupRxTx() {
        this.running = false;
        Server.instance().applicationInterface().suspendSetupTxRx();
    }

    public void suspendSetupTx() {
        this.running = false;
        Server.instance().applicationInterface().suspendSetupTx();
    }

    public boolean takeControl() {
        return this.appRunningAO.change((ApplicationData)this.lastValue);
    }

    public void trapTransientError(boolean isInError) {
    }

    public void unregister() {
        this.discovery.unregister();
        this.structureScope.unregister();
        Server.instance().applicationInterface().suspend();
        Server.instance().unregister();
        if (this.appRunningAO != null) {
            this.appRunningAO.unregister((ApplicationObjectObserver)this);
        }
        this.appRunningAO = null;
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("SignalWizardDirector doesn't implement the right interface to receive " + v.toString() + " from " + o.toString());
            }
        }
    }

    public boolean windowSelected() {
        return this.autoConfigureWindow.isSelected();
    }

    static EclDialog access$setupResponseDialog(AutoConfigureDirector autoConfigureDirector) {
        return autoConfigureDirector.setupResponseDialog;
    }

    private class HackEvent
    extends AWTEvent
    implements ActiveEvent {
        /* synthetic */ AutoConfigureDirector this$0;

        public HackEvent(AutoConfigureDirector this$0) {
            super(this$0, 0);
            this.this$0 = this$0;
        }

        public void dispatch() {
            this.this$0.doBlockingHack();
        }
    }
}

