/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.autoconfigure;

import com.agilent.tntd.eclipse.thinclient.autoconfigure.AutoConfigureDirector;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.SignalDiscoveryUI;

public class SignalDiscovery
implements SignalDiscoveryUI {
    private AutoConfigureDirector director = null;
    private Signal selectedSignal = null;

    public void addPort(String name, int rateKhz, boolean isOptical, boolean isOk) {
        if (isOk && (this.selectedSignal == null || isOptical && !this.selectedSignal.isOptical || rateKhz > this.selectedSignal.rateKhz)) {
            this.selectedSignal = new Signal(name, rateKhz, isOptical);
        }
    }

    public void removeAllPorts() {
        this.selectedSignal = null;
    }

    public void setDirector(AutoConfigureDirector d) {
        this.director = d;
    }

    public void setPercentageComplete(int p) {
        this.director.notifyDiscoveryProgress(p);
        if (p >= 100) {
            if (this.selectedSignal != null) {
                Server.instance().context().setOpticalInterface(this.selectedSignal.isOptical);
                this.director.setSelectedPortName(this.selectedSignal.portName);
                this.director.startStructureScope();
                Server.instance().applicationInterface().startStructureScope(this.selectedSignal.portName);
            } else {
                this.director.notifyNoSignalsFound();
            }
        }
    }

    public void start() {
        this.removeAllPorts();
        this.director.startDiscovery();
    }

    public void unregister() {
        this.selectedSignal = null;
    }

    private static class Signal {
        public final String portName;
        public final int rateKhz;
        public final boolean isOptical;

        public Signal(String p, int r, boolean opt) {
            this.portName = p;
            this.rateKhz = r;
            this.isOptical = opt;
        }
    }
}

