/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.autoconfigure;

import com.agilent.tntd.eclipse.thinclient.autoconfigure.AutoConfigureDirector;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.AnalyserListener;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.DefaultLayer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.StructureScopeUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.util.WatchdogTimer;

public class StructureScope
implements StructureScopeUI {
    private AutoConfigureDirector director = null;
    private DefaultLayer rootLayer = null;
    private DefaultLayer leafLayer = null;
    private WatchdogTimer structureCompleteWatchdog = null;
    private AnalyserListener viewerManager = new AnalyserListener(this){
        /* synthetic */ StructureScope this$0;

        public void notifyMessageChange(AnalyserUI a) {
        }

        public void notifyErrorChange(AnalyserUI a) {
            StructureScope.access$updateErrorState(this.this$0, (DefaultLayer)a);
        }

        public void notifySelectionChange(AnalyserUI a) {
        }

        public void notifyStructureComplete(AnalyserUI a) {
            StructureScope.access$expandIfPossible(this.this$0, (DefaultLayer)a);
        }

        public void notifyStructureChange(AnalyserUI a) {
            StructureScope.access$invalidateStructure(this.this$0, (DefaultLayer)a);
        }
        {
            this.this$0 = this$0;
        }
    };
    private static final boolean onlyExpandFirstChannel = true;
    private static final int settlingTime = 12000;

    public void addAnalyserUI(AnalyserUI a, AnalyserUI parent, int indexInParent) {
        if (a instanceof DefaultLayer) {
            DefaultLayer l;
            this.leafLayer = l = (DefaultLayer)a;
            l.setListener(this.viewerManager);
        }
    }

    public AnalyserUI createAnalyserUI(AnalyserProxy a) {
        return new DefaultLayer(a);
    }

    private synchronized void expandIfPossible(DefaultLayer l) {
        if (this.rootLayer == null) {
            this.rootLayer = l;
            this.director.setRootName(StructureScope.getName(l, 0));
        }
        short channelsToScan = 1;
        short i = 0;
        while (i < channelsToScan) {
            if (l.getChannelStatus((int)i).substructure) {
                if (l != this.rootLayer) {
                    this.director.setLeafName(StructureScope.getName(l, i));
                }
                l.setSelectedIndex(i);
                l.requestChild(i);
                return;
            }
            i = (short)(i + 1);
        }
        if (l != this.rootLayer) {
            this.director.setLeafName(StructureScope.getName(l, 0));
        }
        this.startWatchdog();
        this.director.startSettling();
    }

    public static String getName(DefaultLayer v, int i) {
        if (i < 0) {
            return "";
        }
        return v.getChannelCaption(i);
    }

    private synchronized void invalidateStructure(DefaultLayer l) {
        this.stopWatchdog();
        this.director.stopSettling();
        while (this.leafLayer != l) {
            DefaultLayer newLeaf = this.leafLayer.getParent();
            this.leafLayer.unregister();
            this.leafLayer = newLeaf;
        }
        this.director.setLeafName(StructureScope.getName(this.leafLayer, this.leafLayer.getSelectedIndex()));
        l.acknowledgeStructureChange();
    }

    public void setDirector(AutoConfigureDirector d) {
        this.director = d;
    }

    public void setOpticalPower(String p) {
    }

    public void setScanPercentage(int percent) {
    }

    private void signalComplete() {
        this.structureCompleteWatchdog = null;
        this.director.signalComplete();
    }

    public void start() {
    }

    private void startWatchdog() {
        this.stopWatchdog();
        this.structureCompleteWatchdog = new WatchdogTimer(12000, new WatchdogTimer.Listener(this){
            /* synthetic */ StructureScope this$0;

            public void notifyTimeout(WatchdogTimer t) {
                StructureScope.access$signalComplete(this.this$0);
            }

            public void notifyInterrupted(WatchdogTimer t) {
            }
            {
                this.this$0 = this$0;
            }
        });
        this.structureCompleteWatchdog.start();
    }

    private void stopWatchdog() {
        if (this.structureCompleteWatchdog != null) {
            this.structureCompleteWatchdog.interrupt();
            this.structureCompleteWatchdog = null;
        }
    }

    public synchronized void unregister() {
        this.stopWatchdog();
        if (this.rootLayer != null) {
            this.rootLayer.unregister();
        }
        this.rootLayer = null;
    }

    private void updateErrorState(DefaultLayer l) {
        if (l == this.leafLayer) {
            if (l.isPdh()) {
                String framing = l.decode(l.getCurrentLabel(), l.getChannelStatus(l.getSelectedIndex()));
                this.director.setFramingType(framing);
            } else {
                this.director.setFramingType("Unframed");
            }
        }
    }

    static void access$updateErrorState(StructureScope structureScope, DefaultLayer defaultLayer) {
        structureScope.updateErrorState(defaultLayer);
    }

    static void access$invalidateStructure(StructureScope structureScope, DefaultLayer defaultLayer) {
        structureScope.invalidateStructure(defaultLayer);
    }

    static void access$expandIfPossible(StructureScope structureScope, DefaultLayer defaultLayer) {
        structureScope.expandIfPossible(defaultLayer);
    }

    static void access$signalComplete(StructureScope structureScope) {
        structureScope.signalComplete();
    }
}

