/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.rocket;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.thinclient.rocket.BoxInterface;
import com.agilent.tntd.eclipse.thinclient.rocket.LineElement;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramDefaults;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class BoxElement
extends Component
implements BoxInterface {
    private boolean validOnlyInSTMn = false;
    private int layer = -1;
    private int value = -1;
    private String text = "Undefined";
    private BoxElement top = null;
    private BoxElement bottom = null;
    private BoxElement leftPathComponent = null;
    private BoxElement leftCursorComponent = null;
    private transient Point textOrigin = null;
    private transient boolean selectable = false;
    private transient boolean inPath = false;
    private transient boolean inFocus = false;
    private transient ArrayList leftCursorList = null;
    private transient ArrayList rightCursorList = null;
    private transient ArrayList leftPathList = null;
    private transient ArrayList rightPathList = null;
    private transient ArrayList lineList = null;
    private transient Color borderColor = null;
    private transient int borderWidth;

    public BoxElement() {
        this.initialize();
    }

    public void addLine(LineElement l) {
        if (this.lineList == null) {
            this.lineList = new ArrayList();
        }
        this.lineList.add((Object)l);
    }

    public void addRightCursorComponent(BoxInterface rightComponent) {
        if (this.rightCursorList == null) {
            this.rightCursorList = new ArrayList();
        }
        this.rightCursorList.add((Object)rightComponent);
    }

    public void addRightPathComponent(BoxInterface rightComponent) {
        if (this.rightPathList == null) {
            this.rightPathList = new ArrayList();
        }
        this.rightPathList.add((Object)rightComponent);
    }

    private void calculateGeometry() {
        FontMetrics f = this.getFontMetrics(this.getFont());
        Rectangle r = this.getBounds();
        int textHeight = 0;
        int textWidth = 0;
        if (f != null) {
            textHeight = f.getHeight();
            textWidth = f.stringWidth(this.text);
            this.textOrigin.x = (r.width - textWidth) / 2;
            this.textOrigin.y = (r.height - textHeight) / 2 + f.getMaxAscent() + 1;
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public BoxElement getBottomComponent() {
        return this.bottom;
    }

    public int getLayer() {
        return this.layer;
    }

    public Collection getLeftCursorComponents() {
        return this.leftCursorList;
    }

    public Collection getLeftPathComponents() {
        return this.leftPathList;
    }

    public Collection getRightCursorComponents() {
        return this.rightCursorList;
    }

    public Collection getRightPathComponents() {
        return this.rightPathList;
    }

    public String getText() {
        return this.text;
    }

    public BoxElement getTopComponent() {
        return this.top;
    }

    public int getValue() {
        return this.value;
    }

    private void initialize() {
        this.textOrigin = new Point(0, 0);
        this.setFont(RocketDiagramDefaults.defaultFont);
        this.setBackground(RocketDiagramDefaults.notInPathBackground);
        this.setForeground(RocketDiagramDefaults.notInPathForeground);
        this.setBorderColor(RocketDiagramDefaults.notInPathBorderColor);
        this.setBorderWidth(1);
        super.setSize(60, 30);
    }

    public boolean isInFocus() {
        return this.inFocus;
    }

    public boolean isInPath() {
        return this.inPath;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isValidOnlyInSTMn() {
        return this.validOnlyInSTMn;
    }

    public void paint(Graphics g) {
        if (this.getBackground() != null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        g.drawString(this.text, this.textOrigin.x, this.textOrigin.y);
        g.setColor(this.getBorderColor());
        int i = 0;
        while (i < this.borderWidth) {
            g.drawRect(i, i, this.getSize().width - 1 - 2 * i, this.getSize().height - 1 - 2 * i);
            ++i;
        }
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
        this.repaint();
    }

    public void setBorderWidth(int w) {
        this.borderWidth = w;
        this.repaint();
    }

    public void setBottomComponent(BoxElement bottomComponent) {
        this.bottom = bottomComponent;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.calculateGeometry();
        if (this.lineList != null) {
            Iterator list = this.lineList.iterator();
            while (list.hasNext()) {
                ((LineElement)list.next()).calculateGeometry();
            }
        }
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.update();
    }

    public void setFont(Font f) {
        if (!f.equals(this.getFont())) {
            super.setFont(f);
            this.calculateGeometry();
        }
    }

    public void setInFocus(boolean b) {
        if (b != this.inFocus) {
            this.inFocus = b;
            this.update();
        }
    }

    public void setInPath(boolean b) {
        if (b != this.inPath) {
            this.inPath = b;
            this.update();
            if (this.lineList != null) {
                Iterator list = this.lineList.iterator();
                while (list.hasNext()) {
                    ((LineElement)list.next()).update();
                }
            }
        }
    }

    public void setLayer(int l) {
        if (l >= 0 && l <= 6) {
            this.layer = l;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": setLayer: Unknown layer received: " + l);
            this.layer = -1;
        }
    }

    public void setLeftCursorComponent(BoxInterface leftComponent) {
        if (this.leftCursorList == null) {
            this.leftCursorList = new ArrayList();
        }
        this.leftCursorList.add((Object)leftComponent);
        leftComponent.addRightCursorComponent(this);
    }

    public void setLeftPathComponent(BoxInterface leftComponent) {
        if (this.leftPathList == null) {
            this.leftPathList = new ArrayList();
        }
        this.leftPathList.add((Object)leftComponent);
        leftComponent.addRightPathComponent(this);
        LineElement line = new LineElement(leftComponent, this);
        this.addLine(line);
        leftComponent.addLine(line);
        line.repaint();
    }

    public void setSelectable(boolean b) {
        if (b != this.selectable) {
            this.selectable = b;
            this.update();
        }
    }

    public void setText(String t) {
        this.text = t;
        this.calculateGeometry();
    }

    public void setTopComponent(BoxElement topComponent) {
        this.top = topComponent;
        this.top.setBottomComponent(this);
    }

    public void setValidOnlyInSTMn(boolean b) {
        this.validOnlyInSTMn = b;
    }

    public void setValue(int v) {
        this.value = v;
    }

    public String toString() {
        String thisName = this.getName();
        String str = thisName == null || thisName.length() == 0 ? "BoxElement" : thisName;
        return str;
    }

    private void update() {
        this.setBorderWidth(1);
        this.setFont(RocketDiagramDefaults.defaultFont);
        if (!this.isEnabled()) {
            this.setBackground(RocketDiagramDefaults.invalidBackground);
            this.setForeground(RocketDiagramDefaults.invalidForeground);
            this.setBorderColor(RocketDiagramDefaults.invalidBorderColor);
            if (this.isSelectable()) {
                this.setBackground(RocketDiagramDefaults.selectableBackground);
                this.setForeground(RocketDiagramDefaults.selectableForeground);
            }
        } else if (this.isInPath()) {
            this.setFont(RocketDiagramDefaults.inPathFont);
            this.setBackground(RocketDiagramDefaults.inPathBackground);
            this.setForeground(RocketDiagramDefaults.inPathForeground);
            this.setBorderColor(RocketDiagramDefaults.inPathBorderColor);
            if (this.isSelectable()) {
                this.setBorderColor(RocketDiagramDefaults.selectableBorderColor);
                if (this.isInFocus()) {
                    this.setBackground(RocketDiagramDefaults.inFocusBackgroundColor);
                    this.setBorderColor(RocketDiagramDefaults.inFocusBorderColor);
                    this.setBorderWidth(3);
                }
            }
        } else {
            this.setBackground(RocketDiagramDefaults.notInPathBackground);
            this.setForeground(RocketDiagramDefaults.notInPathForeground);
            this.setBorderColor(RocketDiagramDefaults.notInPathBorderColor);
            if (this.isSelectable()) {
                this.setBackground(RocketDiagramDefaults.selectableBackground);
                this.setBorderColor(RocketDiagramDefaults.selectableBorderColor);
            }
        }
        this.repaint();
    }
}

