/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.rocket;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;

public class DBconnection
implements CcConnectedComponent,
MaskedIntegerDataReceiver {
    private ApplicationObject theAppObject = null;
    private String dbVariable = "";
    private int dbValue = -1;
    private int priority = 0;
    private MaskedIntegerDataReceiver dataHandler = null;
    private int currentValue = -1;
    public boolean hasTrappedTransientError = false;
    public boolean hasTrappedPermanentError = false;

    public DBconnection(MaskedIntegerDataReceiver dataHandler, String dbVariable, int priority) {
        this.dataHandler = dataHandler;
        this.dbVariable = dbVariable;
        this.priority = priority;
        this.initialize();
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else {
            this.theAppObject = anAO;
        }
    }

    public void finishInitialise() {
    }

    public ApplicationObject getAppObject() {
        return this.theAppObject;
    }

    public int getDBValue() {
        return this.dbValue;
    }

    public String getName() {
        return this.dbVariable;
    }

    public int getValue() {
        return this.currentValue;
    }

    public void initialize() {
        this.trapTransientError(true);
        ApplicationManager.instance().request("ISS", this.priority, this.dbVariable, (ApplicationObjectObserver)this);
    }

    public void permanentError() {
        this.hasTrappedTransientError = false;
        this.hasTrappedPermanentError = true;
        EventLog.instance().log("ERROR: " + this.toString() + ": A permanent error occurred in application object " + this.theAppObject.toString());
        this.unregister();
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        this.trapTransientError(false);
        this.dbValue = v.getValue();
        this.dataHandler.receiveMaskedIntegerData(v, s);
    }

    public void revertToLastReceivedValue() {
        this.setValue(this.dbValue);
    }

    public void setValue(int value) {
        this.currentValue = value;
    }

    public boolean setValueInDatabase() {
        return this.setValueInDatabase(this.currentValue);
    }

    public boolean setValueInDatabase(int value) {
        MaskedIntegerValue miv = new MaskedIntegerValue(value);
        boolean rsp = true;
        if (!this.theAppObject.change((ApplicationData)miv)) {
            EventLog.instance().log("ERROR: " + this.toString() + ": setValueInDatabase: ISS refused to change the value.");
            EventLog.instance().log("ERROR: " + this.toString() + ": setValueInDatabase: Current value = " + this.getValue() + " Failed new value = " + value);
            rsp = false;
        }
        return rsp;
    }

    public String toString() {
        String thisName = this.getName();
        String str = thisName == null || thisName.length() == 0 ? "DBconnection" : thisName;
        return String.valueOf(str) + "[" + this.dbVariable + "]";
    }

    public void trapTransientError(boolean isInError) {
        this.hasTrappedTransientError = isInError;
    }

    public void unregister() {
        if (this.theAppObject != null) {
            this.theAppObject.unregister((ApplicationObjectObserver)this);
            this.theAppObject = null;
        }
    }

    public void update(ApplicationData v, ApplicationObject o) {
        try {
            v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("ERROR: " + this.toString() + "update: The interface to receive data = " + v.toString() + " from " + o.toString() + " is not implemented");
            this.permanentError();
        }
    }
}

