/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.rocket;

import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.thinclient.rocket.BoxElement;
import com.agilent.tntd.eclipse.thinclient.rocket.ConfirmationListener;
import com.agilent.tntd.eclipse.thinclient.rocket.DBconnection;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramModel;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramPanePage;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramRxConfirmationDialog;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramTxConfirmationDialog;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;

public abstract class DefaultRocketDiagramModel
implements RocketDiagramModel,
ConfirmationListener {
    protected RocketDiagramPanePage panePage = null;
    protected int rocketType = 0;
    protected BoxElement focus = null;
    protected DBconnection confirmationConnection = null;
    protected boolean confirmationRequired = false;
    protected DBconnection stmConnection = null;
    protected DBconnection auConnection = null;
    protected DBconnection tuConnection = null;
    protected DBconnection payConnection = null;
    protected boolean stmIsInitialized = false;
    protected boolean auIsInitialized = false;
    protected boolean tuIsInitialized = false;
    protected boolean payIsInitialized = false;
    protected ArrayList stmList = null;
    protected ArrayList augList = null;
    protected ArrayList auList = null;
    protected ArrayList tugList = null;
    protected ArrayList tuList = null;
    protected ArrayList vcList = null;
    protected ArrayList payList = null;
    protected BoxElement stmInPath = null;
    protected BoxElement auInPath = null;
    protected BoxElement augInPath = null;
    protected BoxElement tugInPath1 = null;
    protected BoxElement tugInPath2 = null;
    protected BoxElement tuInPath = null;
    protected BoxElement vcInPath1 = null;
    protected BoxElement vcInPath2 = null;
    protected BoxElement payInPath = null;
    protected boolean processDatabaseUpdates = true;

    protected void closeWindow() {
        RocketDiagramWindow w;
        if (this.panePage != null && (w = this.panePage.getEnclosingWindow()) != null) {
            w.exit();
        }
    }

    public void finishInitialise() {
        this.confirmationConnection = this.rocketType == 1 ? new DBconnection(this, "RX_ROCKET_GUI_CONF_DIALOG", 0) : new DBconnection(this, "TX_ROCKET_GUI_CONF_DIALOG", 0);
    }

    protected BoxElement getComponent(ArrayList list) {
        BoxElement component = null;
        Iterator iterator = null;
        boolean leftSelected = false;
        boolean rightSelected = false;
        int i = 0;
        while (i < list.size()) {
            component = (BoxElement)list.get(i);
            Collection leftList = component.getLeftPathComponents();
            Collection rightList = component.getRightPathComponents();
            iterator = leftList.iterator();
            while (iterator.hasNext()) {
                if (!((BoxElement)iterator.next()).isInPath()) continue;
                leftSelected = true;
                break;
            }
            iterator = rightList.iterator();
            while (iterator.hasNext()) {
                if (!((BoxElement)iterator.next()).isInPath()) continue;
                rightSelected = true;
                break;
            }
            if (leftSelected && rightSelected) break;
            component = null;
            leftSelected = false;
            rightSelected = false;
            ++i;
        }
        return component;
    }

    protected BoxElement getComponent(ArrayList list, int value) {
        BoxElement component = null;
        int i = 0;
        while (i < list.size()) {
            component = (BoxElement)list.get(i);
            if (component.getValue() == value) break;
            component = null;
            ++i;
        }
        return component;
    }

    public void handleDownKeyPress() {
        if (this.focus == null) {
            return;
        }
        BoxElement bottom = this.focus.getBottomComponent();
        this.handleRandomSelection(bottom);
    }

    public void handleLeftKeyPress() {
        if (this.focus == null) {
            return;
        }
        Collection leftList = this.focus.getLeftCursorComponents();
        if (leftList != null) {
            BoxElement component = null;
            Iterator iterator = leftList.iterator();
            while (iterator.hasNext()) {
                component = (BoxElement)iterator.next();
                if (!component.isInPath() || !component.isEnabled() || !component.isSelectable()) continue;
                this.focus.setInFocus(false);
                this.focus = component;
                this.focus.setInFocus(true);
                break;
            }
        }
    }

    public abstract void handleRandomSelection(BoxElement var1);

    public void handleRightKeyPress() {
        if (this.focus == null) {
            return;
        }
        Collection rightList = this.focus.getRightCursorComponents();
        if (rightList != null) {
            BoxElement component = null;
            Iterator iterator = rightList.iterator();
            while (iterator.hasNext()) {
                component = (BoxElement)iterator.next();
                if (!component.isInPath() || !component.isEnabled() || !component.isSelectable()) continue;
                this.focus.setInFocus(false);
                this.focus = component;
                this.focus.setInFocus(true);
                break;
            }
        }
    }

    public void handleSaveKeyPress() {
        if (this.confirmationRequired) {
            if (this.rocketType == 1) {
                RocketDiagramRxConfirmationDialog d = new RocketDiagramRxConfirmationDialog(this);
                WindowManager.instance().connectWindow((InternalWindow)d);
            } else {
                RocketDiagramTxConfirmationDialog d = new RocketDiagramTxConfirmationDialog(this);
                WindowManager.instance().connectWindow((InternalWindow)d);
            }
        } else {
            this.save();
        }
    }

    public void handleUpKeyPress() {
        if (this.focus == null) {
            return;
        }
        BoxElement top = this.focus.getTopComponent();
        this.handleRandomSelection(top);
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (this.confirmationConnection != null && this.confirmationConnection.getAppObject() == s) {
            this.confirmationRequired = v.getValue() != 0;
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: Unknown application object received");
        }
    }

    protected abstract void reset();

    public void save() {
        if (this.saveDatabaseState()) {
            this.closeWindow();
        }
    }

    protected boolean setAU() {
        this.auInPath = this.getComponent(this.auList, this.auConnection.getValue());
        if (this.auInPath != null) {
            this.auInPath.setInPath(true);
            return true;
        }
        EventLog.instance().log("ERROR: " + this.toString() + ": setAU: No component found with matching AU value");
        EventLog.instance().log("INFO:  " + this.toString() + ": setAU: AU value in database is " + this.auConnection.getValue());
        return false;
    }

    protected abstract void setEnabled();

    protected abstract void setFocus();

    public void setPanePage(RocketDiagramPanePage p) {
        this.panePage = p;
    }

    protected abstract boolean setPath();

    protected abstract void setSelectable();

    protected boolean setSTM() {
        int value = -1;
        switch (this.stmConnection.getValue()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                value = 1;
                break;
            }
            case 0: {
                value = 0;
                break;
            }
            default: {
                EventLog.instance().log("ERROR: " + this.toString() + ": setSTM: Ambiguous information sent from database. Cannot set the STM component.");
                EventLog.instance().log("INFO:  " + this.toString() + ": setSTM: STM value in database is " + this.stmConnection.getValue());
            }
        }
        this.stmInPath = this.getComponent(this.stmList, value);
        if (this.stmInPath != null) {
            this.stmInPath.setInPath(true);
            return true;
        }
        EventLog.instance().log("ERROR: " + this.toString() + ": setSTM: No component found with matching STM value");
        EventLog.instance().log("INFO:  " + this.toString() + ": setSTM: STM value in database is " + this.stmConnection.getValue());
        return false;
    }

    public void unregister() {
        if (this.confirmationConnection != null) {
            this.confirmationConnection.unregister();
            this.confirmationConnection = null;
        }
    }

    protected void update() {
        this.reset();
        if (this.setPath()) {
            this.setEnabled();
            this.setSelectable();
            this.setFocus();
        } else {
            EventLog.instance().log("ERROR: " + this.toString() + ": update: Failed to set path correctly - check that database values are valid.");
        }
    }

    public abstract boolean saveDatabaseState();
}

