/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.rocket;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.thinclient.rocket.BoxInterface;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramDefaults;
import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;

public class LineElement
extends Component {
    private BoxInterface leftComponent = null;
    private BoxInterface rightComponent = null;
    private ArrayList rightCompList = null;
    private boolean thick = false;
    private Point leftEndpoint = null;
    private Point rightEndpoint = null;

    public LineElement(BoxInterface left, BoxInterface right) {
        this.leftComponent = left;
        this.rightComponent = right;
        this.initialize();
    }

    void calculateGeometry() {
        int h;
        int y;
        if (this.leftComponent == null || this.rightComponent == null) {
            return;
        }
        Point leftLocation = this.leftComponent.getLocation();
        Point rightLocation = this.rightComponent.getLocation();
        int x = leftLocation.x + this.leftComponent.getSize().width;
        int w = rightLocation.x - x;
        if (leftLocation.y < rightLocation.y) {
            y = leftLocation.y;
            h = rightLocation.y + this.rightComponent.getSize().height - y;
            this.leftEndpoint.y = this.leftComponent.getSize().height / 2;
            this.rightEndpoint.y = h - this.rightComponent.getSize().height / 2;
        } else {
            y = rightLocation.y;
            h = leftLocation.y + this.leftComponent.getSize().height - y;
            this.leftEndpoint.y = h - this.leftComponent.getSize().height / 2;
            this.rightEndpoint.y = this.rightComponent.getSize().height / 2;
        }
        this.leftEndpoint.x = 0;
        this.rightEndpoint.x = w;
        if (Math.abs(this.rightEndpoint.y - this.leftEndpoint.y) == 1) {
            this.rightEndpoint.y = this.leftEndpoint.y;
        }
        this.setBounds(x, y, w, h);
        this.repaint();
    }

    private void initialize() {
        this.leftEndpoint = new Point(0, 0);
        this.rightEndpoint = new Point(0, 0);
        this.update();
        this.calculateGeometry();
        if (this.leftComponent != null) {
            this.leftComponent.getParent().add(this);
        } else if (this.rightComponent != null) {
            this.rightComponent.getParent().add(this);
        }
    }

    private boolean isThick() {
        return this.thick;
    }

    public void paint(Graphics g) {
        g.setColor(this.getForeground());
        g.drawLine(this.leftEndpoint.x, this.leftEndpoint.y, this.rightEndpoint.x, this.rightEndpoint.y);
        if (this.isThick()) {
            g.drawLine(this.leftEndpoint.x, this.leftEndpoint.y + 1, this.rightEndpoint.x, this.rightEndpoint.y + 1);
            g.drawLine(this.leftEndpoint.x, this.leftEndpoint.y - 1, this.rightEndpoint.x, this.rightEndpoint.y - 1);
        }
    }

    private void setThick(boolean b) {
        this.thick = b;
    }

    public String toString() {
        String thisName = this.getName();
        String str = thisName == null || thisName.length() == 0 ? "LineElement" : thisName;
        return str;
    }

    void update() {
        if (this.leftComponent == null || this.rightComponent == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": update: LineElement exists with no left/right component");
            return;
        }
        if (this.leftComponent.isInPath() && this.rightComponent.isInPath()) {
            this.setForeground(RocketDiagramDefaults.inPathLineColor);
            this.setThick(true);
        } else {
            this.setForeground(RocketDiagramDefaults.defaultLineColor);
            this.setThick(false);
        }
        this.repaint();
    }
}

