/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.rocket;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramDefaults;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import java.awt.Component;
import java.awt.Container;

public class RocketDiagramPane
extends EclPanePage
implements CcConnectedComponent,
MaskedIntegerDataReceiver {
    private transient RocketDiagramPanePage thePage = null;
    private transient ApplicationObject theAppObject = null;
    private transient boolean hasTrappedTransientError = false;
    private transient boolean hasTrappedPermanentError = false;
    private String dbVariable = "TX_ROCKET_GUI_TYPE";
    public boolean transmit = true;

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        if (aReport.getErrorStatus() == 1) {
            EventLog.instance().log("ERROR: " + this.toString() + ": acknowledgeInitialisation: Failed to initialise because " + anAO.toString() + " failed to initialise.");
            this.permanentError();
        } else {
            this.theAppObject = anAO;
        }
    }

    public void finishInitialise() {
        this.dbVariable = this.transmit ? "TX_ROCKET_GUI_TYPE" : "RX_ROCKET_GUI_TYPE";
        ApplicationManager.instance().request("ISS", 1, this.dbVariable, (ApplicationObjectObserver)this);
        super.finishInitialise();
    }

    private String getClassName(int type) {
        String className = "";
        switch (type) {
            case 15: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sdh.SDH10GPanePage";
                break;
            }
            case 11: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sdh.SDH2G5PanePage";
                break;
            }
            case 7: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sdh.SDH622MPanePage";
                break;
            }
            case 13: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sdh_phase1.SDH10GPanePage";
                break;
            }
            case 9: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sdh_phase1.SDH2G5PanePage";
                break;
            }
            case 5: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sdh_phase1.SDH622MPanePage";
                break;
            }
            case 16: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sonet.SONET10GPanePage";
                break;
            }
            case 12: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sonet.SONET2G5PanePage";
                break;
            }
            case 8: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sonet.SONET622MPanePage";
                break;
            }
            case 14: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sonet_phase1.SONET10GPanePage";
                break;
            }
            case 10: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sonet_phase1.SONET2G5PanePage";
                break;
            }
            case 6: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.sonet_phase1.SONET622MPanePage";
                break;
            }
            case 21: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.pdh_only.SDH_PDHPanePage";
                break;
            }
            case 22: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.pdh_only.SONET_PDHPanePage";
                break;
            }
            case 23: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.pdh_only.EthernetSDH_PDHPanePage";
                break;
            }
            case 24: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.pdh_only.EthernetSONET_PDHPanePage";
                break;
            }
            case 25: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.lowlevel.SDH_LowLevelNoPDHPanePage";
                break;
            }
            case 26: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.lowlevel.SONET_LowLevelNoPDHPanePage";
                break;
            }
            case 27: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.lowlevel.EthernetSDH_LowLevelNoPDHPanePage";
                break;
            }
            case 28: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.lowlevel.EthernetSONET_LowLevelNoPDHPanePage";
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                className = "com.agilent.tntd.eclipse.thinclient.rocket.InvalidPanePage";
                break;
            }
            default: {
                EventLog.instance().log("ERROR: " + this.toString() + ": getClassName: Unknown Rocket Diagram type");
                className = "com.agilent.tntd.eclipse.thinclient.rocket.InvalidPanePage";
            }
        }
        return className;
    }

    public boolean isTransmit() {
        return this.transmit;
    }

    public void permanentError() {
        this.setBackground(RocketDiagramDefaults.permanentErrorColour);
        this.hasTrappedPermanentError = true;
        this.hasTrappedTransientError = false;
        ((Component)((Object)this)).setVisible(true);
        this.unregister();
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue miv, ApplicationDataSender o) {
        int type = miv.getValue();
        String className = this.getClassName(type);
        try {
            if (this.thePage == null) {
                this.thePage = (RocketDiagramPanePage)((Object)Class.forName(className).newInstance());
            } else {
                if (Class.forName(className).isInstance((Object)this.thePage)) {
                    return;
                }
                this.thePage.unregister();
                ((Container)((Object)this)).remove((Component)((Object)this.thePage));
                this.thePage = null;
                this.thePage = (RocketDiagramPanePage)((Object)Class.forName(className).newInstance());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            EventLog.instance().log("ERROR: " + this.toString() + ": receiveMaskedIntegerData: Class not found: " + className);
            this.permanentError();
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.permanentError();
            return;
        }
        ((Container)((Object)this)).add((Component)((Object)this.thePage), ((Component)((Object)this.thePage)).getName());
        if (this.transmit) {
            this.thePage.setRocketType(0);
        } else {
            this.thePage.setRocketType(1);
        }
        this.thePage.finishInitialise();
        ((Component)((Object)this.thePage)).setVisible(true);
        ((Component)((Object)this)).repaint();
    }

    public void setTransmit(boolean newTransmit) {
        this.transmit = newTransmit;
    }

    public String toString() {
        String thisName = ((Component)((Object)this)).getName();
        String str = thisName == null || thisName.length() == 0 ? "RocketDiagramPane" : thisName;
        return String.valueOf(str) + "[" + this.dbVariable + "]";
    }

    public void trapTransientError(boolean isInError) {
        this.hasTrappedTransientError = isInError;
    }

    public void unregister() {
        if (this.theAppObject != null) {
            this.theAppObject.unregister((ApplicationObjectObserver)this);
            this.theAppObject = null;
        }
        if (this.thePage != null) {
            this.thePage.unregister();
            ((Container)((Object)this)).remove((Component)((Object)this.thePage));
            this.thePage = null;
        }
        super.unregister();
    }

    public void update(ApplicationData v, ApplicationObject o) {
        try {
            v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("ERROR: " + this.toString() + "update: The interface to receive data = " + v.toString() + " from " + o.toString() + " is not implemented");
            this.permanentError();
        }
    }
}

