/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.rocket;

import com.agilent.tntd.eclipse.thinclient.rocket.BoxElement;
import com.agilent.tntd.eclipse.thinclient.rocket.BoxGroup;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramModel;
import com.agilent.tntd.eclipse.thinclient.rocket.RocketDiagramWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.EclipseSystem;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.EclipseFocusManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.architecture.mouse.GenericMouseHelper;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public abstract class RocketDiagramPanePage
extends EclPanePage {
    public transient int rocketType;
    private transient RocketDiagramModel theModel = null;
    private static UnconsumedKeyHandler theMainKeyController = null;
    private transient long timeOfLastEvent = 0L;
    private transient int clickInterval;
    private transient boolean hasFocus = false;

    public RocketDiagramPanePage() {
        this.initialize();
    }

    protected abstract RocketDiagramModel createModel();

    public void finishInitialise() {
        super.finishInitialise();
        this.theModel = this.createModel();
        this.clickInterval = Integer.getInteger("awt.mouse.ClickInterval", 250);
    }

    protected RocketDiagramWindow getEnclosingWindow() {
        Container p = ((Component)((Object)this)).getParent();
        while (p != null) {
            if (p instanceof RocketDiagramWindow) {
                return (RocketDiagramWindow)((Object)p);
            }
            p = p.getParent();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    UnconsumedKeyHandler getMainKeyController() {
        block2: {
            if (RocketDiagramPanePage.theMainKeyController != null) break block2;
            c = this.getParent();
            if (c != null) ** GOTO lbl6
            throw new NullPointerException("Cannot find the parent of " + this.toString());
lbl-1000:
            // 1 sources

            {
                c = c.getParent();
lbl6:
                // 2 sources

                ** while (c.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(c instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + c.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            RocketDiagramPanePage.theMainKeyController = (UnconsumedKeyHandler)c;
        }
        return RocketDiagramPanePage.theMainKeyController;
    }

    public int getRocketType() {
        return this.rocketType;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    private void initialize() {
        ((Component)((Object)this)).enableEvents(28L);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        switch (e.getID()) {
            case 1004: {
                if (!((Component)((Object)this)).isEnabled()) {
                    EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible((Component)((Object)this));
                    this.hasFocus = false;
                    return;
                }
                this.hasFocus = true;
                break;
            }
            case 1005: {
                if (e.isTemporary()) break;
                this.hasFocus = false;
            }
        }
        ((Component)((Object)this)).repaint();
    }

    public void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType((KeyEvent)e)) {
                case 37: {
                    if (this.theModel != null) {
                        this.theModel.handleLeftKeyPress();
                    }
                    e.consume();
                    break;
                }
                case 39: {
                    if (this.theModel != null) {
                        this.theModel.handleRightKeyPress();
                    }
                    e.consume();
                    break;
                }
                case 38: {
                    if (this.theModel != null) {
                        this.theModel.handleUpKeyPress();
                    }
                    e.consume();
                    break;
                }
                case 40: {
                    if (this.theModel != null) {
                        this.theModel.handleDownKeyPress();
                    }
                    e.consume();
                    break;
                }
                case 10: {
                    if (this.theModel == null) break;
                    this.theModel.handleSaveKeyPress();
                    e.consume();
                    break;
                }
            }
        }
        if (!e.isConsumed()) {
            this.getMainKeyController().processUnconsumedKeyEvents(e, (Component)((Object)this));
        }
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 500) {
            if (GenericMouseHelper.isLeftMouseButton((MouseEvent)e)) {
                boolean singleClick = false;
                boolean doubleClick = false;
                if (GenericMouseHelper.isSingleClick((MouseEvent)e)) {
                    singleClick = true;
                    if (EclipseSystem.instance().isOnInstrument()) {
                        if (e.getWhen() - this.timeOfLastEvent <= (long)this.clickInterval) {
                            singleClick = false;
                            doubleClick = true;
                        }
                        this.timeOfLastEvent = e.getWhen();
                    }
                } else if (GenericMouseHelper.isDoubleClick((MouseEvent)e)) {
                    doubleClick = true;
                }
                if (singleClick) {
                    BoxElement b;
                    Component c = ((Container)((Object)this)).getComponentAt(e.getX(), e.getY());
                    if (c instanceof BoxGroup) {
                        int newX = e.getX() - c.getBounds().x;
                        int newY = e.getY() - c.getBounds().y;
                        c = c.getComponentAt(newX, newY);
                    }
                    if (c instanceof BoxElement && (b = (BoxElement)c).isSelectable()) {
                        this.theModel.handleRandomSelection(b);
                    }
                } else if (doubleClick) {
                    this.processKeyEvent(InstrumentKeyMappings.getSelectKeyEvent((Component)((Object)this)));
                }
            } else if (GenericMouseHelper.isRightMouseButton((MouseEvent)e)) {
                this.processKeyEvent(InstrumentKeyMappings.getMenuKeyEvent((Component)((Object)this)));
            }
        }
    }

    public final void removeNotify() {
        super.removeNotify();
        if (this.hasFocus) {
            this.processFocusEvent(new FocusEvent((Component)((Object)this), 1005));
        }
    }

    public void requestFocus() {
        if (this.isFocusTraversable() && EclipseFocusManager.getInstance().canRequestFocus((Component)((Object)this))) {
            super.requestFocus();
        }
    }

    public void setRocketType(int newRocketType) {
        this.rocketType = newRocketType;
    }

    public String toString() {
        String thisName = ((Component)((Object)this)).getName();
        String str = thisName == null || thisName.length() == 0 ? "RocketDiagramPanePage" : thisName;
        return str;
    }

    public void unregister() {
        super.unregister();
        if (this.theModel != null) {
            this.theModel.unregister();
            this.theModel = null;
        }
        if (this.hasFocus()) {
            EclipseFocusManager.getInstance().focusWhenComponentBecomeUnvisible((Component)((Object)this));
        }
    }
}

