/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.rocket.sdh;

import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.thinclient.rocket.BoxElement;
import com.agilent.tntd.eclipse.thinclient.rocket.DBconnection;
import com.agilent.tntd.eclipse.thinclient.rocket.DefaultRocketDiagramModel;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;

public class SDHModel
extends DefaultRocketDiagramModel {
    private int vcValue;
    private boolean changeVC = true;

    public SDHModel(int rocketType, ArrayList stmList, ArrayList augList, ArrayList auList, ArrayList tugList, ArrayList tuList, ArrayList vcList, ArrayList payList) {
        this.rocketType = rocketType;
        this.stmList = stmList;
        this.augList = augList;
        this.auList = auList;
        this.tugList = tugList;
        this.tuList = tuList;
        this.vcList = vcList;
        this.payList = payList;
    }

    private void calculateLeftComponents(BoxElement start) {
        if (start == null) {
            return;
        }
        BoxElement current = null;
        BoxElement component = null;
        Collection list = null;
        Iterator iterator = null;
        current = start;
        list = current.getLeftPathComponents();
        this.changeVC = start.getLayer() != 4;
        while (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                component = (BoxElement)iterator.next();
                if (component.isInPath()) break;
                component = null;
            }
            if (component == null || !this.componentIsAllowedInPath(component)) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    component = (BoxElement)iterator.next();
                    if (this.componentIsAllowedInPath(component)) break;
                    component = null;
                }
            }
            if (component != null) {
                this.changeComponentInLayer(component);
                current = component;
                list = current.getLeftPathComponents();
                continue;
            }
            EventLog.instance().log("ERROR: " + this.toString() + ": calculateLeftComponents: No valid left component found for " + current.getName());
            break;
        }
    }

    private void calculateRightComponents(BoxElement start) {
        if (start == null) {
            return;
        }
        BoxElement current = null;
        BoxElement component = null;
        Collection list = null;
        Iterator iterator = null;
        current = start;
        list = current.getRightPathComponents();
        while (list != null) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                component = (BoxElement)iterator.next();
                if (component.isInPath()) break;
                component = null;
            }
            if (component == null || !this.componentIsAllowedInPath(component)) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    component = (BoxElement)iterator.next();
                    if (this.componentIsAllowedInPath(component)) break;
                    component = null;
                }
            }
            if (component != null) {
                this.changeVC = true;
                this.changeComponentInLayer(component);
                current = component;
                list = current.getRightPathComponents();
                continue;
            }
            EventLog.instance().log("ERROR: " + this.toString() + ": calculateRightComponents: No valid right component found for " + current.getName());
            break;
        }
    }

    private void changeComponentInLayer(BoxElement component) {
        if (component == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": changeComponentInLayer: component is NULL");
            return;
        }
        int layer = component.getLayer();
        int value = component.getValue();
        switch (layer) {
            case 2: {
                this.auConnection.setValue(value);
                break;
            }
            case 4: {
                this.tuConnection.setValue(value);
                break;
            }
            case 5: {
                if (!this.changeVC) break;
                this.vcValue = value < 0 ? 2 : value;
                this.changeVC = false;
                break;
            }
            case 6: {
                if (value < -100) {
                    this.payConnection.setValue(8);
                    break;
                }
                if (value < 0) {
                    this.payConnection.setValue(0);
                    break;
                }
                this.payConnection.setValue(value);
            }
        }
    }

    private boolean componentCanReceiveFocus(BoxElement component) {
        if (component == null) {
            return false;
        }
        int layer = component.getLayer();
        boolean focusAllowed = true;
        switch (layer) {
            case 2: {
                if (this.stmConnection.getValue() != 0) break;
                focusAllowed = false;
                break;
            }
            case 4: {
                if (this.payConnection.getValue() == 2) break;
                focusAllowed = false;
            }
        }
        return focusAllowed;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean componentIsAllowedInPath(BoxElement component) {
        if (component == null) {
            return false;
        }
        if (!component.isEnabled()) {
            return false;
        }
        int layer = component.getLayer();
        boolean allowedInPath = true;
        switch (layer) {
            case 4: {
                switch (this.vcValue) {
                    case 5: {
                        if (component.getValue() == 3 || this.payConnection.getValue() == 2) return allowedInPath;
                        allowedInPath = false;
                        break;
                    }
                    case 4: {
                        if (component.getValue() == 2 || this.payConnection.getValue() == 2) return allowedInPath;
                        allowedInPath = false;
                    }
                }
                return allowedInPath;
            }
        }
        return allowedInPath;
    }

    public void finishInitialise() {
        String payVarName;
        String tuVarName;
        String auVarName;
        String stmVarName;
        super.finishInitialise();
        if (this.rocketType == 1) {
            stmVarName = "RX_ROCKET_GUI_RATE";
            auVarName = "RX_ROCKET_GUI_AU";
            tuVarName = "RX_ROCKET_GUI_TU";
            payVarName = "RX_ROCKET_GUI_PAYLOAD";
        } else {
            if (this.rocketType != 0) {
                EventLog.instance().log("ERROR: " + this.toString() + ": finishInitialise: Unknown Rocket Diagram type: " + this.rocketType + ". Defaulting to TX.");
            }
            stmVarName = "TX_ROCKET_GUI_RATE";
            auVarName = "TX_ROCKET_GUI_AU";
            tuVarName = "TX_ROCKET_GUI_TU";
            payVarName = "TX_ROCKET_GUI_PAYLOAD";
        }
        this.stmIsInitialized = false;
        this.auIsInitialized = false;
        this.tuIsInitialized = false;
        this.payIsInitialized = false;
        this.processDatabaseUpdates = true;
        this.stmConnection = new DBconnection(this, stmVarName, 0);
        this.auConnection = new DBconnection(this, auVarName, 0);
        this.tuConnection = new DBconnection(this, tuVarName, 0);
        this.payConnection = new DBconnection(this, payVarName, 0);
    }

    public void handleRandomSelection(BoxElement b) {
        if (b != null) {
            if (b.getLayer() == 6 || b.getLayer() == 2) {
                this.tuConnection.setValue(0);
            }
            if (b.isEnabled()) {
                this.changeVC = true;
                this.changeComponentInLayer(b);
                this.calculateLeftComponents(b);
                this.calculateRightComponents(b);
                if (this.focus != null) {
                    this.focus.setInFocus(false);
                }
                this.focus = b;
                this.focus.setInFocus(true);
                this.update();
            }
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (this.stmConnection != null && this.stmConnection.getAppObject() == s) {
            if (this.processDatabaseUpdates) {
                this.stmConnection.setValue(v.getValue());
            }
            this.stmIsInitialized = true;
        } else if (this.auConnection != null && this.auConnection.getAppObject() == s) {
            if (this.processDatabaseUpdates) {
                this.auConnection.setValue(v.getValue());
            }
            this.auIsInitialized = true;
        } else if (this.tuConnection != null && this.tuConnection.getAppObject() == s) {
            if (this.processDatabaseUpdates) {
                this.tuConnection.setValue(v.getValue());
            }
            this.tuIsInitialized = true;
        } else if (this.payConnection != null && this.payConnection.getAppObject() == s) {
            if (this.processDatabaseUpdates) {
                this.payConnection.setValue(v.getValue());
            }
            this.payIsInitialized = true;
        } else {
            super.receiveMaskedIntegerData(v, s);
        }
        if (this.processDatabaseUpdates && this.stmIsInitialized && this.auIsInitialized && this.tuIsInitialized && this.payIsInitialized) {
            this.update();
        }
    }

    protected void reset() {
        if (this.stmInPath != null) {
            this.stmInPath.setInPath(false);
            this.stmInPath = null;
        }
        if (this.augInPath != null) {
            this.augInPath.setInPath(false);
            this.augInPath = null;
        }
        if (this.auInPath != null) {
            this.auInPath.setInPath(false);
            this.auInPath = null;
        }
        if (this.tugInPath1 != null) {
            this.tugInPath1.setInPath(false);
            this.tugInPath1 = null;
        }
        if (this.tugInPath2 != null) {
            this.tugInPath2.setInPath(false);
            this.tugInPath2 = null;
        }
        if (this.tuInPath != null) {
            this.tuInPath.setInPath(false);
            this.tuInPath = null;
        }
        if (this.vcInPath1 != null) {
            this.vcInPath1.setInPath(false);
            this.vcInPath1 = null;
        }
        if (this.vcInPath2 != null) {
            this.vcInPath2.setInPath(false);
            this.vcInPath2 = null;
        }
        if (this.payInPath != null) {
            this.payInPath.setInPath(false);
            this.payInPath = null;
        }
    }

    public boolean saveDatabaseState() {
        boolean success;
        this.processDatabaseUpdates = false;
        boolean bl = success = this.auConnection.setValueInDatabase() && this.tuConnection.setValueInDatabase() && this.payConnection.setValueInDatabase();
        if (success) {
            return true;
        }
        EventLog.instance().log("ERROR: " + this.toString() + ": saveDatabaseState: Update database failed. Reverting to values last received from the database.");
        this.stmConnection.revertToLastReceivedValue();
        this.auConnection.revertToLastReceivedValue();
        this.tuConnection.revertToLastReceivedValue();
        this.payConnection.revertToLastReceivedValue();
        this.processDatabaseUpdates = true;
        this.update();
        return false;
    }

    protected void setEnabled() {
        BoxElement component = null;
        int stmValue = this.stmConnection.getValue();
        if (stmValue == 0) {
            int i = 0;
            while (i < this.stmList.size()) {
                component = (BoxElement)this.stmList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(false);
                } else {
                    component.setEnabled(true);
                }
                ++i;
            }
            i = 0;
            while (i < this.auList.size()) {
                component = (BoxElement)this.auList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(false);
                }
                ++i;
            }
            i = 0;
            while (i < this.augList.size()) {
                component = (BoxElement)this.augList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(false);
                }
                ++i;
            }
            i = 0;
            while (i < this.tuList.size()) {
                component = (BoxElement)this.tuList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(false);
                }
                ++i;
            }
            i = 0;
            while (i < this.tugList.size()) {
                component = (BoxElement)this.tugList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(false);
                }
                ++i;
            }
            i = 0;
            while (i < this.vcList.size()) {
                component = (BoxElement)this.vcList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(false);
                }
                ++i;
            }
            i = 0;
            while (i < this.payList.size()) {
                component = (BoxElement)this.payList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(false);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.stmList.size()) {
                component = (BoxElement)this.stmList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(true);
                } else {
                    component.setEnabled(false);
                }
                ++i;
            }
            i = 0;
            while (i < this.augList.size()) {
                component = (BoxElement)this.augList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(true);
                }
                ++i;
            }
            i = 0;
            while (i < this.tuList.size()) {
                component = (BoxElement)this.tuList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(true);
                }
                ++i;
            }
            i = 0;
            while (i < this.tugList.size()) {
                component = (BoxElement)this.tugList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(true);
                }
                ++i;
            }
            i = 0;
            while (i < this.auList.size()) {
                component = (BoxElement)this.auList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(true);
                }
                switch (stmValue) {
                    case 3: {
                        if (component.getValue() != 4) break;
                        component.setEnabled(false);
                        break;
                    }
                    case 2: {
                        if (component.getValue() != 4 && component.getValue() != 3 && component.getValue() != 5) break;
                        component.setEnabled(false);
                        break;
                    }
                    case 1: {
                        if (component.getValue() != 4 && component.getValue() != 3 && component.getValue() != 5 && component.getValue() != 2) break;
                        component.setEnabled(false);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.vcList.size()) {
                component = (BoxElement)this.vcList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(true);
                }
                switch (stmValue) {
                    case 3: {
                        if (component.getValue() != 7) break;
                        component.setEnabled(false);
                        break;
                    }
                    case 2: {
                        if (component.getValue() != 7 && component.getValue() != 6 && component.getValue() != 8) break;
                        component.setEnabled(false);
                        break;
                    }
                    case 1: {
                        if (component.getValue() != 7 && component.getValue() != 6 && component.getValue() != 8 && component.getValue() != 0) break;
                        component.setEnabled(false);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < this.payList.size()) {
                component = (BoxElement)this.payList.get(i);
                if (component.isValidOnlyInSTMn()) {
                    component.setEnabled(true);
                }
                switch (stmValue) {
                    case 3: {
                        if (component.getValue() != -64) break;
                        component.setEnabled(false);
                        break;
                    }
                    case 2: {
                        if (component.getValue() != -64 && component.getValue() != -16 && component.getValue() != -8) break;
                        component.setEnabled(false);
                        break;
                    }
                    case 1: {
                        if (component.getValue() != -64 && component.getValue() != -16 && component.getValue() != -8 && component.getValue() != -44) break;
                        component.setEnabled(false);
                    }
                }
                ++i;
            }
        }
    }

    protected void setFocus() {
        if (this.focus == null) {
            this.focus = this.payInPath;
            this.focus.setInFocus(true);
        } else {
            BoxElement component = null;
            if (this.focus != this.auInPath && this.focus != this.tuInPath && this.focus != this.payInPath) {
                this.focus.setInFocus(false);
                Iterator iterator = null;
                switch (this.focus.getLayer()) {
                    case 2: {
                        iterator = this.auList.iterator();
                        break;
                    }
                    case 4: {
                        iterator = this.tuList.iterator();
                        break;
                    }
                    case 6: {
                        iterator = this.payList.iterator();
                        break;
                    }
                    default: {
                        EventLog.instance().log("ERROR: " + this.toString() + ": setFocus: A component has the focus that resides in layer " + this.focus.getLayer());
                        break;
                    }
                }
                while (iterator != null && iterator.hasNext()) {
                    component = (BoxElement)iterator.next();
                    if (component.isInPath()) break;
                    component = null;
                }
                this.focus = this.componentCanReceiveFocus(component) ? component : this.payInPath;
                this.focus.setInFocus(true);
            } else if (!this.componentCanReceiveFocus(this.focus)) {
                this.focus.setInFocus(false);
                this.focus = this.payInPath;
                this.focus.setInFocus(true);
            }
        }
    }

    protected boolean setPath() {
        boolean status = true;
        status &= this.setSTM();
        status &= this.setAU();
        status &= this.setTU();
        status &= this.setVC();
        status &= this.setPayload();
        this.augInPath = this.getComponent(this.augList);
        if (this.augInPath != null) {
            this.augInPath.setInPath(true);
        }
        return status;
    }

    private boolean setPayload() {
        if (this.payConnection.getValue() == 0) {
            if (this.vcInPath1 != null) {
                switch (this.vcInPath1.getValue()) {
                    case 7: {
                        this.payInPath = this.getComponent(this.payList, -64);
                        break;
                    }
                    case 6: {
                        this.payInPath = this.getComponent(this.payList, -16);
                        break;
                    }
                    case 8: {
                        this.payInPath = this.getComponent(this.payList, -8);
                        break;
                    }
                    case 0: {
                        this.payInPath = this.getComponent(this.payList, -44);
                        break;
                    }
                    case 1: {
                        this.payInPath = this.getComponent(this.payList, -4);
                        break;
                    }
                    case -1: 
                    case 2: {
                        this.payInPath = this.getComponent(this.payList, -3);
                        break;
                    }
                    case 4: {
                        this.payInPath = this.getComponent(this.payList, -12);
                        break;
                    }
                    case 5: {
                        this.payInPath = this.getComponent(this.payList, -11);
                        break;
                    }
                    default: {
                        EventLog.instance().log("ERROR: " + this.toString() + ": setPayload: Could not determine bulk payload because there is no valid Virtual Container");
                        break;
                    }
                }
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": setPayload: Could not determine bulk payload because there is no valid Virtual Container");
            }
        } else if (this.payConnection.getValue() == 8) {
            if (this.vcInPath1 != null) {
                switch (this.vcInPath1.getValue()) {
                    case 7: {
                        this.payInPath = this.getComponent(this.payList, -164);
                        break;
                    }
                    case 6: {
                        this.payInPath = this.getComponent(this.payList, -116);
                        break;
                    }
                    case 8: {
                        this.payInPath = this.getComponent(this.payList, -108);
                        break;
                    }
                    case 0: {
                        this.payInPath = this.getComponent(this.payList, -144);
                        break;
                    }
                    case 1: {
                        this.payInPath = this.getComponent(this.payList, -104);
                        break;
                    }
                    case -1: 
                    case 2: {
                        this.payInPath = this.getComponent(this.payList, -103);
                        break;
                    }
                    default: {
                        EventLog.instance().log("ERROR: " + this.toString() + ": setPayload: Could not determine EOS payload because there is no valid Virtual Container");
                        break;
                    }
                }
            } else {
                EventLog.instance().log("ERROR: " + this.toString() + ": setPayload: Could not determine EOS payload because there is no valid Virtual Container");
            }
        } else {
            this.payInPath = this.getComponent(this.payList, this.payConnection.getValue());
        }
        if (this.payInPath != null) {
            this.payInPath.setInPath(true);
            return true;
        }
        EventLog.instance().log("ERROR: " + this.toString() + ": setPayload: No component found with matching PAYLOAD value");
        EventLog.instance().log("INFO:  " + this.toString() + ": setPayload: Payload value in database is " + this.payConnection.getValue());
        return false;
    }

    protected void setSelectable() {
        int i;
        if (this.stmConnection.getValue() == 0) {
            i = 0;
            while (i < this.auList.size()) {
                ((BoxElement)this.auList.get(i)).setSelectable(false);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.auList.size()) {
                ((BoxElement)this.auList.get(i)).setSelectable(true);
                ++i;
            }
        }
        if (this.payConnection.getValue() != 2) {
            i = 0;
            while (i < this.tuList.size()) {
                ((BoxElement)this.tuList.get(i)).setSelectable(false);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.tuList.size()) {
                BoxElement component = (BoxElement)this.tuList.get(i);
                if (component.getValue() == 1) {
                    component.setSelectable(false);
                } else {
                    component.setSelectable(true);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.payList.size()) {
            ((BoxElement)this.payList.get(i)).setSelectable(true);
            ++i;
        }
    }

    private boolean setTU() {
        int tuValue = this.tuConnection.getValue();
        this.tuInPath = this.getComponent(this.tuList, tuValue);
        if (this.tuInPath != null) {
            this.tuInPath.setInPath(true);
            if (tuValue == 1) {
                this.tugInPath1 = this.getComponent(this.tugList, 0);
            } else if (tuValue == 2 || tuValue == 3) {
                int auValue = this.auConnection.getValue();
                if (auValue == 1) {
                    this.tugInPath1 = this.getComponent(this.tugList, 0);
                    this.tugInPath2 = this.getComponent(this.tugList, 1);
                } else if (auValue == 0) {
                    this.tugInPath1 = this.getComponent(this.tugList, 1);
                } else {
                    EventLog.instance().log("ERROR: " + this.toString() + ": setTU: A database logic error has occurred!");
                    return false;
                }
            }
            if (this.tugInPath1 != null) {
                this.tugInPath1.setInPath(true);
            }
            if (this.tugInPath2 != null) {
                this.tugInPath2.setInPath(true);
            }
        }
        return true;
    }

    private boolean setVC() {
        int auValue = this.auConnection.getValue();
        int tuValue = this.tuConnection.getValue();
        block0 : switch (auValue) {
            case 4: {
                this.vcInPath1 = this.getComponent(this.vcList, 7);
                break;
            }
            case 3: {
                this.vcInPath1 = this.getComponent(this.vcList, 6);
                break;
            }
            case 5: {
                this.vcInPath1 = this.getComponent(this.vcList, 8);
                break;
            }
            case 2: {
                this.vcInPath1 = this.getComponent(this.vcList, 0);
                break;
            }
            case 1: {
                switch (tuValue) {
                    case 1: {
                        this.vcInPath1 = this.getComponent(this.vcList, 2);
                        this.vcInPath2 = this.getComponent(this.vcList, 1);
                        break block0;
                    }
                    case 2: {
                        this.vcInPath1 = this.payConnection.getValue() == 2 ? this.getComponent(this.vcList, 5) : this.getComponent(this.vcList, 4);
                        this.vcInPath2 = this.getComponent(this.vcList, 1);
                        break block0;
                    }
                    case 3: {
                        this.vcInPath1 = this.getComponent(this.vcList, 5);
                        this.vcInPath2 = this.getComponent(this.vcList, 1);
                        break block0;
                    }
                }
                this.vcInPath1 = this.getComponent(this.vcList, 1);
                break;
            }
            case 0: {
                switch (tuValue) {
                    case 2: {
                        this.vcInPath1 = this.payConnection.getValue() == 2 ? this.getComponent(this.vcList, 5) : this.getComponent(this.vcList, 4);
                        this.vcInPath2 = this.getComponent(this.vcList, -1);
                        break block0;
                    }
                    case 3: {
                        this.vcInPath1 = this.getComponent(this.vcList, 5);
                        this.vcInPath2 = this.getComponent(this.vcList, -1);
                        break block0;
                    }
                }
                this.vcInPath1 = this.getComponent(this.vcList, -1);
            }
        }
        if (this.vcInPath1 == null && this.vcInPath2 == null) {
            EventLog.instance().log("ERROR: " + this.toString() + ": setVC: No VC component found");
            return false;
        }
        if (this.vcInPath1 != null) {
            this.vcInPath1.setInPath(true);
        }
        if (this.vcInPath2 != null) {
            this.vcInPath2.setInPath(true);
        }
        return true;
    }

    public String toString() {
        return "SDHModel";
    }

    public void unregister() {
        super.unregister();
        if (this.stmConnection != null) {
            this.stmConnection.unregister();
            this.stmConnection = null;
        }
        if (this.auConnection != null) {
            this.auConnection.unregister();
            this.auConnection = null;
        }
        if (this.tuConnection != null) {
            this.tuConnection.unregister();
            this.tuConnection = null;
        }
        if (this.payConnection != null) {
            this.payConnection.unregister();
            this.payConnection = null;
        }
    }
}

