/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard;

import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalRates;
import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalWizardDirector;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.SignalDiscoveryUI;
import com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers.ColumnLayout;
import com.agilent.tntd.eclipse.viewlayer.architecture.layoutmanagers.TableLayout;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGauge;
import com.agilent.tntd.eclipse.viewlayer.components.fuelgauge.EclFuelGaugeModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTable;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumn;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableColumnModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.EclTableModel;
import com.agilent.tntd.eclipse.viewlayer.components.table.RowSelectionEvent;
import com.agilent.tntd.eclipse.viewlayer.components.table.RowSelectionListener;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.ActionPerformedEvent;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.ActionPerformedListener;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButton;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButtonModel;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SignalDiscoveryPage
extends EclPanePage
implements SignalDiscoveryUI {
    private EclPanePage ivjNoSignalsPage = null;
    private EclPanePage ivjSearchProgressPage = null;
    private EclPanePage ivjSignalSelectionPage = null;
    private BasicLabel ivjBasicLabel1 = null;
    private BasicLabel ivjBasicLabel11 = null;
    private BasicLabel ivjBasicLabel12 = null;
    private EclTableColumn ivjPortNameColumn = null;
    private EclTableColumn ivjRateColumn = null;
    private EclTable ivjSignalsTable = null;
    private EclTableColumn ivjStatusColumn = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);
    private EclFuelGauge ivjDiscoveryProgressBar = null;
    private transient int numPorts = 0;
    private transient int numOkPorts = 0;
    private transient String firstOkPortName = null;
    private transient ArrayList opticalFlags = new ArrayList();
    private transient ArrayList portNames = new ArrayList();
    private transient ArrayList rateStrings = new ArrayList();
    private transient ArrayList statusStrings = new ArrayList();
    private transient SignalWizardDirector director = null;
    private EclToggleButton ivjNoSignalsCloseButton = null;
    private EclToggleButton ivjNoSignalsRescanButton = null;
    private EclToggleButton ivjSearchCancelButton = null;
    private EclToggleButton ivjSignalSelectionCloseButton = null;
    private EclToggleButton ivjSignalSelectionContinueButton = null;

    public SignalDiscoveryPage() {
        this.initialize();
    }

    public void addPort(String name, int rateKhz, boolean isOptical, boolean isOk) {
        ++this.numPorts;
        if (isOk) {
            ++this.numOkPorts;
            if (this.firstOkPortName == null) {
                this.firstOkPortName = name;
            }
        }
        this.opticalFlags.add((Object)new Boolean(isOptical));
        this.portNames.add((Object)name);
        this.rateStrings.add((Object)SignalRates.getRateDescription(rateKhz, isOptical));
        this.statusStrings.add((Object)(isOk ? "OK" : "Unknown rate"));
        this.getPortNameColumn().setContents((List)this.portNames);
        this.getRateColumn().setContents((List)this.rateStrings);
        this.getStatusColumn().setContents((List)this.statusStrings);
    }

    private void connEtoC1() {
        try {
            this.searchCancelButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.noSignalsCloseButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.signalSelectionCloseButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4() {
        try {
            this.noSignalsRescanButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5() {
        try {
            this.signalsTable_RowSelection();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM5() {
        try {
            this.proceed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void finishInitialise() {
        this.getSearchProgressPage().finishInitialise();
        this.getNoSignalsPage().finishInitialise();
        this.getSignalSelectionPage().finishInitialise();
    }

    private BasicLabel getBasicLabel1() {
        if (this.ivjBasicLabel1 == null) {
            try {
                this.ivjBasicLabel1 = new BasicLabel();
                this.ivjBasicLabel1.setName("BasicLabel1");
                this.ivjBasicLabel1.setFont(new Font("dialog", 1, 14));
                this.ivjBasicLabel1.setText("No active signals on any port");
                this.ivjBasicLabel1.setBounds(0, 78, 317, 20);
                this.ivjBasicLabel1.setHorizontalAlignment(1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBasicLabel1;
    }

    private BasicLabel getBasicLabel11() {
        if (this.ivjBasicLabel11 == null) {
            try {
                this.ivjBasicLabel11 = new BasicLabel();
                this.ivjBasicLabel11.setName("BasicLabel11");
                this.ivjBasicLabel11.setText("Discovering signals...");
                this.ivjBasicLabel11.setBounds(25, 88, 232, 18);
                this.ivjBasicLabel11.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBasicLabel11;
    }

    private BasicLabel getBasicLabel12() {
        if (this.ivjBasicLabel12 == null) {
            try {
                this.ivjBasicLabel12 = new BasicLabel();
                this.ivjBasicLabel12.setName("BasicLabel12");
                this.ivjBasicLabel12.setText("Select an available signal:");
                this.ivjBasicLabel12.setBounds(0, 0, 165, 20);
                this.ivjBasicLabel12.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBasicLabel12;
    }

    private static void getBuilderData() {
    }

    private EclFuelGauge getDiscoveryProgressBar() {
        if (this.ivjDiscoveryProgressBar == null) {
            try {
                this.ivjDiscoveryProgressBar = new EclFuelGauge();
                this.ivjDiscoveryProgressBar.setName("DiscoveryProgressBar");
                this.ivjDiscoveryProgressBar.setBounds(24, 107, 269, 20);
                this.ivjDiscoveryProgressBar.setEclModel(new EclFuelGaugeModel(null, new Color(0, 0, 178), 2, 0, 0));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDiscoveryProgressBar;
    }

    private EclToggleButton getNoSignalsCloseButton() {
        if (this.ivjNoSignalsCloseButton == null) {
            try {
                this.ivjNoSignalsCloseButton = new EclToggleButton();
                this.ivjNoSignalsCloseButton.setName("NoSignalsCloseButton");
                this.ivjNoSignalsCloseButton.setBounds(67, 128, 70, 22);
                this.ivjNoSignalsCloseButton.setEclModel(new EclToggleButtonModel("Close", null, null, true, ""));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNoSignalsCloseButton;
    }

    private EclPanePage getNoSignalsPage() {
        if (this.ivjNoSignalsPage == null) {
            try {
                this.ivjNoSignalsPage = new EclPanePage();
                this.ivjNoSignalsPage.setName("NoSignalsPage");
                this.ivjNoSignalsPage.setBounds(351, 244, 317, 216);
                this.getNoSignalsPage().add((Component)this.getBasicLabel1(), this.getBasicLabel1().getName());
                this.getNoSignalsPage().add((Component)this.getNoSignalsCloseButton(), this.getNoSignalsCloseButton().getName());
                this.getNoSignalsPage().add((Component)this.getNoSignalsRescanButton(), this.getNoSignalsRescanButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNoSignalsPage;
    }

    private EclToggleButton getNoSignalsRescanButton() {
        if (this.ivjNoSignalsRescanButton == null) {
            try {
                this.ivjNoSignalsRescanButton = new EclToggleButton();
                this.ivjNoSignalsRescanButton.setName("NoSignalsRescanButton");
                this.ivjNoSignalsRescanButton.setBounds(180, 128, 70, 22);
                this.ivjNoSignalsRescanButton.setEclModel(new EclToggleButtonModel("Rescan", null, null, true, ""));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNoSignalsRescanButton;
    }

    private EclTableColumn getPortNameColumn() {
        if (this.ivjPortNameColumn == null) {
            try {
                this.ivjPortNameColumn = new EclTableColumn();
                this.ivjPortNameColumn.setName("PortNameColumn");
                this.ivjPortNameColumn.setLayout((LayoutManager)new ColumnLayout());
                this.ivjPortNameColumn.setEclModel(new EclTableColumnModel(null, null, "Port", "2.5G"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPortNameColumn;
    }

    private EclTableColumn getRateColumn() {
        if (this.ivjRateColumn == null) {
            try {
                this.ivjRateColumn = new EclTableColumn();
                this.ivjRateColumn.setName("RateColumn");
                this.ivjRateColumn.setLayout((LayoutManager)new ColumnLayout());
                this.ivjRateColumn.setEclModel(new EclTableColumnModel(null, null, "Rate", "STM-16"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRateColumn;
    }

    private EclToggleButton getSearchCancelButton() {
        if (this.ivjSearchCancelButton == null) {
            try {
                this.ivjSearchCancelButton = new EclToggleButton();
                this.ivjSearchCancelButton.setName("SearchCancelButton");
                this.ivjSearchCancelButton.setBounds(123, 159, 70, 22);
                this.ivjSearchCancelButton.setEclModel(new EclToggleButtonModel("Cancel", null, null, true, ""));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSearchCancelButton;
    }

    private EclPanePage getSearchProgressPage() {
        if (this.ivjSearchProgressPage == null) {
            try {
                this.ivjSearchProgressPage = new EclPanePage();
                this.ivjSearchProgressPage.setName("SearchProgressPage");
                this.ivjSearchProgressPage.setBounds(351, 20, 317, 216);
                this.getSearchProgressPage().add((Component)this.getBasicLabel11(), this.getBasicLabel11().getName());
                this.getSearchProgressPage().add((Component)this.getDiscoveryProgressBar(), this.getDiscoveryProgressBar().getName());
                this.getSearchProgressPage().add((Component)this.getSearchCancelButton(), this.getSearchCancelButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSearchProgressPage;
    }

    private EclToggleButton getSignalSelectionCloseButton() {
        if (this.ivjSignalSelectionCloseButton == null) {
            try {
                this.ivjSignalSelectionCloseButton = new EclToggleButton();
                this.ivjSignalSelectionCloseButton.setName("SignalSelectionCloseButton");
                this.ivjSignalSelectionCloseButton.setBounds(180, 194, 70, 22);
                this.ivjSignalSelectionCloseButton.setEclModel(new EclToggleButtonModel("Close", null, null, true, ""));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSignalSelectionCloseButton;
    }

    private EclToggleButton getSignalSelectionContinueButton() {
        if (this.ivjSignalSelectionContinueButton == null) {
            try {
                this.ivjSignalSelectionContinueButton = new EclToggleButton();
                this.ivjSignalSelectionContinueButton.setName("SignalSelectionContinueButton");
                this.ivjSignalSelectionContinueButton.setBounds(67, 193, 70, 22);
                this.ivjSignalSelectionContinueButton.setEnabled(false);
                this.ivjSignalSelectionContinueButton.setEclModel(new EclToggleButtonModel("Continue", null, null, true, ""));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSignalSelectionContinueButton;
    }

    private EclPanePage getSignalSelectionPage() {
        if (this.ivjSignalSelectionPage == null) {
            try {
                this.ivjSignalSelectionPage = new EclPanePage();
                this.ivjSignalSelectionPage.setName("SignalSelectionPage");
                this.ivjSignalSelectionPage.setBounds(351, 467, 317, 216);
                this.getSignalSelectionPage().add((Component)this.getSignalsTable(), this.getSignalsTable().getName());
                this.getSignalSelectionPage().add((Component)this.getBasicLabel12(), this.getBasicLabel12().getName());
                this.getSignalSelectionPage().add((Component)this.getSignalSelectionContinueButton(), this.getSignalSelectionContinueButton().getName());
                this.getSignalSelectionPage().add((Component)this.getSignalSelectionCloseButton(), this.getSignalSelectionCloseButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSignalSelectionPage;
    }

    private EclTable getSignalsTable() {
        if (this.ivjSignalsTable == null) {
            try {
                this.ivjSignalsTable = new EclTable();
                this.ivjSignalsTable.setName("SignalsTable");
                this.ivjSignalsTable.setLayout((LayoutManager)new TableLayout());
                this.ivjSignalsTable.setBackground(Color.white);
                this.ivjSignalsTable.setBounds(0, 31, 317, 145);
                this.ivjSignalsTable.setEclModel(new EclTableModel(null, null, new Color(0, 0, 0), 7, true, true, true, true));
                this.getSignalsTable().add((Component)this.getPortNameColumn(), this.getPortNameColumn().getName());
                this.getSignalsTable().add((Component)this.getRateColumn(), this.getRateColumn().getName());
                this.getSignalsTable().add((Component)this.getStatusColumn(), this.getStatusColumn().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSignalsTable;
    }

    private EclTableColumn getStatusColumn() {
        if (this.ivjStatusColumn == null) {
            try {
                this.ivjStatusColumn = new EclTableColumn();
                this.ivjStatusColumn.setName("StatusColumn");
                this.ivjStatusColumn.setLayout((LayoutManager)new ColumnLayout());
                this.ivjStatusColumn.setEclModel(new EclTableColumnModel(null, null, "Status", "Unknown rate"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStatusColumn;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getSignalSelectionContinueButton().addActionPerformedListener((ActionPerformedListener)this.ivjEventHandler);
        this.getSearchCancelButton().addActionPerformedListener((ActionPerformedListener)this.ivjEventHandler);
        this.getNoSignalsCloseButton().addActionPerformedListener((ActionPerformedListener)this.ivjEventHandler);
        this.getSignalSelectionCloseButton().addActionPerformedListener((ActionPerformedListener)this.ivjEventHandler);
        this.getNoSignalsRescanButton().addActionPerformedListener((ActionPerformedListener)this.ivjEventHandler);
        this.getSignalsTable().addRowSelectionListener((RowSelectionListener)this.ivjEventHandler);
    }

    private void initialize() {
        try {
            ((Component)((Object)this)).setName("NewSignalDiscoveryPage");
            ((Component)((Object)this)).setSize(317, 216);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            SignalDiscoveryPage aSignalDiscoveryPage = new SignalDiscoveryPage();
            frame.add("Center", (Component)((Object)aSignalDiscoveryPage));
            ((Component)frame).setSize(((Component)((Object)aSignalDiscoveryPage)).getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage");
            exception.printStackTrace(System.out);
        }
    }

    public void noSignalsCloseButton_ActionPerformed() {
        this.director.close();
    }

    public void noSignalsRescanButton_ActionPerformed() {
        Server.instance().applicationInterface().startSignalDiscovery();
    }

    public void proceed() {
        int selectedRow = this.getSignalsTable().getSelectedIndex();
        if (selectedRow >= 0) {
            String selectedPort = (String)this.portNames.get(selectedRow);
            boolean isOptical = (Boolean)this.opticalFlags.get(selectedRow);
            Server.instance().context().setOpticalInterface(isOptical);
            Server.instance().applicationInterface().startStructureScope(selectedPort);
            this.director.showPleaseWaitLabel();
        }
    }

    public void removeAllPorts() {
        this.portNames.clear();
        this.rateStrings.clear();
        this.statusStrings.clear();
        this.opticalFlags.clear();
        this.getPortNameColumn().setContents((List)this.portNames);
        this.getRateColumn().setContents((List)this.rateStrings);
        this.getStatusColumn().setContents((List)this.statusStrings);
        this.getSignalsTable().setSelectedIndex(-1);
        this.numPorts = 0;
        this.numOkPorts = 0;
        this.firstOkPortName = null;
    }

    public void removeNotify() {
        ((Container)((Object)this)).removeAll();
    }

    public void searchCancelButton_ActionPerformed() {
        Server.instance().signalDiscovery().suspend();
        this.director.close();
    }

    public void setDirector(SignalWizardDirector d) {
        this.director = d;
    }

    public void setPercentageComplete(int p) {
        this.getDiscoveryProgressBar().setValue((double)p);
        if (p >= 100) {
            Server.instance().signalDiscovery().suspend();
            if (this.numPorts == 0) {
                this.showPage((Component)this.getNoSignalsPage());
            } else if (this.numPorts == 1 && this.numOkPorts == 1) {
                this.getSignalsTable().setSelectedIndex(0);
                this.proceed();
            } else {
                this.showPage((Component)this.getSignalSelectionPage());
            }
        }
    }

    private void showPage(Component page) {
        if (((Container)((Object)this)).getComponentCount() > 0) {
            ((Container)((Object)this)).removeAll();
        }
        page.setLocation(0, 0);
        ((Container)((Object)this)).add(page);
        page.validate();
        if (page == this.getSearchProgressPage()) {
            this.getSearchCancelButton().requestFocus();
        } else if (page == this.getSignalSelectionPage()) {
            this.getSignalSelectionCloseButton().requestFocus();
        } else if (page == this.getNoSignalsPage()) {
            this.getNoSignalsCloseButton().requestFocus();
        }
        ((Component)((Object)this)).repaint();
    }

    public void signalSelectionCloseButton_ActionPerformed() {
        this.director.close();
    }

    public void signalsTable_RowSelection() {
        int index = this.getSignalsTable().getSelectedIndex();
        boolean canContinue = index > -1 && "OK".equals((String)this.statusStrings.get(index));
        this.getSignalSelectionContinueButton().setEnabled(canContinue);
        this.getSignalSelectionContinueButton().repaint();
    }

    public void start() {
        this.getDiscoveryProgressBar().setValue(0.0);
        this.removeAllPorts();
        this.showPage((Component)this.getSearchProgressPage());
    }

    static void access$connEtoC4(SignalDiscoveryPage signalDiscoveryPage) {
        signalDiscoveryPage.connEtoC4();
    }

    static EclToggleButton access$getSignalSelectionCloseButton(SignalDiscoveryPage signalDiscoveryPage) {
        return signalDiscoveryPage.getSignalSelectionCloseButton();
    }

    static void access$connEtoC5(SignalDiscoveryPage signalDiscoveryPage) {
        signalDiscoveryPage.connEtoC5();
    }

    static EclToggleButton access$getSignalSelectionContinueButton(SignalDiscoveryPage signalDiscoveryPage) {
        return signalDiscoveryPage.getSignalSelectionContinueButton();
    }

    static EclToggleButton access$getSearchCancelButton(SignalDiscoveryPage signalDiscoveryPage) {
        return signalDiscoveryPage.getSearchCancelButton();
    }

    static void access$connEtoM5(SignalDiscoveryPage signalDiscoveryPage) {
        signalDiscoveryPage.connEtoM5();
    }

    static void access$connEtoC2(SignalDiscoveryPage signalDiscoveryPage) {
        signalDiscoveryPage.connEtoC2();
    }

    static EclToggleButton access$getNoSignalsRescanButton(SignalDiscoveryPage signalDiscoveryPage) {
        return signalDiscoveryPage.getNoSignalsRescanButton();
    }

    static void access$connEtoC1(SignalDiscoveryPage signalDiscoveryPage) {
        signalDiscoveryPage.connEtoC1();
    }

    static EclToggleButton access$getNoSignalsCloseButton(SignalDiscoveryPage signalDiscoveryPage) {
        return signalDiscoveryPage.getNoSignalsCloseButton();
    }

    static EclTable access$getSignalsTable(SignalDiscoveryPage signalDiscoveryPage) {
        return signalDiscoveryPage.getSignalsTable();
    }

    static void access$connEtoC3(SignalDiscoveryPage signalDiscoveryPage) {
        signalDiscoveryPage.connEtoC3();
    }

    class IvjEventHandler
    implements RowSelectionListener,
    ActionPerformedListener {
        /* synthetic */ SignalDiscoveryPage this$0;

        public void actionPerformed(ActionPerformedEvent event) {
            if (event.getSource() == SignalDiscoveryPage.access$getSignalSelectionContinueButton(this.this$0)) {
                SignalDiscoveryPage.access$connEtoM5(this.this$0);
            }
            if (event.getSource() == SignalDiscoveryPage.access$getSearchCancelButton(this.this$0)) {
                SignalDiscoveryPage.access$connEtoC1(this.this$0);
            }
            if (event.getSource() == SignalDiscoveryPage.access$getNoSignalsCloseButton(this.this$0)) {
                SignalDiscoveryPage.access$connEtoC2(this.this$0);
            }
            if (event.getSource() == SignalDiscoveryPage.access$getSignalSelectionCloseButton(this.this$0)) {
                SignalDiscoveryPage.access$connEtoC3(this.this$0);
            }
            if (event.getSource() == SignalDiscoveryPage.access$getNoSignalsRescanButton(this.this$0)) {
                SignalDiscoveryPage.access$connEtoC4(this.this$0);
            }
        }

        public void selectRow(RowSelectionEvent event) {
            if (event.getSource() == SignalDiscoveryPage.access$getSignalsTable(this.this$0)) {
                SignalDiscoveryPage.access$connEtoC5(this.this$0);
            }
        }

        IvjEventHandler(SignalDiscoveryPage this$0) {
            this.this$0 = this$0;
        }
    }
}

