/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard;

import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;

public class SignalRates {
    private static final Descriptor[] rates = new Descriptor[]{new Descriptor(2048, false, "2M", "2M"), new Descriptor(8448, false, "8M", "8M"), new Descriptor(34368, false, "34M", "34M"), new Descriptor(139264, false, "140M", "140M"), new Descriptor(1544, false, "DS1", "DS1"), new Descriptor(44736, false, "DS3", "DS3"), new Descriptor(51840, false, "STM-0", "STS-1"), new Descriptor(155520, false, "STM-1", "STS-3"), new Descriptor(622080, false, "STM-4", "STM-4"), new Descriptor(51840, true, "STM-0", "OC-1"), new Descriptor(155520, true, "STM-1", "OC-3"), new Descriptor(622080, true, "STM-4", "OC-12"), new Descriptor(2488320, true, "STM-16", "OC-48"), new Descriptor(9953280, true, "STM-64", "OC-192"), new Descriptor(39813120, true, "STM-256", "OC-768"), new Descriptor(2666057, true, "OTU1", "OTU1"), new Descriptor(10709225, true, "OTU2", "OTU2"), new Descriptor(43018413, true, "OTU3", "OTU3")};
    public static final String OK_STRING = "OK";
    public static final String ERROR_STRING = "Unknown rate";

    public static String getRateDescription(int rateKhz, boolean isOptical) {
        int i = 0;
        while (i < rates.length) {
            if (rateKhz == SignalRates.rates[i].rateKhz && isOptical == SignalRates.rates[i].optical) {
                if (Server.instance().context().isSdhPreferred()) {
                    return SignalRates.rates[i].sdhName;
                }
                return SignalRates.rates[i].sonetName;
            }
            ++i;
        }
        return "Unknown";
    }

    private static class Descriptor {
        public final int rateKhz;
        public final boolean optical;
        public final String sdhName;
        public final String sonetName;

        public Descriptor(int r, boolean o, String sdh, String sonet) {
            this.rateKhz = r;
            this.optical = o;
            this.sdhName = sdh;
            this.sonetName = sonet;
        }
    }
}

