/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.MaskedIntegerValue;
import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalDiscoveryPage;
import com.agilent.tntd.eclipse.thinclient.signalwizard.Signal_Wizard;
import com.agilent.tntd.eclipse.thinclient.signalwizard.StructureScopePage;
import com.agilent.tntd.eclipse.thinclient.signalwizard.TribScan;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.StructureScope;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ApplicationInterfaceUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowHandler;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.ActiveEvent;
import java.beans.Beans;

public class SignalWizardDirector
implements ApplicationInterfaceUI,
MaskedIntegerDataReceiver,
CcConnectedComponent,
UnconsumedKeyHandler {
    private transient Signal_Wizard signalWizardWindow = null;
    private transient SignalDiscoveryPage discoveryPage = null;
    private transient BasicLabel pleaseWaitLabel = null;
    private transient StructureScopePage structureScopePage = null;
    private transient StructureScope viewerManagerManager = null;
    private transient TribScan tribScan = null;
    private transient ModalWindowHandler windowHandler = null;
    private transient UnconsumedKeyHandler currentPage = null;
    private transient Component currentPage2 = null;
    private transient boolean running = false;
    private transient boolean thruModeOn = false;
    private transient ApplicationObject appRunningAO = null;
    private static final String appRunningVariable = "STEST_APPLICATION_RUNNING";
    private transient MaskedIntegerValue lastValue = null;
    private static final String factoryProperty = "signalwizard.factories";

    public SignalWizardDirector() {
        if (!Beans.isDesignTime()) {
            this.buildServerConnection();
        }
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        switch (aReport.getErrorStatus()) {
            case 1: {
                EventLog.instance().log("Could not establish connection to SignalWizard server: " + anAO.toString() + " failed to initialise");
                break;
            }
            case 3: {
                EventLog.instance().log("Could not establish connection to SignalWizard server: " + anAO.toString() + " requested from unknown domain");
                break;
            }
            case 0: 
            case 2: {
                if (!anAO.getName().equals(appRunningVariable)) break;
                this.appRunningAO = anAO;
            }
        }
    }

    public void acknowledgeSuspend(boolean success) {
        if (success) {
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new HackEvent(this));
        } else {
            this.running = true;
            this.viewerManagerManager.popupSetupFailureDialog();
        }
    }

    private void buildServerConnection() {
        Server.instance().initialise("SignalWizard");
        Server.instance().applicationInterface().setUI(this);
    }

    public void close() {
        if (((Component)((Object)this.tribScan)).isShowing()) {
            this.windowHandler.setWindow((InternalWindow)this.tribScan);
            this.windowHandler.removeModalWindow();
        }
        this.windowHandler.setWindow((InternalWindow)this.signalWizardWindow);
        this.windowHandler.removeModalWindow();
    }

    public void doBlockingHack() {
        if (this.appRunningAO != null) {
            this.appRunningAO.change((ApplicationData)this.lastValue);
        }
        this.close();
    }

    public void finishInitialise() {
        this.running = false;
        ApplicationManager.instance().request("ISS", 0, appRunningVariable, (ApplicationObjectObserver)this);
        Server.instance().finishInitialise();
        this.discoveryPage.finishInitialise();
        this.structureScopePage.finishInitialise();
        this.tribScan.finishInitialise();
        this.showSignalDiscoveryPage();
    }

    public void intialiseProtocol() {
        if (this.takeControl()) {
            Server.instance().applicationInterface().start();
        } else {
            this.close();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void notifyPattern(boolean success, short patternType, boolean inverted, short userWord) {
    }

    public void notifyWindowSelection(boolean selected) {
        if (selected && this.currentPage2 != null && this.currentPage2.isShowing()) {
            this.currentPage2.requestFocus();
        }
    }

    public void processUnconsumedKeyEvents(KeyEvent e, Component receiverComponent) {
        if (((Component)((Object)this.tribScan)).isShowing()) {
            this.tribScan.processUnconsumedKeyEvents(e, receiverComponent);
        } else if (this.currentPage != null) {
            this.currentPage.processUnconsumedKeyEvents(e, receiverComponent);
        } else {
            switch (InstrumentKeyMappings.deriveKeyType((KeyEvent)e)) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    break;
                }
                default: {
                    e.consume();
                    break;
                }
            }
        }
    }

    public void receiveMaskedIntegerData(MaskedIntegerValue v, ApplicationDataSender s) {
        if (s == this.appRunningAO) {
            this.lastValue = v;
            this.setAppRunningFlag(v.getValue() != 0);
        }
    }

    public void setAppRunningFlag(boolean isRunning) {
        if (isRunning) {
            this.running = true;
        } else if (this.running) {
            this.suspend();
        }
    }

    public void setDiscoveryPage(SignalDiscoveryPage newDiscoveryPage) {
        this.discoveryPage = newDiscoveryPage;
        this.discoveryPage.setDirector(this);
        Server.instance().signalDiscovery().setUI(this.discoveryPage);
    }

    public void setPleaseWaitLabel(BasicLabel l) {
        this.pleaseWaitLabel = l;
    }

    public void setSignalWizardWindow(Signal_Wizard newSignalWizardWindow) {
        this.signalWizardWindow = newSignalWizardWindow;
        this.windowHandler = new ModalWindowHandler();
        this.windowHandler.setWindow((InternalWindow)this.signalWizardWindow);
    }

    public void setStructureScopePage(StructureScopePage newStructureScopePage) {
        this.structureScopePage = newStructureScopePage;
        this.structureScopePage.setDirector(this);
        Server.instance().traceMessageSearcher().setUI(this.structureScopePage);
    }

    public void setTribScan(TribScan newTribScan) {
        this.tribScan = newTribScan;
        this.tribScan.setDirector(this);
    }

    public void setViewerManagerManager(StructureScope newViewerManagerManager) {
        this.viewerManagerManager = newViewerManagerManager;
        this.viewerManagerManager.setDirector(this);
        Server.instance().structureScope().setUI(this.viewerManagerManager);
        Server.instance().context().setUI(this.viewerManagerManager);
    }

    private void showPage(Component page) {
        if (this.currentPage2 == page) {
            return;
        }
        this.currentPage2 = page;
        if (((Container)((Object)this.signalWizardWindow)).getComponentCount() > 0) {
            if (((Container)((Object)this.signalWizardWindow)).getComponent(0) == page) {
                return;
            }
            ((Container)((Object)this.signalWizardWindow)).removeAll();
        }
        int x = this.signalWizardWindow.getInsets().left;
        int w = ((Component)((Object)this.signalWizardWindow)).getSize().width - (this.signalWizardWindow.getInsets().left + this.signalWizardWindow.getInsets().right);
        int y = this.signalWizardWindow.getInsets().top;
        int h = ((Component)((Object)this.signalWizardWindow)).getSize().height - (this.signalWizardWindow.getInsets().top + this.signalWizardWindow.getInsets().bottom);
        page.setLocation(x + (w - page.getSize().width) / 2, y + (h - page.getSize().height) / 2);
        ((Container)((Object)this.signalWizardWindow)).add(page);
        if (this.windowSelected()) {
            page.requestFocus();
        }
        ((Container)((Object)this.signalWizardWindow)).validate();
        ((Component)((Object)this.signalWizardWindow)).repaint();
        this.currentPage = page instanceof UnconsumedKeyHandler ? (UnconsumedKeyHandler)page : null;
    }

    public void showPleaseWaitLabel() {
        this.showPage((Component)this.pleaseWaitLabel);
    }

    public void showSignalDiscoveryPage() {
        this.showPage((Component)((Object)this.discoveryPage));
    }

    public void showStructureScopePage() {
        this.showPage((Component)((Object)this.structureScopePage));
    }

    public void showTribScan() {
        WindowManager.instance().connectWindow((InternalWindow)this.tribScan);
    }

    public void startDiscovery() {
        this.showSignalDiscoveryPage();
    }

    public void startStructureScope() {
        this.showStructureScopePage();
    }

    public void suspend() {
        if (this.running) {
            this.running = false;
            this.close();
        }
    }

    public void suspendSetupRx() {
        this.running = false;
        Server.instance().applicationInterface().suspendSetupRx();
    }

    public void suspendSetupRxTx() {
        this.running = false;
        Server.instance().applicationInterface().suspendSetupTxRx();
    }

    public void suspendSetupTx() {
        this.running = false;
        Server.instance().applicationInterface().suspendSetupTx();
    }

    public boolean takeControl() {
        return this.appRunningAO.change((ApplicationData)this.lastValue);
    }

    public void trapTransientError(boolean isInError) {
    }

    public void unregister() {
        Server.instance().applicationInterface().suspend();
        Server.instance().context().stopElapsedTime();
        Server.instance().unregister();
        this.discoveryPage.unregister();
        this.structureScopePage.unregister();
        this.tribScan.unregister();
        this.viewerManagerManager.cleanup();
        if (this.appRunningAO != null) {
            this.appRunningAO.unregister((ApplicationObjectObserver)this);
        }
        this.appRunningAO = null;
    }

    public void update(ApplicationData v, ApplicationObject o) {
        if (v != null) {
            try {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
            catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
                EventLog.instance().log("SignalWizardDirector doesn't implement the right interface to receive " + v.toString() + " from " + o.toString());
            }
        }
    }

    public boolean windowSelected() {
        return this.signalWizardWindow.isSelected();
    }

    private class HackEvent
    extends AWTEvent
    implements ActiveEvent {
        /* synthetic */ SignalWizardDirector this$0;

        public HackEvent(SignalWizardDirector this$0) {
            super(this$0, 0);
            this.this$0 = this$0;
        }

        public void dispatch() {
            this.this$0.doBlockingHack();
        }
    }
}

