/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard;

import com.agilent.tntd.eclipse.thinclient.signalwizard.SearchResultsDialog;
import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalWizardDirector;
import com.agilent.tntd.eclipse.thinclient.signalwizard.StructureScopeMenu;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.LayerViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.SdhViewerManager;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.StructureChangeAcknowledgeReceiver;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.StructureScope;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.TraceMessageViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.TraceMessage;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.TraceMessageSearcherUI;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.EclDataEntryModel;
import com.agilent.tntd.eclipse.viewlayer.components.dataentry.NonConnectedDataEntry;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.ActionPerformedEvent;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.ActionPerformedListener;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButton;
import com.agilent.tntd.eclipse.viewlayer.components.togglebutton.EclToggleButtonModel;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindow;
import com.agilent.tntd.eclipse.viewlayer.containers.window.EclWindowModel;
import com.agilent.tntd.eclipse.viewlayer.containers.window.ModalWindowHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class StructureScopePage
extends EclPanePage
implements StructureChangeAcknowledgeReceiver,
TraceMessageViewer,
TraceMessageSearcherUI,
UnconsumedKeyHandler {
    private BasicLabel ivjBasicLabel1 = null;
    private BasicLabel ivjBasicLabel3 = null;
    private BasicLabel ivjElapsedTimeLabel = null;
    private BasicLabel ivjOpticalPowerLabel = null;
    private BasicLabel ivjTraceMessageLabel1 = null;
    private BasicLabel ivjTraceMessageLabel2 = null;
    private SdhViewerManager ivjViewerManager = null;
    private transient SignalWizardDirector director = null;
    private transient boolean running = false;
    private transient boolean inContext = false;
    private transient StructureScopeMenu popupMenu = null;
    private BasicLabel ivjBasicLabel13 = null;
    private EclToggleButton ivjCancelButton = null;
    private NonConnectedDataEntry ivjEclDataEntry1 = null;
    private EclToggleButton ivjOKButton = null;
    private EclWindow ivjTraceMessageSearchDialog = null;
    private ModalWindowHandler ivjModalWindowHandler = null;
    private SearchResultsDialog ivjSearchResultsDialog = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);

    public StructureScopePage() {
        this.initialize();
    }

    public void acknowledge() {
        this.getViewerManager().acknowledgeStructureChange();
        this.requestFocus();
    }

    public void acknowledgeStructureChange() {
        this.getViewerManager().acknowledgeStructureChange();
        this.requestFocus();
    }

    private void activateMenu() {
        this.getViewerManager().setupMenu(this.getPopupMenu());
        this.getPopupMenu().setComponentFocusableOnClose(this.getActiveComponent());
        this.getPopupMenu().showRelativeToComponent((Component)((Object)this), 50, 50);
        this.getPopupMenu().requestFocus();
    }

    public void addViewer(LayerViewer v, LayerViewer parent, int indexInParent) {
        this.getViewerManager().addViewer(v, parent, indexInParent);
        this.getViewerManager().repaint();
    }

    public void cancelButton_ActionPerformed() {
        this.getModalWindowHandler().setWindow((InternalWindow)this.getTraceMessageSearchDialog());
        this.getModalWindowHandler().removeModalWindow();
        this.requestFocus();
    }

    public void closeButton_ActionPerformed() {
        this.getModalWindowHandler().setWindow((InternalWindow)this.getSearchResultsDialog());
        this.getModalWindowHandler().removeModalWindow();
        this.requestFocus();
    }

    public void collapse() {
        this.getViewerManager().collapse();
        this.requestFocus();
    }

    private void connEtoC1() {
        try {
            this.oKButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2() {
        try {
            this.cancelButton_ActionPerformed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(KeyEvent arg1) {
        try {
            this.eclDataEntry1_KeyTyped();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.getViewerManager().setTraceMessageViewer(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.getSearchResultsDialog().setStructureScopePage(this);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void displayTraceMessage(String m) {
        FontMetrics fm = ((Component)((Object)this)).getFontMetrics(this.getTraceMessageLabel1().getFont());
        int len = m.length();
        int width = fm.stringWidth(m);
        if (width > this.getTraceMessageLabel1().getSize().width) {
            String top = m.substring(0, len / 2);
            String bottom = m.substring(len / 2);
            this.getTraceMessageLabel1().setText(top);
            this.getTraceMessageLabel2().setText(bottom);
        } else {
            this.getTraceMessageLabel1().setText("");
            this.getTraceMessageLabel2().setText(m);
        }
    }

    public void eclDataEntry1_KeyTyped() {
        String s = this.getEclDataEntry1().getText();
        if (s == null && s.length() == 0) {
            this.getOKButton().setEnabled(false);
        } else {
            this.getOKButton().setEnabled(true);
        }
        this.getOKButton().repaint();
    }

    public void exit() {
        this.director.suspend();
    }

    public void expand() {
        this.getViewerManager().expand();
        this.requestFocus();
    }

    public void finishInitialise() {
        this.getSearchResultsDialog().finishInitialise();
        this.getViewerManager().finishInitialise();
        this.eclDataEntry1_KeyTyped();
    }

    public Component getActiveComponent() {
        if (((Component)((Object)this.getPopupMenu())).isShowing()) {
            return this.getPopupMenu();
        }
        if (this.getTraceMessageSearchDialog().isShowing()) {
            return this.getTraceMessageSearchDialog();
        }
        if (((Component)((Object)this.getSearchResultsDialog())).isShowing()) {
            return this.getSearchResultsDialog();
        }
        return this.getViewerManager();
    }

    private BasicLabel getBasicLabel1() {
        if (this.ivjBasicLabel1 == null) {
            try {
                this.ivjBasicLabel1 = new BasicLabel();
                this.ivjBasicLabel1.setName("BasicLabel1");
                this.ivjBasicLabel1.setText("Optical Power");
                this.ivjBasicLabel1.setBounds(5, 373, 87, 18);
                this.ivjBasicLabel1.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBasicLabel1;
    }

    private BasicLabel getBasicLabel13() {
        if (this.ivjBasicLabel13 == null) {
            try {
                this.ivjBasicLabel13 = new BasicLabel();
                this.ivjBasicLabel13.setName("BasicLabel13");
                this.ivjBasicLabel13.setText("Search text");
                this.ivjBasicLabel13.setBounds(36, 43, 89, 20);
                this.ivjBasicLabel13.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBasicLabel13;
    }

    private BasicLabel getBasicLabel3() {
        if (this.ivjBasicLabel3 == null) {
            try {
                this.ivjBasicLabel3 = new BasicLabel();
                this.ivjBasicLabel3.setName("BasicLabel3");
                this.ivjBasicLabel3.setText("Elapsed Time");
                this.ivjBasicLabel3.setBounds(511, 373, 108, 18);
                this.ivjBasicLabel3.setHorizontalAlignment(2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBasicLabel3;
    }

    private static void getBuilderData() {
    }

    private EclToggleButton getCancelButton() {
        if (this.ivjCancelButton == null) {
            try {
                this.ivjCancelButton = new EclToggleButton();
                this.ivjCancelButton.setName("CancelButton");
                this.ivjCancelButton.setBounds(152, 102, 70, 22);
                this.ivjCancelButton.setEclModel(new EclToggleButtonModel("Cancel", null, null, true, ""));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCancelButton;
    }

    public SignalWizardDirector getDirector() {
        return this.director;
    }

    private NonConnectedDataEntry getEclDataEntry1() {
        if (this.ivjEclDataEntry1 == null) {
            try {
                this.ivjEclDataEntry1 = new NonConnectedDataEntry();
                this.ivjEclDataEntry1.setName("EclDataEntry1");
                this.ivjEclDataEntry1.setBounds(35, 63, 194, 20);
                this.ivjEclDataEntry1.setEclModel(new EclDataEntryModel(3, false, null, null, 20, true, "", -1, null, null));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjEclDataEntry1;
    }

    private BasicLabel getElapsedTimeLabel() {
        if (this.ivjElapsedTimeLabel == null) {
            try {
                this.ivjElapsedTimeLabel = new BasicLabel();
                this.ivjElapsedTimeLabel.setName("ElapsedTimeLabel");
                this.ivjElapsedTimeLabel.setText("0d 12h 57m 30s");
                this.ivjElapsedTimeLabel.setVerticalAlignment(1);
                this.ivjElapsedTimeLabel.setBounds(512, 389, 108, 18);
                this.ivjElapsedTimeLabel.setHorizontalAlignment(2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjElapsedTimeLabel;
    }

    private ModalWindowHandler getModalWindowHandler() {
        if (this.ivjModalWindowHandler == null) {
            try {
                this.ivjModalWindowHandler = new ModalWindowHandler();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjModalWindowHandler;
    }

    private EclToggleButton getOKButton() {
        if (this.ivjOKButton == null) {
            try {
                this.ivjOKButton = new EclToggleButton();
                this.ivjOKButton.setName("OKButton");
                this.ivjOKButton.setBounds(41, 102, 70, 22);
                this.ivjOKButton.setEnabled(false);
                this.ivjOKButton.setEclModel(new EclToggleButtonModel("OK", null, null, true, ""));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOKButton;
    }

    private BasicLabel getOpticalPowerLabel() {
        if (this.ivjOpticalPowerLabel == null) {
            try {
                this.ivjOpticalPowerLabel = new BasicLabel();
                this.ivjOpticalPowerLabel.setName("OpticalPowerLabel");
                this.ivjOpticalPowerLabel.setText("-27.3 dBm");
                this.ivjOpticalPowerLabel.setVerticalAlignment(1);
                this.ivjOpticalPowerLabel.setBounds(5, 389, 75, 18);
                this.ivjOpticalPowerLabel.setHorizontalAlignment(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOpticalPowerLabel;
    }

    public StructureScopeMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new StructureScopeMenu(this);
        }
        return this.popupMenu;
    }

    private SearchResultsDialog getSearchResultsDialog() {
        if (this.ivjSearchResultsDialog == null) {
            try {
                this.ivjSearchResultsDialog = new SearchResultsDialog();
                ((Component)((Object)this.ivjSearchResultsDialog)).setName("SearchResultsDialog");
                ((Component)((Object)this.ivjSearchResultsDialog)).setLocation(724, 67);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSearchResultsDialog;
    }

    private BasicLabel getTraceMessageLabel1() {
        if (this.ivjTraceMessageLabel1 == null) {
            try {
                this.ivjTraceMessageLabel1 = new BasicLabel();
                this.ivjTraceMessageLabel1.setName("TraceMessageLabel1");
                this.ivjTraceMessageLabel1.setText("Trace message line 1");
                this.ivjTraceMessageLabel1.setBounds(97, 373, 420, 18);
                this.ivjTraceMessageLabel1.setHorizontalAlignment(1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTraceMessageLabel1;
    }

    private BasicLabel getTraceMessageLabel2() {
        if (this.ivjTraceMessageLabel2 == null) {
            try {
                this.ivjTraceMessageLabel2 = new BasicLabel();
                this.ivjTraceMessageLabel2.setName("TraceMessageLabel2");
                this.ivjTraceMessageLabel2.setText("Trace message line 2");
                this.ivjTraceMessageLabel2.setBounds(97, 389, 420, 18);
                this.ivjTraceMessageLabel2.setHorizontalAlignment(1);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTraceMessageLabel2;
    }

    private EclWindow getTraceMessageSearchDialog() {
        if (this.ivjTraceMessageSearchDialog == null) {
            try {
                this.ivjTraceMessageSearchDialog = new EclWindow();
                this.ivjTraceMessageSearchDialog.setName("TraceMessageSearchDialog");
                this.ivjTraceMessageSearchDialog.setBounds(694, 496, 264, 140);
                this.ivjTraceMessageSearchDialog.setEclModel(new EclWindowModel(0, 3, 2, null, "Trace Message Search"));
                this.getTraceMessageSearchDialog().add((Component)this.getOKButton(), this.getOKButton().getName());
                this.getTraceMessageSearchDialog().add((Component)this.getCancelButton(), this.getCancelButton().getName());
                this.getTraceMessageSearchDialog().add((Component)this.getEclDataEntry1(), this.getEclDataEntry1().getName());
                this.getTraceMessageSearchDialog().add((Component)this.getBasicLabel13(), this.getBasicLabel13().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTraceMessageSearchDialog;
    }

    private SdhViewerManager getViewerManager() {
        if (this.ivjViewerManager == null) {
            try {
                this.ivjViewerManager = new SdhViewerManager();
                this.ivjViewerManager.setName("ViewerManager");
                this.ivjViewerManager.setBounds(5, 5, 614, 369);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjViewerManager;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() throws Exception {
        this.getOKButton().addActionPerformedListener((ActionPerformedListener)this.ivjEventHandler);
        this.getCancelButton().addActionPerformedListener((ActionPerformedListener)this.ivjEventHandler);
        this.getEclDataEntry1().addKeyListener(this.ivjEventHandler);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
    }

    private void initialize() {
        try {
            ((Component)((Object)this)).setName("StructureScopePage");
            ((Component)((Object)this)).setSize(624, 408);
            ((Container)((Object)this)).add(this.getViewerManager(), this.getViewerManager().getName());
            ((Container)((Object)this)).add((Component)this.getBasicLabel1(), this.getBasicLabel1().getName());
            ((Container)((Object)this)).add((Component)this.getOpticalPowerLabel(), this.getOpticalPowerLabel().getName());
            ((Container)((Object)this)).add((Component)this.getTraceMessageLabel1(), this.getTraceMessageLabel1().getName());
            ((Container)((Object)this)).add((Component)this.getTraceMessageLabel2(), this.getTraceMessageLabel2().getName());
            ((Container)((Object)this)).add((Component)this.getBasicLabel3(), this.getBasicLabel3().getName());
            ((Container)((Object)this)).add((Component)this.getElapsedTimeLabel(), this.getElapsedTimeLabel().getName());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void initiateSearch(String s) {
        if (this.getTraceMessageSearchDialog().isShowing()) {
            this.getModalWindowHandler().setWindow((InternalWindow)this.getTraceMessageSearchDialog());
            this.getModalWindowHandler().removeModalWindow();
        }
        Server.instance().traceMessageSearcher().setSearchCriterion(s);
        Server.instance().traceMessageSearcher().setPageSize(10);
        LayerViewer v = this.getViewerManager().getActiveViewer();
        if (v != null) {
            this.getSearchResultsDialog().clear();
            ((Container)((Object)this.getSearchResultsDialog())).validate();
            Server.instance().traceMessageSearcher().startSearch(v.getAnalyserId(), 0);
            WindowManager.instance().connectWindow((InternalWindow)this.getSearchResultsDialog());
        }
    }

    private void invokeSearchDialog() {
        WindowManager.instance().connectWindow((InternalWindow)this.getTraceMessageSearchDialog());
    }

    public void listAll() {
    }

    public void listCurrent() {
        this.getSearchResultsDialog().allowMultiplePages(true);
        this.initiateSearch("");
    }

    public void listLevel() {
        this.listAll();
    }

    public static void main(String[] args) {
        try {
            Frame frame = new Frame();
            StructureScopePage aStructureScopePage = new StructureScopePage();
            frame.add("Center", (Component)((Object)aStructureScopePage));
            ((Component)frame).setSize(((Component)((Object)aStructureScopePage)).getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            ((Component)frame).setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage");
            exception.printStackTrace(System.out);
        }
    }

    public void nextError() {
        this.getPopupMenu().setVisible(false);
        this.getViewerManager().selectNextError();
        this.requestFocus();
    }

    public void notifySearchComplete() {
        this.getSearchResultsDialog().notifySearchComplete();
    }

    public void oKButton_ActionPerformed() {
        String searchString = this.getEclDataEntry1().getText();
        this.initiateSearch(searchString);
    }

    private void popupShowMoreNotAvailableDialog() {
        EclDialog d = new EclDialog();
        d.setSize(250, 100);
        d.displayMessageWindow(false, true, false, "Show More is not available while SignalWizard is running", "", new DialogEventReceiver(){

            public void notifyEvent(int id, EclDialog d) {
                d.removeFromWorkspace();
            }
        }, new Font("dialog", 0, 12));
    }

    public void previousError() {
        this.getPopupMenu().setVisible(false);
        this.getViewerManager().selectPreviousError();
        this.requestFocus();
    }

    public void processUnconsumedKeyEvents(KeyEvent e, Component receiverComponent) {
        if (e.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType((KeyEvent)e)) {
                case 107: {
                    this.activateMenu();
                    e.consume();
                    break;
                }
                case 119: {
                    if (!((Component)((Object)this.getPopupMenu())).isShowing()) break;
                    e.consume();
                    break;
                }
                case 27: {
                    this.collapse();
                    e.consume();
                    break;
                }
                case 121: {
                    Server.instance().structureScope().resetHistory();
                    break;
                }
                case 120: {
                    this.popupShowMoreNotAvailableDialog();
                    e.consume();
                    break;
                }
            }
        }
    }

    public void removeAllDialogs() {
        if (this.getTraceMessageSearchDialog().isShowing()) {
            this.getModalWindowHandler().setWindow((InternalWindow)this.getTraceMessageSearchDialog());
            this.getModalWindowHandler().removeModalWindow();
        }
        if (((Component)((Object)this.getSearchResultsDialog())).isShowing()) {
            this.getModalWindowHandler().setWindow((InternalWindow)this.getSearchResultsDialog());
            this.getModalWindowHandler().removeModalWindow();
        }
    }

    public void removeDialog(Component dialog) {
        ((Container)((Object)this)).remove(dialog);
        this.requestFocus();
    }

    public void removeNotify() {
        this.getViewerManager().removeAllViewers();
        this.getTraceMessageLabel1().setText("");
        this.getTraceMessageLabel2().setText("");
        this.getOpticalPowerLabel().setText("");
        this.getElapsedTimeLabel().setText("");
        super.removeNotify();
    }

    public void requestFocus() {
        if (this.director.windowSelected()) {
            this.getActiveComponent().requestFocus();
        }
    }

    public void requestPage(int p) {
        LayerViewer v = this.getViewerManager().getActiveViewer();
        if (v != null) {
            Server.instance().traceMessageSearcher().startSearch(v.getAnalyserId(), p);
        }
    }

    public void searchAll() {
    }

    public void searchCurrent() {
        this.getSearchResultsDialog().allowMultiplePages(false);
        this.invokeSearchDialog();
    }

    public void selectChannel(LayerViewer v, int channel) {
        if (((Component)((Object)this.getSearchResultsDialog())).isShowing()) {
            this.getModalWindowHandler().setWindow((InternalWindow)this.getSearchResultsDialog());
            this.getModalWindowHandler().removeModalWindow();
        }
        this.getViewerManager().selectChannel(v, channel);
        this.requestFocus();
    }

    public void setDirector(SignalWizardDirector d) {
        this.director = d;
        this.getViewerManager().setDirector(d);
    }

    public void setElapsedTime(String e) {
        this.getElapsedTimeLabel().setText(e);
        this.getElapsedTimeLabel().repaint();
    }

    public void setManager(StructureScope m) {
        this.getViewerManager().setManager(m);
    }

    public void setOpticalPower(String p) {
        this.getOpticalPowerLabel().setText(p);
        this.getOpticalPowerLabel().repaint();
    }

    public void setTraceMessagePage(int pageNum, TraceMessage[] info, boolean moreToFollow) {
        int i = 0;
        while (i < info.length) {
            info[i].viewer = this.getViewerManager().getActiveViewer();
            ++i;
        }
        this.getSearchResultsDialog().showTraceMessagePage(pageNum, info, moreToFollow);
    }

    public void setupRx() {
        this.director.suspendSetupRx();
        this.requestFocus();
    }

    public void setupRxTx() {
        this.director.suspendSetupRxTx();
        this.requestFocus();
    }

    public void setupTx() {
        this.director.suspendSetupTx();
        this.requestFocus();
    }

    public void showCursor(boolean cursorVisible) {
    }

    public void showElapsedTime(boolean b) {
        this.getBasicLabel3().setVisible(b);
        this.getElapsedTimeLabel().setVisible(b);
    }

    public void showOpticalPower(boolean b) {
        this.getOpticalPowerLabel().setVisible(b);
        this.getBasicLabel1().setVisible(b);
    }

    public void start() {
        this.showOpticalPower(Server.instance().context().isOpticalInterface());
        this.getViewerManager().removeAllViewers();
        this.getElapsedTimeLabel().setText("");
        this.getOpticalPowerLabel().setText("");
        this.getTraceMessageLabel1().setText("");
        this.getTraceMessageLabel2().setText("");
    }

    public void suppressStructureChanges(boolean s) {
        this.getViewerManager().suppressStructureChanges(s);
    }

    public void unregister() {
        this.getViewerManager().unregister();
    }

    public void unzip() {
        this.expand();
    }

    public void zipUp() {
        this.getViewerManager().zipUp();
    }

    static EclToggleButton access$getOKButton(StructureScopePage structureScopePage) {
        return structureScopePage.getOKButton();
    }

    static void access$connEtoC2(StructureScopePage structureScopePage) {
        structureScopePage.connEtoC2();
    }

    static EclToggleButton access$getCancelButton(StructureScopePage structureScopePage) {
        return structureScopePage.getCancelButton();
    }

    static void access$connEtoC1(StructureScopePage structureScopePage) {
        structureScopePage.connEtoC1();
    }

    static NonConnectedDataEntry access$getEclDataEntry1(StructureScopePage structureScopePage) {
        return structureScopePage.getEclDataEntry1();
    }

    static void access$connEtoC3(StructureScopePage structureScopePage, KeyEvent keyEvent) {
        structureScopePage.connEtoC3(keyEvent);
    }

    class IvjEventHandler
    implements ActionPerformedListener,
    KeyListener {
        /* synthetic */ StructureScopePage this$0;

        public void actionPerformed(ActionPerformedEvent event) {
            if (event.getSource() == StructureScopePage.access$getOKButton(this.this$0)) {
                StructureScopePage.access$connEtoC1(this.this$0);
            }
            if (event.getSource() == StructureScopePage.access$getCancelButton(this.this$0)) {
                StructureScopePage.access$connEtoC2(this.this$0);
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            if (e.getSource() == StructureScopePage.access$getEclDataEntry1(this.this$0)) {
                StructureScopePage.access$connEtoC3(this.this$0, e);
            }
        }

        IvjEventHandler(StructureScopePage this$0) {
            this.this$0 = this$0;
        }
    }
}

