/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.AnalyserListener;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.DecoderFactory;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.TransitionalDeocderFactory;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;

public class DefaultLayer
implements AnalyserUI {
    protected AnalyserProxy analyser = null;
    protected AnalyserListener listener = null;
    protected LayerDecoder decoder = null;
    protected ChannelStatus[] structure = null;
    protected int totalSize = 0;
    protected boolean valid = true;
    protected int selectedIndex = -1;
    protected String traceMessage = "";
    protected byte currentLabel = 0;
    protected byte[] currentErrors = null;
    private static DecoderFactory decoderFactory = new TransitionalDeocderFactory();

    public DefaultLayer(AnalyserProxy a) {
        this.analyser = a;
    }

    public synchronized void acknowledgeStructureChange() {
        if (this.structure != null) {
            int i = 0;
            while (i < this.structure.length) {
                this.structure[i].substructure = false;
                ++i;
            }
        }
        this.valid = true;
        this.analyser.acknowledgeStructureChange();
    }

    public boolean containsPdh() {
        return this.decoder.containsPdh();
    }

    public String decode(byte value, ChannelStatus c) {
        return this.decoder.decode(value, c);
    }

    public void detachFromParent() {
        this.analyser.detatchFromParent();
    }

    public int getAnalyserId() {
        if (this.analyser == null) {
            return 0;
        }
        return this.analyser.getId();
    }

    public String getChannelCaption(int index) {
        return this.decoder.getChannelCaption(this.structure[index]);
    }

    public String getChannelIndex(ChannelStatus c) {
        return this.decoder.getChannelIndex(c, this.totalSize);
    }

    public ChannelStatus getChannelStatus(int index) {
        return this.structure[index];
    }

    public boolean getChannelSubstructure(int index) {
        if (this.structure != null && index > -1) {
            return this.structure[index].substructure;
        }
        return false;
    }

    public byte[] getCurrentErrors() {
        return this.currentErrors;
    }

    public byte getCurrentLabel() {
        return this.currentLabel;
    }

    public int getDepth() {
        AnalyserProxy p = this.analyser.getParent();
        int i = 0;
        while (p != null) {
            ++i;
            p = p.getParent();
        }
        return i;
    }

    public String[] getErrorTableCaptions() {
        return this.decoder.getErrorTableCaptions();
    }

    public int[][] getErrorTableConstraints() {
        return this.decoder.getErrorTableConstraints();
    }

    public int getIndexInParent() {
        return this.analyser.getIndexInParent();
    }

    public int getMaxNumTiles() {
        return this.decoder.getMaxNumTiles();
    }

    public int getNumTiles() {
        if (this.structure != null) {
            return this.structure.length;
        }
        return 0;
    }

    public DefaultLayer getParent() {
        AnalyserProxy a = this.analyser.getParent();
        if (a != null && a.getUI() instanceof DefaultLayer) {
            return (DefaultLayer)a.getUI();
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getShortChannelCaption(int index) {
        return this.decoder.getShortChannelCaption(this.structure[index]);
    }

    public ChannelStatus[] getStructure() {
        return this.structure;
    }

    public int getStructureLength() {
        return this.structure.length;
    }

    public String getStructureSummary() {
        return this.decoder.getStructureSummary(this.structure);
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public String getTraceMessage() {
        return this.traceMessage;
    }

    public boolean hasParent() {
        return this.analyser.getParent() != null;
    }

    public boolean isError(int index) {
        byte s = this.structure[index].status;
        return s == 1 || s == 2 || s == 3;
    }

    public boolean isPdh() {
        return this.decoder.isPdh();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void requestChild(short index) {
        this.analyser.requestChildAnalyser(index);
    }

    public void requestChildAnalyser(short channel) {
        this.analyser.requestChildAnalyser(channel);
    }

    public void setCurrentTile(short index) {
        this.analyser.setCurrentTile(index);
    }

    public void setCurrentTileSummary(String s) {
        this.decoder.setPayloadSummary(s);
    }

    public void setCurrentTileTraceMessage(String m) {
        this.traceMessage = m;
        if (this.listener != null) {
            this.listener.notifyMessageChange(this);
        }
    }

    public void setErrorState(byte label, byte[] errors) {
        this.currentLabel = label;
        this.currentErrors = errors;
        if (this.listener != null) {
            this.listener.notifyErrorChange(this);
        }
    }

    public void setListener(AnalyserListener l) {
        this.listener = l;
    }

    public void setSelectedIndex(short index) {
        if (this.selectedIndex == index || index < 0 || index >= this.structure.length) {
            return;
        }
        this.selectedIndex = index;
        this.analyser.setCurrentTile(index);
        if (this.listener != null) {
            this.listener.notifySelectionChange(this);
        }
    }

    public void setStatus(ChannelStatus[] s) {
        if (this.structure == null) {
            return;
        }
        int i = 0;
        while (i < s.length) {
            if (s[i].status != this.structure[i].status || s[i].substructure != this.structure[i].substructure || s[i].foreign != this.structure[i].foreign) {
                this.structure[i].status = s[i].status;
                this.structure[i].substructure = s[i].substructure;
                this.structure[i].foreign = s[i].foreign;
            }
            ++i;
        }
    }

    public void setStructure(ChannelStatus[] s) {
        this.structure = s;
        this.selectedIndex = 0;
        this.totalSize = 0;
        int i = 0;
        while (i < this.structure.length) {
            short size = this.structure[i].size;
            this.totalSize += size;
            ++i;
        }
        if (this.listener != null) {
            this.listener.notifyStructureComplete(this);
        }
    }

    public void setType(String typename) {
        this.decoder = decoderFactory.createDecoder(typename);
    }

    public void smallChange(short index, byte status, boolean hasSubstructure, boolean foreign) {
        if (this.structure == null || index >= this.structure.length) {
            return;
        }
        this.structure[index].status = status;
        this.structure[index].substructure = hasSubstructure;
        this.structure[index].foreign = foreign;
    }

    public void specialOperation(PrimitiveTypesReader r) {
    }

    public void structureChange() {
        this.valid = false;
        if (this.listener != null) {
            this.listener.notifyStructureChange(this);
        }
    }

    public void unregister() {
        this.analyser.unregister();
    }
}

