/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.DecoderFactory;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.DecoderFactoryGroup;
import java.util.StringTokenizer;

public class PluggableDecoderFactory
extends DecoderFactoryGroup {
    public PluggableDecoderFactory(String propertyName) {
        this.initialise(propertyName);
    }

    private final void initialise(String propertyName) {
        String names = System.getProperty(propertyName);
        if (names == null) {
            EventLog.instance().log("\"" + propertyName + "\" property is not defined");
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(names, " ,;:\t");
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken();
            try {
                Class<?> factoryClass = Class.forName(classname);
                this.addFactory((DecoderFactory)factoryClass.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                EventLog.instance().log("\"" + classname + "\" could not be found");
            }
            catch (InstantiationException instantiationException) {
                EventLog.instance().log("\"" + classname + "\" cannot be instantiated");
            }
            catch (IllegalAccessException illegalAccessException) {
                EventLog.instance().log("\"" + classname + "\" is not accessible");
            }
            catch (ClassCastException classCastException) {
                EventLog.instance().log("\"" + classname + "\" is not a valid factory");
            }
            catch (Exception e) {
                EventLog.instance().log("Exception during construction of \"" + classname + "\": " + e);
            }
        }
        if (this.getFactoryCount() == 0) {
            EventLog.instance().log("\"" + propertyName + "\" property names no valid factories");
        }
    }
}

