/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.DefaultLayer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.LayerViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.LayerViewerClient;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;

public class ViewableLayer
extends DefaultLayer
implements LayerViewerClient {
    private LayerViewer viewer = null;

    public ViewableLayer(AnalyserProxy a) {
        super(a);
    }

    public String decodeChannelLabel(byte label, int index) {
        return this.decode(label, this.structure[index]);
    }

    public String getChannelIdentifier(int index) {
        ChannelStatus s = this.structure[index];
        return this.decoder.getChannelIdentifier(s, this.totalSize);
    }

    public LayerViewer getParentViewer() {
        AnalyserProxy a;
        if (this.analyser != null && (a = this.analyser.getParent()) != null) {
            ViewableLayer l = (ViewableLayer)a.getUI();
            return l.getViewer();
        }
        return null;
    }

    public LayerViewer getViewer() {
        return this.viewer;
    }

    public void setCurrentTileSummary(String s) {
        super.setCurrentTileSummary(s);
        this.viewer.notifySelectionChanged();
    }

    public void setCurrentTileTraceMessage(String m) {
        super.setCurrentTileTraceMessage(m);
        this.viewer.setCurrentTileTraceMessage(m);
    }

    public void setErrorState(byte label, byte[] errors) {
        String byteDecode = null;
        super.setErrorState(label, errors);
        if (this.selectedIndex > -1) {
            byteDecode = this.decode(label, this.structure[this.selectedIndex]);
        }
        if (byteDecode == null) {
            byteDecode = "Undefined (0x" + Integer.toHexString(label).toUpperCase() + ")";
        }
        this.viewer.setErrorState(byteDecode, errors);
    }

    public void setStatus(ChannelStatus[] s) {
        super.setStatus(s);
        this.viewer.setStatus(s);
    }

    public void setStructure(ChannelStatus[] s) {
        super.setStructure(s);
        this.viewer.setStructure(s);
    }

    public void setType(String typename) {
        super.setType(typename);
        this.viewer = new LayerViewer(this);
    }

    public void smallChange(short index, byte status, boolean hasSubstructure, boolean foreign) {
        if (this.structure == null || index >= this.structure.length) {
            return;
        }
        super.smallChange(index, status, hasSubstructure, foreign);
        this.viewer.updateChannelState(index, this.structure[index]);
    }
}

