/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;

public class ArrowButton
extends Component {
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private transient int direction = 0;
    static final long serialVersionUID = 2001901431631611755L;

    public ArrowButton() {
        this(0);
    }

    public ArrowButton(int d) {
        this.setSize(12, 15);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setDirection(d);
    }

    public int getDirection() {
        return this.direction;
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.isEnabled() ? this.getBackground() : Color.lightGray);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(this.isEnabled() ? this.getForeground() : Color.gray);
        g.drawRect(0, 0, d.width - 1, d.height - 1);
        if (this.direction == 0) {
            int h = 9;
            int i = 0;
            while (i < 5) {
                g.drawLine(7 - i, 3 + i, 7 - i, 2 + i + h);
                h -= 2;
                ++i;
            }
        } else {
            int h = 9;
            int i = 0;
            while (i < 5) {
                g.drawLine(4 + i, 3 + i, 4 + i, 2 + i + h);
                h -= 2;
                ++i;
            }
        }
    }

    public void setDirection(int d) {
        this.direction = d;
        this.repaint();
    }
}

