/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalWizardDefaults;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ColourDefaults;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;

public class ErrorTable
extends Container {
    private int[][] constraints = null;
    private int cellWidth = 0;
    private static final Color[][] stateColours = new Color[][]{ColourDefaults.OK, ColourDefaults.ERROR, ColourDefaults.WARNING, ColourDefaults.UNKNOWN, ColourDefaults.TRANSIENT};

    public ErrorTable() {
        this.setSize(117, 33);
    }

    public Dimension getPreferredSize() {
        return new Dimension(117, 15 * this.constraints.length + 3);
    }

    public void initialise(String[] captions, int[][] c) {
        int i = 0;
        while (i < captions.length) {
            BasicLabel cell = new BasicLabel(captions[i]);
            cell.setFont(SignalWizardDefaults.errorTableFont);
            cell.setBackground(Color.lightGray);
            this.add((Component)cell);
            ++i;
        }
        this.constraints = c;
        this.layoutCells();
        this.setSize(this.getPreferredSize());
    }

    protected void layoutCells() {
        int numRows = this.constraints.length;
        int numCols = 0;
        int componentIndex = 0;
        int y = 0;
        while (y < numRows) {
            int[] row = this.constraints[y];
            int rowLength = 0;
            int x = 0;
            while (x < row.length) {
                rowLength += row[x];
                ++x;
            }
            if (rowLength > numCols) {
                numCols = rowLength;
            }
            ++y;
        }
        int pixelY = 2;
        int pixelH = (this.getSize().height - 5) / 2;
        this.cellWidth = (this.getSize().width - 4) / numCols;
        int y2 = 0;
        while (y2 < numRows) {
            int[] row = this.constraints[y2];
            int gridx = 0;
            int pixelX = 2;
            int x = 0;
            while (x < row.length) {
                Component c = this.getComponent(componentIndex);
                int pixelW = this.cellWidth * this.constraints[y2][x] + this.constraints[y2][x] - 1;
                c.setBounds(pixelX, pixelY, pixelW, pixelH);
                gridx += this.constraints[y2][x];
                pixelX += pixelW + 1;
                ++componentIndex;
                ++x;
            }
            pixelY += pixelH + 1;
            ++y2;
        }
    }

    public void paint(Graphics g) {
        g.setColor(Color.gray);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        super.paint(g);
        this.paintBorder(g);
    }

    public void paintBorder(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(Color.gray);
        g.drawLine(0, 0, w - 2, 0);
        g.drawLine(0, 0, 0, h - 2);
        g.drawLine(w - 2, 1, w - 2, h - 2);
        g.drawLine(1, h - 2, w - 2, h - 2);
        g.setColor(Color.white);
        g.drawLine(1, 1, w - 2, 1);
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
    }

    public void setState(String byteDecode, byte[] errorsAndAlarms) {
        ((BasicLabel)this.getComponent(0)).setText(byteDecode);
        if (errorsAndAlarms.length != this.getComponentCount() - 1) {
            EventLog.instance().log("Incorrect number of errors/alarms specified (" + errorsAndAlarms.length + ", expected " + (this.getComponentCount() - 1) + ")");
            return;
        }
        int i = 0;
        while (i < errorsAndAlarms.length) {
            byte state = errorsAndAlarms[i];
            this.getComponent(i + 1).setBackground(stateColours[state][0]);
            this.getComponent(i + 1).setForeground(stateColours[state][1]);
            ++i;
        }
        this.repaint();
    }
}

