/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalWizardDefaults;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.AnalyserListener;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ColourDefaults;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ErrorTable;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.LayerViewerClient;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.SigwizTile;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.Tiler;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ViewerManager;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.InstrumentKeyMappings;
import com.agilent.tntd.eclipse.viewlayer.architecture.event.UnconsumedKeyHandler;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.Tile;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class LayerViewer {
    private ViewerManager manager = null;
    private LayerViewerClient layer = null;
    private int[] colSpan = null;
    private BasicLabel label = null;
    private Tiler tiler = null;
    private ErrorTable errorTable = null;
    private boolean active = false;
    protected int firstError = -1;
    protected int lastError = -1;
    private short numColumns = (short)16;
    private int columnWidth = 23;
    private int columnGap = 1;
    private int rowGap = 4;
    private transient TileEventHandler eventHandler = new TileEventHandler(this);
    private transient UnconsumedKeyHandler keyHandler = null;
    private transient AnalyserListener listener = new AnalyserListener(this){
        /* synthetic */ LayerViewer this$0;

        public void notifyErrorChange(AnalyserUI a) {
            if (LayerViewer.access$manager(this.this$0) != null) {
                LayerViewer.access$manager(this.this$0).notifyErrorChange(this.this$0);
            }
        }

        public void notifyMessageChange(AnalyserUI a) {
            if (LayerViewer.access$manager(this.this$0) != null) {
                LayerViewer.access$manager(this.this$0).notifyMessageChange(this.this$0);
            }
        }

        public void notifySelectionChange(AnalyserUI a) {
            if (LayerViewer.access$manager(this.this$0) != null) {
                LayerViewer.access$manager(this.this$0).notifySelectionChange(this.this$0);
            }
        }

        public void notifyStructureChange(AnalyserUI a) {
            if (LayerViewer.access$manager(this.this$0) != null) {
                LayerViewer.access$manager(this.this$0).structureChange(this.this$0);
            }
        }

        public void notifyStructureComplete(AnalyserUI a) {
            if (LayerViewer.access$manager(this.this$0) != null) {
                LayerViewer.access$manager(this.this$0).notifyStructureComplete(this.this$0);
            }
        }
        {
            this.this$0 = this$0;
        }
    };
    private static final Color[][] tileStateColours = new Color[][]{ColourDefaults.OK, ColourDefaults.ERROR, ColourDefaults.WARNING, ColourDefaults.ERROR, ColourDefaults.ILLEGAL, ColourDefaults.UNEQUIPPED, ColourDefaults.TRANSIENT};
    private static final int largeTileHeight = 24;
    private static final int smallTileHeight = 19;

    public LayerViewer(LayerViewerClient l) {
        this.layer = l;
        this.label = this.createLabel();
        this.tiler = this.createTiler();
        this.errorTable = this.createErrorTable();
        this.layer.setListener(this.listener);
    }

    public void acknowledgeStructureChange() {
        this.layer.acknowledgeStructureChange();
    }

    private void allocateTileWidths(ChannelStatus[] s) {
        int largestSize = 0;
        int smallestSize = Integer.MAX_VALUE;
        int[] span = new int[s.length];
        int i = 0;
        while (i < s.length) {
            short size = s[i].size;
            largestSize = Math.max(largestSize, size);
            smallestSize = Math.min(smallestSize, size);
            ++i;
        }
        int totalColspans = 0;
        int i2 = 0;
        while (i2 < s.length) {
            short colspan = this.numColumns;
            while (colspan > 1) {
                if (s[i2].size / smallestSize >= colspan) break;
                colspan = (short)(colspan / 2);
            }
            span[i2] = colspan;
            totalColspans += colspan;
            ++i2;
        }
        while (totalColspans > 0 && totalColspans <= this.numColumns / 2) {
            i2 = 0;
            while (i2 < s.length) {
                int n = i2++;
                span[n] = span[n] * 2;
            }
            totalColspans *= 2;
        }
        this.colSpan = span;
    }

    public boolean canExpand() {
        int selected = this.tiler.getSelectedIndex();
        return this.getChannelSubstructure(selected);
    }

    private void collapse() {
        this.manager.collapse();
    }

    protected void compress() {
        this.tiler.compress();
        this.notifySelectionChanged();
    }

    public boolean containsPdh() {
        return this.layer.containsPdh();
    }

    protected ErrorTable createErrorTable() {
        ErrorTable e = new ErrorTable();
        e.initialise(this.layer.getErrorTableCaptions(), this.layer.getErrorTableConstraints());
        return e;
    }

    protected BasicLabel createLabel() {
        BasicLabel l = new BasicLabel();
        l.setFont(SignalWizardDefaults.labelFont);
        l.setHorizontalAlignment(2);
        return l;
    }

    protected Tiler createTiler() {
        Tiler t = new Tiler();
        t.addItemListener(this.eventHandler);
        return t;
    }

    public String decodeChannelLabel(byte label, int index) {
        return this.layer.decodeChannelLabel(label, index);
    }

    public void expand() {
        int i = this.tiler.getSelectedIndex();
        if (this.layer.getChannelSubstructure(i)) {
            this.expand((short)i);
        }
    }

    public void expand(short channel) {
        this.layer.requestChildAnalyser(channel);
    }

    public int getAnalyserId() {
        return this.layer.getAnalyserId();
    }

    public String getChannelIdentifier(int c) {
        return this.layer.getChannelIdentifier(c);
    }

    public boolean getChannelSubstructure(int index) {
        return this.layer.getChannelSubstructure(index);
    }

    public int getDepth() {
        return this.layer.getDepth();
    }

    public ErrorTable getErrorTable() {
        return this.errorTable;
    }

    public int getHeight() {
        int tilerHeight = this.tiler.getPreferredSize().height;
        int tableHeight = this.errorTable.getPreferredSize().height;
        return Math.max(tilerHeight += tableHeight - this.getTileHeight(), tableHeight);
    }

    public int getIndexInParent() {
        return this.layer.getIndexInParent();
    }

    public BasicLabel getLabel() {
        return this.label;
    }

    public ViewerManager getManager() {
        return this.manager;
    }

    public int getMaxNumTiles() {
        return this.layer.getMaxNumTiles();
    }

    public short getNumColumns() {
        return this.numColumns;
    }

    public int getNumTiles() {
        return this.tiler.getComponentCount();
    }

    public LayerViewer getParentViewer() {
        return this.layer.getParentViewer();
    }

    public int getSelectedIndex() {
        return this.tiler == null ? 0 : this.tiler.getSelectedIndex();
    }

    protected int getTileHeight() {
        return this.isSingle() ? 24 : 19;
    }

    public Tiler getTiler() {
        return this.tiler;
    }

    protected int getTileSpan(short index) {
        return this.colSpan[index];
    }

    protected boolean getTileSubstructure(short index) {
        return this.layer.getChannelSubstructure(index);
    }

    private int getTileWidth(int index) {
        int s = this.colSpan[index];
        return this.columnWidth * s + this.columnGap * (s - 1);
    }

    public String getTraceMessage() {
        return this.layer.getTraceMessage();
    }

    /*
     * Unable to fully structure code
     */
    private UnconsumedKeyHandler getUnconsumedKeyHandler() {
        block2: {
            if (this.keyHandler != null) break block2;
            p = this.tiler.getParent();
            if (p != null) ** GOTO lbl6
            return null;
lbl-1000:
            // 1 sources

            {
                p = p.getParent();
lbl6:
                // 2 sources

                ** while (p.getParent() != null)
            }
lbl7:
            // 1 sources

            if (!(p instanceof UnconsumedKeyHandler)) {
                throw new NullPointerException("The root parent " + p.toString() + " doesn't implement UnconsumedKeyHandler");
            }
            this.keyHandler = (UnconsumedKeyHandler)p;
        }
        return this.keyHandler;
    }

    public boolean hasParent() {
        return this.layer.hasParent();
    }

    public void ignoreParent() {
        this.layer.detachFromParent();
    }

    protected boolean isActive() {
        return this.active;
    }

    protected boolean isCompressed() {
        return this.tiler.isCompressed();
    }

    public boolean isCompressible() {
        return !this.isSingle();
    }

    public boolean isErrorAfter() {
        return this.lastError != -1 && this.tiler.getSelectedIndex() != -1 && this.tiler.getSelectedIndex() < this.lastError;
    }

    public boolean isErrorBefore() {
        return this.firstError != -1 && this.tiler.getSelectedIndex() > this.firstError;
    }

    public boolean isPdh() {
        return this.layer.isPdh();
    }

    protected boolean isSingle() {
        return this.layer.getMaxNumTiles() == 1;
    }

    public boolean isValid() {
        return this.layer.isValid();
    }

    public void notifySelectionChanged() {
        int i = this.tiler.getSelectedIndex();
        if (i > -1) {
            if (this.label != null) {
                this.label.setText(this.getChannelIdentifier(i));
            }
            if (this.manager != null) {
                this.manager.notifySelectionChange(this);
            }
            this.layer.setCurrentTile((short)i);
        }
    }

    private void processKeyEvent(KeyEvent e) {
        SigwizTile cfr_ignored_0 = (SigwizTile)((Object)e.getComponent());
        if (e.getID() == 401) {
            switch (InstrumentKeyMappings.deriveKeyType((KeyEvent)e)) {
                case 10: {
                    this.getManager().expand();
                    e.consume();
                    break;
                }
                case 27: {
                    this.collapse();
                    e.consume();
                    break;
                }
            }
        }
        if (!e.isConsumed() && this.getUnconsumedKeyHandler() != null) {
            this.getUnconsumedKeyHandler().processUnconsumedKeyEvents(e, e.getComponent());
        }
    }

    public void selectNextError() {
        int pos = this.tiler.getSelectedIndex() + 1;
        while (pos < this.tiler.getComponentCount()) {
            if (this.layer.isError(pos)) {
                this.setTile(pos);
                break;
            }
            ++pos;
        }
    }

    public void selectPreviousError() {
        int pos = this.tiler.getSelectedIndex() - 1;
        while (pos > -1) {
            if (this.layer.isError(pos)) {
                this.setTile(pos);
                break;
            }
            --pos;
        }
    }

    public void setActive(boolean a) {
        if (this.active != a) {
            this.active = a;
            if (this.manager != null) {
                if (this.active) {
                    this.notifySelectionChanged();
                    this.manager.setActiveViewer(this);
                    this.tiler.requestFocus();
                } else {
                    this.manager.notifyInactiveViewer(this);
                }
            }
        }
    }

    public void setColumnProperties(int width, int vGap) {
        this.columnWidth = width;
        this.rowGap = vGap;
    }

    public void setCurrentTileTraceMessage(String m) {
        if (this.isSingle() || !this.hasParent()) {
            if (this.tiler.getComponentCount() > 0) {
                if (m != null && m.length() != 0) {
                    ((Tile)this.tiler.getComponent(0)).setText(String.valueOf(this.layer.getChannelCaption(0)) + " : " + m);
                } else {
                    ((Tile)this.tiler.getComponent(0)).setText(this.layer.getChannelCaption(0));
                }
            }
        } else if (this.manager != null) {
            this.manager.notifyMessageChange(this);
        }
    }

    public void setEnabled(boolean e) {
        this.tiler.setEnabled(e);
    }

    public void setErrorState(String byteDecode, byte[] errorsAndAlarms) {
        this.getErrorTable().setState(byteDecode, errorsAndAlarms);
        if (this.manager != null) {
            this.manager.notifyErrorChange(this);
        }
    }

    public void setManager(ViewerManager m) {
        this.manager = m;
        if (!this.isValid()) {
            this.manager.structureChange(this);
        }
    }

    public void setNumColumns(short n) {
        this.numColumns = n;
    }

    public void setStatus(ChannelStatus[] s) {
        this.firstError = -1;
        this.lastError = -1;
        int i = 0;
        while (i < s.length) {
            this.updateChannelState(i, s[i]);
            ++i;
        }
        this.tiler.repaint();
    }

    public void setStructure(ChannelStatus[] s) {
        boolean a = this.isActive();
        this.allocateTileWidths(s);
        int x = 0;
        int y = 0;
        this.tiler.selectNone();
        this.tiler.removeAll();
        this.firstError = -1;
        this.lastError = -1;
        int i = 0;
        while (i < s.length) {
            SigwizTile t = new SigwizTile();
            ((Component)((Object)t)).addFocusListener(this.eventHandler);
            ((Component)((Object)t)).addKeyListener(this.eventHandler);
            t.setFont(SignalWizardDefaults.tileFont);
            int tileHeight = this.getTileHeight();
            int tileWidth = this.getTileWidth(i);
            if (x + this.colSpan[i] > this.numColumns) {
                x = 0;
                ++y;
            }
            int tileX = x * (this.columnWidth + this.columnGap);
            int tileY = y * (tileHeight + this.rowGap);
            this.setTileState(t, s[i], i);
            t.setBounds(tileX, tileY, tileWidth, tileHeight);
            this.tiler.add((Component)((Object)t));
            if (i == 0) {
                if (this.label != null) {
                    this.label.setText(this.getChannelIdentifier(i));
                }
                this.tiler.selectTile(0);
                if (this.active) {
                    this.tiler.requestFocus();
                }
                if (this.manager != null) {
                    this.manager.notifySelectionChange(this);
                }
            }
            x += this.colSpan[i];
            ++i;
        }
        if (this.manager != null) {
            this.manager.layoutViewers();
            this.manager.notifyStructureComplete(this);
        }
        this.tiler.repaint();
        if (a) {
            this.tiler.requestFocus();
        }
    }

    public void setTile(int index) {
        if (!this.isSingle()) {
            this.tiler.selectTile(index);
            this.notifySelectionChanged();
        }
    }

    protected void setTileState(SigwizTile t, ChannelStatus s, int index) {
        ((Component)((Object)t)).setBackground(tileStateColours[s.status][0]);
        ((Component)((Object)t)).setForeground(tileStateColours[s.status][1]);
        if (this.layer.isError(index)) {
            if (this.firstError > index || this.firstError == -1) {
                this.firstError = index;
            }
            if (this.lastError < index) {
                this.lastError = index;
            }
        } else {
            int pos;
            if (this.firstError == index) {
                pos = index;
                while (pos < this.tiler.getComponentCount()) {
                    this.firstError = pos;
                    if (this.layer.isError(pos)) break;
                    ++pos;
                }
                if (pos == this.tiler.getComponentCount()) {
                    this.lastError = -1;
                }
            }
            if (this.lastError == index) {
                pos = index;
                while (pos > -1) {
                    this.lastError = pos;
                    if (this.layer.isError(pos)) break;
                    --pos;
                }
            }
        }
        if (s.status == 3) {
            t.setText(this.colSpan[index] == 1 ? "A" : "A I S");
        } else if (this.isSingle() || !this.hasParent()) {
            t.restrictTextWidth(true);
            if (this.getTraceMessage() != null && this.getTraceMessage().length() > 0) {
                t.setText(String.valueOf(this.layer.getChannelCaption(index)) + " : " + this.getTraceMessage());
            } else {
                t.setText(this.layer.getChannelCaption(index));
            }
        } else {
            t.restrictTextWidth(false);
            t.setText(this.layer.getShortChannelCaption(index));
        }
        t.setUnderlined(s.substructure);
        t.setForeign(s.foreign);
    }

    public void showCursor(boolean cursorVisible) {
        this.tiler.showCursor(cursorVisible);
    }

    public void specialOperation(PrimitiveTypesReader r) {
    }

    protected void uncompress() {
        this.tiler.uncompress();
        this.notifySelectionChanged();
    }

    public void unregister() {
        this.layer.unregister();
        if (this.manager != null) {
            this.layer.setCurrentTileTraceMessage("");
            this.manager.notifyMessageChange(this);
        }
    }

    public void updateChannelState(int index, ChannelStatus state) {
        SigwizTile t = (SigwizTile)this.tiler.getTile(index);
        if (t != null) {
            this.setTileState(t, state, index);
            ((Component)((Object)t)).repaint();
        }
    }

    static ViewerManager access$manager(LayerViewer layerViewer) {
        return layerViewer.manager;
    }

    static void access$processKeyEvent(LayerViewer layerViewer, KeyEvent keyEvent) {
        layerViewer.processKeyEvent(keyEvent);
    }

    private class TileEventHandler
    implements FocusListener,
    KeyListener,
    ItemListener {
        /* synthetic */ LayerViewer this$0;

        public void keyPressed(KeyEvent e) {
            LayerViewer.access$processKeyEvent(this.this$0, e);
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
            this.this$0.setActive(true);
        }

        public void focusLost(FocusEvent e) {
            this.this$0.setActive(false);
        }

        public void itemStateChanged(ItemEvent e) {
            this.this$0.notifySelectionChanged();
        }

        TileEventHandler(LayerViewer this$0) {
            this.this$0 = this$0;
        }
    }
}

