/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalWizardDirector;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ConnectionComponent;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.CursorClient;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.CursorFlasherThread;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ErrorTable;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.LayerViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.MultiLayerConnection;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.SignalWizardMenuInterface;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.SingleLayerConnection;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.StructureScope;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.Tiler;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ViewerManager;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.Tile;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;

public class PdhViewerManager
extends Container
implements ViewerManager,
CursorClient {
    private transient EclPanePage navigationPane = null;
    private transient EclPanePage infoPane = null;
    private transient BasicLabel selectedChannelLabel = null;
    private transient ArrayList viewerList = new ArrayList(10);
    private transient LayerViewer activeViewer = null;
    private transient HashMap connections = new HashMap();
    private transient SignalWizardDirector director = null;
    private transient CursorFlasherThread cursorFlasherThread = null;
    private transient int verticalSeparation = 19;
    private static final int INFO_PANE_HEIGHT = 50;
    private transient StructureScope manager = null;

    public PdhViewerManager() {
        this.navigationPane = new EclPanePage();
        this.infoPane = new EclPanePage();
        this.selectedChannelLabel = new BasicLabel("Selected channel:");
        this.selectedChannelLabel.setHorizontalAlignment(0);
        this.selectedChannelLabel.setSize(this.selectedChannelLabel.getPreferredSize());
        this.selectedChannelLabel.setVisible(false);
        this.infoPane.add((Component)this.selectedChannelLabel);
        this.add((Component)this.navigationPane);
        this.add((Component)this.infoPane);
        this.setSize(600, 300);
    }

    public void acknowledgeStructureChange() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            LayerViewer topmostInvalidViewer = null;
            int i = 0;
            while (i < this.viewerList.size()) {
                LayerViewer v = (LayerViewer)this.viewerList.get(i);
                if (!v.isValid()) {
                    topmostInvalidViewer = v;
                    break;
                }
                ++i;
            }
            if (topmostInvalidViewer != null) {
                this.removeViewersBelow(topmostInvalidViewer);
                topmostInvalidViewer.acknowledgeStructureChange();
            }
        }
    }

    public void addViewer(LayerViewer v, LayerViewer parent, int indexInParent) {
        if (parent != null && !parent.getChannelSubstructure(indexInParent)) {
            v.unregister();
            return;
        }
        v.setManager(this);
        BasicLabel label = v.getLabel();
        Tiler tiler = v.getTiler();
        ErrorTable table = v.getErrorTable();
        Dimension d = null;
        int w = this.getSize().width;
        int h = this.infoPane.getSize().height;
        if (tiler != null) {
            tiler.setSize(((Component)tiler).getPreferredSize());
            this.navigationPane.add(tiler);
        }
        if (table != null) {
            d = ((Component)table).getPreferredSize();
            table.setBounds(w / 2 + 10, (h - d.height) / 2, d.width, d.height);
            this.infoPane.add(table);
        }
        if (label != null) {
            d = label.getPreferredSize();
            label.setBounds(this.selectedChannelLabel.getLocation().x, h / 2, this.selectedChannelLabel.getSize().width, d.height);
            this.infoPane.add((Component)label);
        }
        if (parent != null) {
            int span = parent.getTileSpan((short)indexInParent);
            if (v.getMaxNumTiles() > span) {
                span = 1;
                v.setColumnProperties(19, 1);
            }
            v.setNumColumns((short)span);
        }
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (parent == null || this.viewerList.contains((Object)parent)) {
                this.viewerList.add((Object)v);
                this.layoutViewers();
                this.connectViewerToParent(v);
            } else {
                v.unregister();
                this.navigationPane.remove(tiler);
                this.infoPane.remove(table);
                this.infoPane.remove((Component)label);
            }
        }
        this.repaint();
    }

    public void collapse() {
    }

    protected void connectViewerToParent(LayerViewer v) {
        Tile tile;
        LayerViewer parent = v.getParentViewer();
        if (parent != null && (tile = parent.getTiler().getTile(v.getIndexInParent())) != null) {
            ConnectionComponent c = v.getNumColumns() == 1 ? new SingleLayerConnection((Component)tile, v.getTiler(), this, Color.gray) : new MultiLayerConnection((Component)tile, v.getTiler(), this, Color.gray);
            this.connections.put((Object)v, (Object)c);
            this.navigationPane.add((Component)c, 0);
        }
    }

    public void expand() {
    }

    public void finishInitialise() {
        if (this.cursorFlasherThread != null) {
            this.cursorFlasherThread.pleaseStop();
        }
        this.cursorFlasherThread = new CursorFlasherThread(this);
        this.cursorFlasherThread.setPriority(Thread.currentThread().getPriority() - 1);
        this.cursorFlasherThread.start();
    }

    public LayerViewer getActiveViewer() {
        return this.activeViewer;
    }

    private LayerViewer getChild(LayerViewer parent, int indexInParent) {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.viewerList.size()) {
                LayerViewer v = (LayerViewer)this.viewerList.get(i);
                if (v.getParentViewer() == parent && v.getIndexInParent() == indexInParent) {
                    return v;
                }
                ++i;
            }
        }
        return null;
    }

    public int getIndex(LayerViewer v) {
        return this.viewerList.indexOf((Object)v);
    }

    private void layoutInternals() {
        int w = this.getSize().width;
        int h = this.getSize().height;
        this.navigationPane.setBounds(0, 0, w, h - 50);
        this.infoPane.setBounds(0, h - 50, w, 50);
        Dimension d = this.selectedChannelLabel.getPreferredSize();
        this.selectedChannelLabel.setBounds(w / 2 - 10 - d.width, 25 - d.height, d.width, d.height);
    }

    public void layoutViewers() {
        int cfr_ignored_0 = this.getSize().width;
        int cfr_ignored_1 = this.getSize().height;
        int y = this.verticalSeparation;
        int currentDepth = 0;
        int height = 0;
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.viewerList.size()) {
                LayerViewer v = (LayerViewer)this.viewerList.get(i);
                if (height == 0) {
                    height = v.getHeight();
                }
                if (v.getDepth() != currentDepth) {
                    currentDepth = v.getDepth();
                    y += height + this.verticalSeparation;
                    height = v.getHeight();
                }
                Tiler t = v.getTiler();
                ErrorTable e = v.getErrorTable();
                BasicLabel l = v.getLabel();
                t.setSize(((Component)t).getPreferredSize());
                this.positionViewer(v, y);
                e.setVisible(v.isActive());
                l.setVisible(v.isActive());
                ConnectionComponent c = (ConnectionComponent)this.connections.get((Object)v);
                if (c != null) {
                    c.recalculateGeometry();
                }
                ++i;
            }
        }
    }

    public void notifyErrorChange(LayerViewer v) {
    }

    public synchronized void notifyInactiveViewer(LayerViewer v) {
        if (v == this.activeViewer) {
            this.activeViewer = null;
            v.showCursor(false);
            v.getLabel().setVisible(false);
            v.getErrorTable().setVisible(false);
            this.selectedChannelLabel.setVisible(false);
        }
    }

    public void notifyMessageChange(LayerViewer v) {
    }

    public void notifySelectionChange(LayerViewer v) {
        this.selectedChannelLabel.setVisible(this.activeViewer != null);
    }

    public void notifyStructureComplete(LayerViewer v) {
        short i = 0;
        while (i < v.getNumTiles()) {
            if (v.getTileSubstructure(i)) {
                v.expand(i);
            }
            i = (short)(i + 1);
        }
    }

    private void positionViewer(LayerViewer v, int y) {
        LayerViewer parent = v.getParentViewer();
        if (parent == null) {
            Tiler tiler = v.getTiler();
            int width = this.getSize().width;
            tiler.setLocation((width - tiler.getSize().width) / 2, y);
        } else {
            Tiler tiler = v.getTiler();
            Tile tile = parent.getTiler().getTile(v.getIndexInParent());
            Container container = tile.getParent();
            int x = tile.getLocation().x;
            while (container != this && container != null) {
                x += container.getLocation().x;
                container = container.getParent();
            }
            tiler.setLocation(x += (tile.getSize().width - tiler.getSize().width) / 2, y);
        }
    }

    public void removeAllViewers() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            while (this.viewerList.size() > 0) {
                LayerViewer v = (LayerViewer)this.viewerList.get(0);
                this.removeViewer(v);
            }
        }
    }

    public void removeConnection(LayerViewer v) {
        if (this.connections.containsKey((Object)v)) {
            ConnectionComponent c = (ConnectionComponent)this.connections.get((Object)v);
            this.connections.remove((Object)v);
            if (c instanceof Component) {
                this.navigationPane.remove(c);
            }
        }
    }

    public void removeViewer(LayerViewer v) {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (this.viewerList.contains((Object)v)) {
                v.unregister();
                this.viewerList.remove((Object)v);
                this.removeConnection(v);
                if (this.activeViewer == v) {
                    this.selectDefaultViewer();
                }
                if (v.getTiler() != null) {
                    this.navigationPane.remove(v.getTiler());
                }
                if (v.getLabel() != null) {
                    this.infoPane.remove((Component)v.getLabel());
                }
                if (v.getErrorTable() != null) {
                    this.infoPane.remove(v.getErrorTable());
                }
                this.layoutViewers();
            }
        }
    }

    public void removeViewersBelow(LayerViewer viewer) {
        viewer.setEnabled(true);
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.viewerList.size()) {
                LayerViewer v = (LayerViewer)this.viewerList.get(i);
                if (v.getParentViewer() == viewer) {
                    this.removeViewersBelow(v);
                    this.removeViewer(v);
                    --i;
                }
                ++i;
            }
        }
        this.repaint();
    }

    public synchronized void requestFocus() {
        if (this.getActiveViewer() != null) {
            this.getActiveViewer().getTiler().requestFocus();
        }
    }

    public void selectChannel(LayerViewer v, int c) {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (this.viewerList.contains((Object)v)) {
                v.setTile(c);
            }
        }
    }

    private void selectDefaultViewer() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (this.viewerList.size() > 0) {
                LayerViewer root = (LayerViewer)this.viewerList.get(0);
                this.setActiveViewer(root);
            }
        }
    }

    public void selectNextError() {
        LayerViewer v = this.getActiveViewer();
        if (v != null) {
            v.selectNextError();
        }
    }

    public void selectPreviousError() {
        LayerViewer v = this.getActiveViewer();
        if (v != null) {
            v.selectPreviousError();
        }
    }

    public synchronized void setActiveViewer(LayerViewer v) {
        LayerViewer a = this.activeViewer;
        if (a != v) {
            this.activeViewer = v;
            if (a != null) {
                a.setActive(false);
                a.showCursor(false);
                a.getErrorTable().setVisible(false);
                a.getLabel().setVisible(false);
            }
            if (v != null) {
                v.setActive(true);
                v.getErrorTable().setVisible(true);
                v.getLabel().setVisible(true);
            }
            this.selectedChannelLabel.setVisible(v != null);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.layoutInternals();
        this.layoutViewers();
    }

    public void setDirector(SignalWizardDirector d) {
        this.director = d;
    }

    public void setManager(StructureScope m) {
        this.manager = m;
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.layoutInternals();
        this.layoutViewers();
    }

    public synchronized void setupMenu(SignalWizardMenuInterface m) {
        boolean thruMode = Server.instance().context().isThruModeEnabled();
        m.enableSetupRxTx(!thruMode);
        m.enableCollapse(false);
        m.enableExpand(false);
        LayerViewer v = this.getActiveViewer();
        m.enablePrevError(v != null && v.isErrorBefore());
        m.enableNextError(v != null && v.isErrorAfter());
    }

    public void showCursor(boolean cursorVisible) {
        if (this.activeViewer != null) {
            this.activeViewer.showCursor(cursorVisible);
        }
    }

    private void stopFlasher() {
        if (this.cursorFlasherThread != null) {
            this.cursorFlasherThread.pleaseStop();
        }
        this.cursorFlasherThread = null;
    }

    public void structureChange(LayerViewer v) {
        this.acknowledgeStructureChange();
    }

    public void unregister() {
        this.stopFlasher();
        this.removeAllViewers();
    }
}

