/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalWizardDirector;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ConnectionComponent;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.CursorClient;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.CursorFlasherThread;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ErrorTable;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.LayerViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.SignalWizardMenuInterface;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.StructureChangeAcknowledgeReceiver;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.StructureScope;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.TeeLayerConnection;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.Tiler;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.TraceMessageViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ViewerManager;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.BasicLabel;
import com.agilent.tntd.eclipse.viewlayer.basiccomponents.Tile;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import com.agilent.tntd.eclipse.viewlayer.containers.panepage.EclPanePage;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;

public class SdhViewerManager
extends Container
implements CursorClient,
ViewerManager,
StructureChangeAcknowledgeReceiver {
    private transient EclPanePage labelPane = null;
    private transient EclPanePage tilerPane = null;
    private transient EclPanePage tablePane = null;
    private transient ArrayList viewerList = new ArrayList(10);
    private transient LayerViewer activeViewer = null;
    private transient HashMap connections = new HashMap();
    private transient SignalWizardDirector director = null;
    private transient CursorFlasherThread cursorFlasherThread = null;
    private transient TraceMessageViewer traceMessageViewer = null;
    private transient int verticalSeparation = 0;
    private static final int PANE_SPACING = 10;
    private static final int MIN_VERTICAL_SEPARATION = 8;
    private transient EclDialog acknowledgeDialog = null;
    private transient boolean structureChangeOutstanding = false;
    private transient boolean structureChangesSuppressed = false;
    private transient StructureScope manager = null;

    public SdhViewerManager() {
        this.labelPane = new EclPanePage();
        this.tilerPane = new EclPanePage();
        this.tablePane = new EclPanePage();
        this.add((Component)this.labelPane);
        this.add((Component)this.tilerPane);
        this.add((Component)this.tablePane);
        this.setSize(600, 300);
        this.layoutViewers();
    }

    public void acknowledgeStructureChange() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            this.structureChangeOutstanding = false;
            LayerViewer topmostInvalidViewer = null;
            int i = 0;
            while (i < this.viewerList.size()) {
                LayerViewer v = (LayerViewer)this.viewerList.get(i);
                if (!v.isValid()) {
                    topmostInvalidViewer = v;
                    break;
                }
                ++i;
            }
            if (topmostInvalidViewer != null) {
                this.removeViewersBelow(topmostInvalidViewer);
                topmostInvalidViewer.acknowledgeStructureChange();
            }
        }
    }

    public void addViewer(LayerViewer v, LayerViewer parent, int indexInParent) {
        if (parent != null && !parent.getChannelSubstructure(indexInParent)) {
            v.unregister();
            return;
        }
        v.setManager(this);
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            BasicLabel label = v.getLabel();
            Tiler tiler = v.getTiler();
            ErrorTable table = v.getErrorTable();
            if (label != null) {
                label.setVisible(false);
                this.labelPane.add((Component)label);
            }
            if (tiler != null) {
                tiler.setVisible(false);
                this.tilerPane.add(tiler);
            }
            if (table != null) {
                table.setVisible(false);
                this.tablePane.add(table);
            }
            this.viewerList.add((Object)v);
            this.layoutViewers();
            if (label != null) {
                label.setVisible(true);
            }
            if (tiler != null) {
                tiler.setVisible(true);
            }
            if (table != null) {
                table.setVisible(true);
            }
            if (parent == null || this.viewerList.contains((Object)parent)) {
                this.connectViewerToParent(v);
            }
        }
        this.setActiveViewer(v);
    }

    public void collapse() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (this.viewerList.size() > 1) {
                LayerViewer v = this.getActiveViewer();
                if (v != null) {
                    this.removeViewer(v);
                }
                if ((v = this.getActiveViewer()) != null) {
                    v.setEnabled(true);
                    v.getTiler().requestFocus();
                    this.notifyMessageChange(v);
                }
                this.repaint();
            }
        }
    }

    private void compressViewersAsNeeded() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            LayerViewer v;
            int totalHeight = 0;
            int containerHeight = this.getSize().height;
            int numViewers = this.viewerList.size();
            int i = 0;
            while (i < numViewers) {
                v = (LayerViewer)this.viewerList.get(i);
                v.uncompress();
                totalHeight += v.getHeight();
                ++i;
            }
            this.verticalSeparation = (containerHeight - totalHeight) / (numViewers + 1);
            while (this.verticalSeparation < 8) {
                i = 0;
                i = 0;
                while (i < numViewers - 1) {
                    v = (LayerViewer)this.viewerList.get(i);
                    if (v.isCompressible() && !v.isCompressed()) {
                        totalHeight -= v.getHeight();
                        v.compress();
                        this.verticalSeparation = (containerHeight - (totalHeight += v.getHeight())) / (numViewers + 1);
                        break;
                    }
                    ++i;
                }
                if (i == numViewers - 1) break;
            }
            if (this.verticalSeparation < 8) {
                this.verticalSeparation = 8;
            }
        }
    }

    protected void connectViewerToParent(LayerViewer v) {
        Tile tile;
        LayerViewer parent = v.getParentViewer();
        if (parent != null && (tile = parent.getTiler().getTile(v.getIndexInParent())) != null) {
            TeeLayerConnection c = new TeeLayerConnection((Component)tile, v.getTiler(), (Container)this.tilerPane, Color.blue);
            this.connections.put((Object)v, (Object)c);
            this.tilerPane.add((Component)c, 0);
        }
    }

    public void expand() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            LayerViewer v = this.getActiveViewer();
            if (v != null && v.canExpand()) {
                v.expand();
            }
        }
    }

    public void finishInitialise() {
        if (this.cursorFlasherThread != null) {
            this.cursorFlasherThread.pleaseStop();
        }
        this.cursorFlasherThread = new CursorFlasherThread(this);
        this.cursorFlasherThread.setPriority(Thread.currentThread().getPriority() - 1);
        this.cursorFlasherThread.start();
    }

    public LayerViewer getActiveViewer() {
        return this.activeViewer;
    }

    public int getIndex(LayerViewer v) {
        return this.viewerList.indexOf((Object)v);
    }

    public void layoutViewers() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            this.compressViewersAsNeeded();
            int w = this.getSize().width;
            int h = this.getSize().height;
            int tableWidth = 117;
            int tilerWidth = 383;
            int labelWidth = w - (tableWidth + tilerWidth + 20);
            this.tablePane.setBounds(w - tableWidth, 0, tableWidth, h);
            this.tilerPane.setBounds(w - (tableWidth + 10 + tilerWidth), 0, tilerWidth, h);
            this.labelPane.setBounds(0, 0, labelWidth, h);
            int y = this.verticalSeparation;
            int i = 0;
            while (i < this.viewerList.size()) {
                LayerViewer v = (LayerViewer)this.viewerList.get(i);
                ConnectionComponent c = (ConnectionComponent)this.connections.get((Object)v);
                BasicLabel l = v.getLabel();
                Tiler t = v.getTiler();
                v.getErrorTable();
                if (l != null) {
                    l.setSize(labelWidth, l.getSize().height);
                }
                if (t != null) {
                    Dimension d = ((Component)t).getPreferredSize();
                    t.setBounds((tilerWidth - d.width) / 2, y, d.width, d.height);
                    if (c != null) {
                        c.recalculateGeometry();
                    }
                }
                y += v.getHeight() + this.verticalSeparation;
                v.notifySelectionChanged();
                ++i;
            }
        }
    }

    public void notifyErrorChange(LayerViewer v) {
    }

    public void notifyInactiveViewer(LayerViewer v) {
    }

    public void notifyMessageChange(LayerViewer v) {
        if (this.getActiveViewer() == v && this.traceMessageViewer != null) {
            if (v.isSingle()) {
                this.traceMessageViewer.displayTraceMessage("");
            } else {
                this.traceMessageViewer.displayTraceMessage(v.getTraceMessage());
            }
        }
    }

    public void notifySelectionChange(LayerViewer v) {
        Tiler tiler = v.getTiler();
        BasicLabel label = v.getLabel();
        ErrorTable table = v.getErrorTable();
        Component t = tiler.getSelectedTile();
        if (t == null) {
            return;
        }
        int y = t.getLocation().y + tiler.getLocation().y + t.getSize().height / 2;
        if (label != null) {
            label.setLocation(0, y - label.getSize().height / 2);
        }
        if (table != null) {
            table.setLocation(0, y - table.getSize().height / 2);
        }
    }

    public void notifyStructureComplete(LayerViewer v) {
        if (v.isSingle() && !v.containsPdh()) {
            v.expand();
        }
    }

    private void popupStructureChangeDialog() {
        if (this.acknowledgeDialog == null) {
            this.acknowledgeDialog = new EclDialog();
            this.acknowledgeDialog.setSize(270, 100);
        }
        if (this.acknowledgeDialog.getParent() == null && this.director.isRunning()) {
            this.acknowledgeDialog.displayMessageWindow(true, false, true, "The signal structure has changed! Refresh now?", "", new DialogEventReceiver(this){
                /* synthetic */ SdhViewerManager this$0;

                public void notifyEvent(int id, EclDialog d) {
                    if (id == 2) {
                        SdhViewerManager.access$acknowledgeDialog(this.this$0).removeFromWorkspace();
                        this.this$0.acknowledgeStructureChange();
                    } else {
                        SdhViewerManager.access$acknowledgeDialog(this.this$0).removeFromWorkspace();
                    }
                }
                {
                    this.this$0 = this$0;
                }
            }, new Font("dialog", 0, 12));
        }
    }

    public void removeAllViewers() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            while (this.viewerList.size() > 0) {
                LayerViewer v = (LayerViewer)this.viewerList.get(0);
                this.removeViewer(v);
            }
        }
    }

    public void removeConnection(LayerViewer v) {
        if (this.connections.containsKey((Object)v)) {
            ConnectionComponent c = (ConnectionComponent)this.connections.get((Object)v);
            this.connections.remove((Object)v);
            this.tilerPane.remove(c);
        }
    }

    public void removeViewer(LayerViewer v) {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (this.viewerList.contains((Object)v)) {
                LayerViewer parent = v.getParentViewer();
                v.unregister();
                this.viewerList.remove((Object)v);
                if (v.getLabel() != null) {
                    this.labelPane.remove((Component)v.getLabel());
                }
                if (v.getTiler() != null) {
                    this.tilerPane.remove(v.getTiler());
                }
                if (v.getErrorTable() != null) {
                    this.tablePane.remove(v.getErrorTable());
                }
                this.removeConnection(v);
                this.layoutViewers();
                if (parent != null) {
                    parent.getTiler().requestFocus();
                }
            }
        }
    }

    public void removeViewersBelow(LayerViewer viewer) {
        viewer.setEnabled(true);
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.viewerList.size()) {
                LayerViewer v = (LayerViewer)this.viewerList.get(i);
                if (v.getParentViewer() == viewer) {
                    this.removeViewersBelow(v);
                    this.removeViewer(v);
                    --i;
                }
                ++i;
            }
        }
        this.repaint();
    }

    public synchronized void requestFocus() {
        if (this.director.windowSelected()) {
            if (this.getActiveViewer() != null) {
                this.getActiveViewer().getTiler().requestFocus();
            } else {
                this.selectDefaultViewer();
            }
        }
    }

    public void selectChannel(LayerViewer v, int c) {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (this.viewerList.contains((Object)v)) {
                v.setTile(c);
            }
        }
    }

    private void selectDefaultViewer() {
        LayerViewer v;
        int n = this.viewerList.size();
        if (n > 0 && (v = (LayerViewer)this.viewerList.get(n - 1)) != null) {
            v.setActive(true);
        }
    }

    public void selectNextError() {
        LayerViewer v = this.getActiveViewer();
        if (v != null) {
            v.selectNextError();
        }
    }

    public void selectPreviousError() {
        LayerViewer v = this.getActiveViewer();
        if (v != null) {
            v.selectPreviousError();
        }
    }

    public synchronized void setActiveViewer(LayerViewer v) {
        LayerViewer a = this.activeViewer;
        if (a != v) {
            this.activeViewer = v;
            if (a != null) {
                a.setActive(false);
                a.showCursor(false);
                a.setEnabled(false);
            }
            if (v != null) {
                v.setEnabled(true);
                v.setActive(true);
                this.notifyMessageChange(v);
            }
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.layoutViewers();
    }

    public void setDirector(SignalWizardDirector d) {
        this.director = d;
    }

    public void setManager(StructureScope m) {
        this.manager = m;
    }

    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.layoutViewers();
    }

    public void setTraceMessageViewer(TraceMessageViewer v) {
        this.traceMessageViewer = v;
    }

    public synchronized void setupMenu(SignalWizardMenuInterface m) {
        boolean thruMode = Server.instance().context().isThruModeEnabled();
        m.enableSetupRxTx(!thruMode);
        m.enableRefresh(this.structureChangeOutstanding);
        LayerViewer v = this.getActiveViewer();
        if (v != null) {
            int i = this.getIndex(v);
            m.enableCollapse(i > 0);
            m.enablePrevError(v.isErrorBefore());
            m.enableNextError(v.isErrorAfter());
            m.enableSearchCurrent(v.hasParent());
            int t = v.getTiler().getSelectedIndex();
            if (t != -1) {
                boolean sub = v.getChannelSubstructure(t);
                boolean pdh = v.containsPdh();
                m.showTribscan(pdh);
                m.enableExpand(!pdh && sub || pdh && sub && !this.structureChangeOutstanding);
                m.enableSearchBelow(sub);
            } else {
                m.showTribscan(false);
                m.enableExpand(false);
                m.enableSearchBelow(false);
            }
        } else {
            m.showTribscan(false);
            m.enableCollapse(false);
            m.enableExpand(false);
            m.enableNextError(false);
            m.enablePrevError(false);
            m.enableSearchCurrent(false);
            m.enableSearchBelow(false);
        }
    }

    public void showCursor(boolean cursorVisible) {
        if (this.getActiveViewer() != null) {
            this.getActiveViewer().showCursor(cursorVisible);
        }
    }

    private void stopFlasher() {
        if (this.cursorFlasherThread != null) {
            this.cursorFlasherThread.pleaseStop();
        }
        this.cursorFlasherThread = null;
    }

    public synchronized void structureChange(LayerViewer v) {
        if (!this.structureChangeOutstanding) {
            this.structureChangeOutstanding = true;
            if (!this.structureChangesSuppressed) {
                this.popupStructureChangeDialog();
            }
        }
    }

    public synchronized void suppressStructureChanges(boolean b) {
        this.structureChangesSuppressed = b;
        if (!b && this.structureChangeOutstanding) {
            this.popupStructureChangeDialog();
        }
    }

    public void unregister() {
        this.stopFlasher();
        this.removeAllViewers();
        this.structureChangeOutstanding = false;
        this.structureChangesSuppressed = false;
        this.acknowledgeDialog = null;
    }

    public void zipUp() {
        ArrayList arrayList = this.viewerList;
        synchronized (arrayList) {
            if (this.viewerList.size() > 1) {
                LayerViewer v = (LayerViewer)this.viewerList.get(0);
                this.removeViewersBelow(v);
            }
        }
    }

    static EclDialog access$acknowledgeDialog(SdhViewerManager sdhViewerManager) {
        return sdhViewerManager.acknowledgeDialog;
    }
}

