/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ConnectionComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;

public class SingleLayerConnection
extends ConnectionComponent {
    private static final int thickness = 3;
    private Component sourceComponent = null;
    private Component targetComponent = null;
    private Container commonParent = null;
    private Color colour = Color.blue;
    private transient int startX = 0;
    private transient int height = 0;

    protected SingleLayerConnection(Component source, Component target, Container parent, Color c) {
        this.colour = c;
        this.sourceComponent = source;
        this.targetComponent = target;
        this.commonParent = parent;
    }

    public void paint(Graphics g) {
        g.setColor(this.colour);
        int i = 0;
        while (i < 3) {
            g.drawLine(this.startX + i, 0, this.startX + i, this.height - 1);
            ++i;
        }
    }

    public void recalculateGeometry() {
        if (!this.sourceComponent.isShowing() || !this.targetComponent.isShowing()) {
            return;
        }
        Point sourceOrigin = this.sourceComponent.getLocation();
        Point targetOrigin = this.targetComponent.getLocation();
        Container p = this.sourceComponent.getParent();
        while (p != this.commonParent) {
            if (p == null) {
                return;
            }
            sourceOrigin.x += p.getLocation().x;
            sourceOrigin.y += p.getLocation().y;
            p = p.getParent();
        }
        p = this.targetComponent.getParent();
        while (p != this.commonParent) {
            targetOrigin.x += p.getLocation().x;
            targetOrigin.y += p.getLocation().y;
            p = p.getParent();
        }
        this.height = targetOrigin.y - sourceOrigin.y - this.sourceComponent.getSize().height;
        int farthestLeft = Math.min(sourceOrigin.x, targetOrigin.x);
        int farthestRight = Math.max(sourceOrigin.x + this.sourceComponent.getSize().width, targetOrigin.x + this.targetComponent.getSize().width);
        int width = farthestRight - farthestLeft + 1;
        this.setBounds(farthestLeft, sourceOrigin.y + this.sourceComponent.getSize().height, width, this.height);
        this.startX = (width - 3) / 2;
        this.repaint();
    }
}

