/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.thinclient.signalwizard.SignalWizardDirector;
import com.agilent.tntd.eclipse.thinclient.signalwizard.StructureScopePage;
import com.agilent.tntd.eclipse.thinclient.signalwizard.TribScan;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.ViewableLayer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.CursorClient;
import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.LayerViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ContextUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.StructureScopeUI;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.InternalWindow;
import com.agilent.tntd.eclipse.viewlayer.architecture.containers.WindowManager;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.DialogEventReceiver;
import com.agilent.tntd.eclipse.viewlayer.containers.dialog.EclDialog;
import java.awt.Component;
import java.awt.Font;

public class StructureScope
implements StructureScopeUI,
ContextUI,
CursorClient {
    private transient SignalWizardDirector director = null;
    private transient StructureScopePage structureScope = null;
    private transient TribScan tribScan = null;
    private transient EclDialog setupFailureDialog = null;
    private transient boolean rootInTribScan = false;
    private static final boolean TRIBSCAN_ENABLED = true;

    public void addAnalyserUI(AnalyserUI v, AnalyserUI p, int indexInParent) {
        if (v instanceof ViewableLayer && (p instanceof ViewableLayer || p == null)) {
            ViewableLayer vl = (ViewableLayer)v;
            ViewableLayer pvl = (ViewableLayer)p;
            LayerViewer viewer = vl.getViewer();
            LayerViewer parent = null;
            if (pvl != null) {
                parent = pvl.getViewer();
            }
            if (viewer.isPdh()) {
                if (parent == null) {
                    this.rootInTribScan = true;
                    this.director.showSignalDiscoveryPage();
                } else if (!parent.isPdh()) {
                    parent = null;
                    viewer.ignoreParent();
                }
                if (!((Component)((Object)this.tribScan)).isShowing()) {
                    this.structureScope.suppressStructureChanges(true);
                    this.structureScope.zipUp();
                    this.structureScope.showElapsedTime(false);
                    this.tribScan.showElapsedTime(true);
                    Server.instance().context().resetElapsedTime();
                    this.tribScan.finishInitialise();
                    WindowManager.instance().connectWindow((InternalWindow)this.tribScan);
                }
                this.tribScan.addViewer(viewer, parent, indexInParent);
            } else {
                this.structureScope.addViewer(viewer, parent, indexInParent);
            }
        }
    }

    public void cleanup() {
        this.setupFailureDialog = null;
    }

    public void closeTribScan() {
        this.structureScope.showElapsedTime(true);
        this.tribScan.showElapsedTime(false);
        Server.instance().context().resetElapsedTime();
        this.structureScope.unzip();
        this.structureScope.suppressStructureChanges(false);
        if (this.rootInTribScan) {
            this.rootInTribScan = false;
            this.director.suspend();
        }
    }

    public AnalyserUI createAnalyserUI(AnalyserProxy a) {
        return new ViewableLayer(a);
    }

    public void popupSetupFailureDialog() {
        if (this.setupFailureDialog == null) {
            this.setupFailureDialog = new EclDialog();
            this.setupFailureDialog.setSize(250, 200);
        }
        this.setupFailureDialog.displayMessageWindow(false, true, false, "Failed to setup transmitter or receiver", "", new DialogEventReceiver(this){
            /* synthetic */ StructureScope this$0;

            public void notifyEvent(int id, EclDialog d) {
                StructureScope.access$setupFailureDialog(this.this$0).removeFromWorkspace();
            }
            {
                this.this$0 = this$0;
            }
        }, new Font("dialog", 0, 12));
    }

    public void setDirector(SignalWizardDirector d) {
        this.director = d;
    }

    public void setElapsedTime(String e) {
        this.structureScope.setElapsedTime(e);
        this.tribScan.setElapsedTime(e);
    }

    public void setOpticalPower(String p) {
        this.structureScope.setOpticalPower(p);
    }

    public void setScanPercentage(int percent) {
        if (((Component)((Object)this.tribScan)).isShowing()) {
            this.tribScan.setScanPercentage(percent);
        }
    }

    public void setStructureScope(StructureScopePage s) {
        this.structureScope = s;
        this.structureScope.setManager(this);
    }

    public void setTribScan(TribScan t) {
        this.tribScan = t;
        this.tribScan.setManager(this);
    }

    public void showCursor(boolean cursorVisible) {
        if (((Component)((Object)this.tribScan)).isShowing()) {
            this.tribScan.showCursor(cursorVisible);
        } else {
            this.structureScope.showCursor(cursorVisible);
        }
    }

    public void start() {
        Server.instance().context().resetElapsedTime();
        Server.instance().context().startElapsedTime();
        this.structureScope.start();
    }

    static EclDialog access$setupFailureDialog(StructureScope structureScope) {
        return structureScope.setupFailureDialog;
    }
}

