/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.thinclient.signalwizard.gui.ConnectionComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;

public class TeeLayerConnection
extends ConnectionComponent {
    private static final int stubLength = 6;
    private static final int thickness = 3;
    private Component sourceComponent = null;
    private Component targetComponent = null;
    private Container commonParent = null;
    private Color colour = null;
    private transient int startStubX = 0;
    private transient int startStubY = 0;
    private transient int endStubX = 0;
    private transient int endStubY = 0;
    private transient int bottomLineX = 0;
    private transient int bottomLineY = 0;
    private transient int bottomLineWidth = 0;

    protected TeeLayerConnection(Component source, Component target, Container parent, Color c) {
        this.colour = c;
        this.sourceComponent = source;
        this.targetComponent = target;
        this.commonParent = parent;
    }

    public void paint(Graphics g) {
        g.setColor(this.colour);
        int i = 0;
        while (i < 3) {
            g.drawLine(this.startStubX + i, this.startStubY, this.startStubX + i, this.startStubY + 6 - 1);
            ++i;
        }
        i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                g.drawLine(this.startStubX + i, this.startStubY + 6 + j, this.endStubX + i, this.endStubY - 3 + j);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            g.drawLine(this.endStubX + i, this.endStubY, this.endStubX + i, this.endStubY + 6 - 1);
            ++i;
        }
        i = 0;
        while (i < 3) {
            g.drawLine(this.bottomLineX, this.bottomLineY + i, this.bottomLineX + this.bottomLineWidth - 1, this.bottomLineY + i);
            ++i;
        }
    }

    public void recalculateGeometry() {
        if (!this.sourceComponent.isShowing() || !this.targetComponent.isShowing()) {
            return;
        }
        Point sourceOrigin = this.sourceComponent.getLocation();
        Point targetOrigin = this.targetComponent.getLocation();
        Container p = this.sourceComponent.getParent();
        while (p != this.commonParent) {
            if (p == null) {
                return;
            }
            sourceOrigin.x += p.getLocation().x;
            sourceOrigin.y += p.getLocation().y;
            p = p.getParent();
        }
        p = this.targetComponent.getParent();
        while (p != this.commonParent) {
            targetOrigin.x += p.getLocation().x;
            targetOrigin.y += p.getLocation().y;
            p = p.getParent();
        }
        this.startStubX = sourceOrigin.x + (this.sourceComponent.getSize().width - 3) / 2;
        this.startStubY = sourceOrigin.y + this.sourceComponent.getSize().height;
        this.endStubX = targetOrigin.x + (this.targetComponent.getSize().width - 3) / 2;
        this.endStubY = targetOrigin.y - 6 - 6;
        this.bottomLineWidth = this.targetComponent.getSize().width;
        this.bottomLineX = targetOrigin.x;
        this.bottomLineY = targetOrigin.y - 6;
        int height = targetOrigin.y - sourceOrigin.y - this.sourceComponent.getSize().height;
        int farthestLeft = Math.min(sourceOrigin.x, targetOrigin.x);
        int farthestRight = Math.max(sourceOrigin.x + this.sourceComponent.getSize().width, targetOrigin.x + this.targetComponent.getSize().width);
        this.setBounds(farthestLeft, this.startStubY, farthestRight - farthestLeft + 1, height);
        this.endStubY -= this.startStubY;
        this.bottomLineY -= this.startStubY;
        this.startStubX -= farthestLeft;
        this.endStubX -= farthestLeft;
        this.bottomLineX -= farthestLeft;
        this.startStubY = 0;
        this.repaint();
    }
}

