/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.gui;

import com.agilent.tntd.eclipse.viewlayer.basiccomponents.Tile;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.Beans;

public class Tiler
extends Container
implements ItemSelectable {
    private transient int selectedIndex = -1;
    private transient boolean hasFocus = false;
    private transient boolean cursorVisible = false;
    private transient Color cursorColor = Color.blue;
    private transient ItemListener itemListener = null;
    private transient FocusListener tileFocusListener = new FocusListener(this){
        /* synthetic */ Tiler this$0;

        public void focusGained(FocusEvent e) {
            Tiler.access$focusGained(this.this$0, e);
        }

        public void focusLost(FocusEvent e) {
        }
        {
            this.this$0 = this$0;
        }
    };
    private transient int verticalShift = 0;
    private transient boolean compressAbove = false;
    private transient boolean compressBelow = false;
    private final ItemEvent itemEvent = new ItemEvent(this, 701, null, 1);

    public Tiler() {
        this.setBackground(null);
        this.setSize(383, 261);
    }

    public Component add(Component c) {
        Component returnValue = super.add(c);
        c.addFocusListener(this.tileFocusListener);
        if (this.selectedIndex == -1) {
            this.selectedIndex = 0;
        }
        return returnValue;
    }

    public void addItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, l);
    }

    public void compress() {
        Component c;
        int currentY;
        if (this.isCompressed() || this.selectedIndex == -1) {
            return;
        }
        int rowsAboveCurrent = 0;
        int rowsBelowCurrent = 0;
        int y = currentY = this.getComponent((int)this.selectedIndex).getLocation().y;
        int i = this.selectedIndex;
        while (i >= 0) {
            if (this.getComponent((int)i).getLocation().y < y) {
                y = this.getComponent((int)i).getLocation().y;
                ++rowsAboveCurrent;
            }
            --i;
        }
        y = this.getComponent((int)this.selectedIndex).getLocation().y;
        i = this.selectedIndex;
        while (i < this.getComponentCount()) {
            if (this.getComponent((int)i).getLocation().y > y) {
                y = this.getComponent((int)i).getLocation().y;
                ++rowsBelowCurrent;
            }
            ++i;
        }
        if (rowsAboveCurrent > 1) {
            i = 0;
            while (i < this.getComponentCount()) {
                c = this.getComponent(i);
                if (c.getLocation().y < currentY) {
                    c.setVisible(false);
                } else {
                    if (c.getLocation().y != currentY) break;
                    this.verticalShift = c.getLocation().y - 15;
                    c.setLocation(c.getLocation().x, 15);
                }
                ++i;
            }
            this.compressAbove = true;
        }
        if (rowsBelowCurrent > 1) {
            i = this.selectedIndex;
            while (i < this.getComponentCount()) {
                c = this.getComponent(i);
                if (c.getLocation().y > currentY) {
                    c.setVisible(false);
                }
                ++i;
            }
            this.compressBelow = true;
        } else {
            i = this.selectedIndex;
            while (i < this.getComponentCount()) {
                c = this.getComponent(i);
                if (c.getLocation().y > currentY) {
                    c.setLocation(c.getLocation().x, c.getLocation().y - this.verticalShift);
                }
                ++i;
            }
        }
        this.repaint();
    }

    private void fireItemEvent() {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(this.itemEvent);
        }
    }

    private void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof Tile) {
            this.selectTile((Tile)c);
        }
    }

    public Dimension getPreferredSize() {
        int n = this.getComponentCount();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < n) {
            Component c = this.getComponent(i);
            if (c.isVisible()) {
                int w = c.getLocation().x + c.getSize().width;
                int h = c.getLocation().y + c.getSize().height;
                if (w > width) {
                    width = w;
                }
                if (h > height) {
                    height = h;
                }
            }
            ++i;
        }
        if (this.compressBelow) {
            height += 15;
        }
        return new Dimension(width, height);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public Component getSelectedTile() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.getComponent(this.selectedIndex);
    }

    public Tile getTile(int index) {
        try {
            return (Tile)this.getComponent(index);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    public Component getVisibleComponentAt(int x, int y) {
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c.contains(x - c.getLocation().x, y - c.getLocation().y) && c.isVisible()) {
                return c;
            }
            ++i;
        }
        return this;
    }

    public boolean isCompressed() {
        return this.compressAbove || this.compressBelow;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.cursorVisible) {
            this.paintCursor(g);
        }
        if (Beans.isDesignTime()) {
            g.setColor(this.getBackground() != null ? this.getBackground().darker() : Color.lightGray);
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        if (this.compressAbove) {
            this.paintElipsis(g, (this.getSize().width - 21) / 2, 6);
        }
        if (this.compressBelow) {
            Component c = this.getComponent(this.selectedIndex);
            this.paintElipsis(g, (this.getSize().width - 21) / 2, c.getLocation().y + c.getSize().height + 8);
        }
    }

    private void paintCursor(Graphics g) {
        if (this.selectedIndex > -1) {
            Component c = this.getComponent(this.selectedIndex);
            int x = c.getLocation().x;
            int y = c.getLocation().y;
            int w = c.getSize().width;
            int h = c.getSize().height;
            g.setColor(this.cursorColor);
            g.drawRect(x, y, w - 1, h - 1);
            g.drawRect(x + 1, y + 1, w - 3, h - 3);
        }
    }

    private void paintElipsis(Graphics g, int x, int y) {
        g.setColor(Color.black);
        g.fillRect(x + 0, y, 3, 3);
        g.fillRect(x + 9, y, 3, 3);
        g.fillRect(x + 18, y, 3, 3);
    }

    public void removeItemListener(ItemListener l) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, l);
    }

    public void requestFocus() {
        if (this.selectedIndex != -1) {
            this.getComponent(this.selectedIndex).requestFocus();
        } else if (this.getComponentCount() > 0) {
            this.getComponent(0).requestFocus();
        }
    }

    public void selectNone() {
        this.selectedIndex = -1;
        this.fireItemEvent();
    }

    public void selectTile(int index) {
        if (index == this.selectedIndex) {
            return;
        }
        if (this.getTile(index) != null) {
            this.selectedIndex = index;
            this.fireItemEvent();
        }
    }

    public void selectTile(Tile t) {
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.getComponent(i) == t) {
                this.selectTile(i);
                break;
            }
            ++i;
        }
    }

    public void setEnabled(boolean e) {
        super.setEnabled(e);
        int i = 0;
        while (i < this.getComponentCount()) {
            this.getComponent(i).setEnabled(e);
            ++i;
        }
    }

    public void showCursor(boolean s) {
        if (this.cursorVisible != s) {
            this.cursorVisible = s;
            this.repaint();
        }
    }

    public void uncompress() {
        if (this.isCompressed()) {
            int i = 0;
            while (i < this.getComponentCount()) {
                Component c = this.getComponent(i);
                if (c.isVisible() && this.verticalShift > 0) {
                    c.setLocation(c.getLocation().x, c.getLocation().y + this.verticalShift);
                } else {
                    c.setVisible(true);
                }
                ++i;
            }
            this.compressAbove = false;
            this.compressBelow = false;
            this.verticalShift = 0;
            this.repaint();
        }
    }

    static void access$focusGained(Tiler tiler, FocusEvent focusEvent) {
        tiler.focusGained(focusEvent);
    }
}

