/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.SubFrameViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;

public class AuViewerSdh
extends SubFrameViewer {
    private static final String[] errorTableCaptions = new String[]{"C2 uninitialised", "AIS", "LOP", "B3", "RDI", "REI"};
    private static final int[][] errorTableConstraints = new int[][]{{5}, {1, 1, 1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] c2Strings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(0, "Unequipped"), new LayerDecoder.KeyValuePair(1, "Equipped"), new LayerDecoder.KeyValuePair(2, "TUG"), new LayerDecoder.KeyValuePair(3, "Locked TU"), new LayerDecoder.KeyValuePair(4, "Async 34/45M"), new LayerDecoder.KeyValuePair(18, "Async 140M"), new LayerDecoder.KeyValuePair(19, "ATM"), new LayerDecoder.KeyValuePair(20, "MAN/DQDB"), new LayerDecoder.KeyValuePair(21, "FDDI"), new LayerDecoder.KeyValuePair(22, "HDLC/PPP"), new LayerDecoder.KeyValuePair(23, "SDL1"), new LayerDecoder.KeyValuePair(24, "HDLC/LAP-S"), new LayerDecoder.KeyValuePair(25, "SDL2"), new LayerDecoder.KeyValuePair(26, "10GbE"), new LayerDecoder.KeyValuePair(27, "GFP"), new LayerDecoder.KeyValuePair(207, "HDLC/PPP(old)"), new LayerDecoder.KeyValuePair(225, "Reserved"), new LayerDecoder.KeyValuePair(226, "Reserved"), new LayerDecoder.KeyValuePair(227, "Reserved"), new LayerDecoder.KeyValuePair(228, "Reserved"), new LayerDecoder.KeyValuePair(229, "Reserved"), new LayerDecoder.KeyValuePair(230, "Reserved"), new LayerDecoder.KeyValuePair(231, "Reserved"), new LayerDecoder.KeyValuePair(232, "Reserved"), new LayerDecoder.KeyValuePair(233, "Reserved"), new LayerDecoder.KeyValuePair(234, "Reserved"), new LayerDecoder.KeyValuePair(235, "Reserved"), new LayerDecoder.KeyValuePair(236, "Reserved"), new LayerDecoder.KeyValuePair(237, "Reserved"), new LayerDecoder.KeyValuePair(238, "Reserved"), new LayerDecoder.KeyValuePair(239, "Reserved"), new LayerDecoder.KeyValuePair(240, "Reserved"), new LayerDecoder.KeyValuePair(241, "Reserved"), new LayerDecoder.KeyValuePair(242, "Reserved"), new LayerDecoder.KeyValuePair(243, "Reserved"), new LayerDecoder.KeyValuePair(244, "Reserved"), new LayerDecoder.KeyValuePair(245, "Reserved"), new LayerDecoder.KeyValuePair(246, "Reserved"), new LayerDecoder.KeyValuePair(247, "Reserved"), new LayerDecoder.KeyValuePair(248, "Reserved"), new LayerDecoder.KeyValuePair(249, "Reserved"), new LayerDecoder.KeyValuePair(250, "Reserved"), new LayerDecoder.KeyValuePair(251, "Reserved"), new LayerDecoder.KeyValuePair(252, "Reserved"), new LayerDecoder.KeyValuePair(254, "O.181"), new LayerDecoder.KeyValuePair(255, "VC-AIS")};
    private static final int[] c2IndicatesPdh = new int[]{4, 18};
    private boolean containsPdh = false;

    public boolean containsPdh() {
        return this.containsPdh;
    }

    public String decode(byte value, ChannelStatus c) {
        this.containsPdh = false;
        int i = 0;
        while (i < c2IndicatesPdh.length) {
            if (c2IndicatesPdh[i] == value) {
                this.containsPdh = true;
                break;
            }
            ++i;
        }
        return AuViewerSdh.translateC2Byte(value);
    }

    public String getChannelCaption(ChannelStatus s) {
        if (s.size == 1) {
            return "AU-3";
        }
        if (s.size == 3) {
            return "AU-4";
        }
        return "AU-4-" + s.size / 3 + "c";
    }

    public String getChannelIndex(ChannelStatus c, int totalSize) {
        String s = "";
        int layerSize = totalSize;
        int layerIndex = -1;
        int start = c.start;
        short size = c.size;
        int[] layerSizes = new int[]{1, 3, 12, 48, 192, 768};
        int i = 0;
        while (i < layerSizes.length) {
            if (layerSize == layerSizes[i]) {
                layerIndex = i;
                break;
            }
            ++i;
        }
        if (layerIndex <= 0 || size >= totalSize) {
            s = "";
        } else {
            --layerIndex;
            int currentDigit = 0;
            while (layerIndex >= 0) {
                layerSize = layerSizes[layerIndex];
                currentDigit = start / layerSize + 1;
                start %= layerSize;
                if (size == layerSize) {
                    s = String.valueOf(s) + currentDigit;
                    break;
                }
                if (size > layerSize) {
                    s = String.valueOf(s) + "*";
                    break;
                }
                s = String.valueOf(s) + currentDigit + ", ";
                --layerIndex;
            }
        }
        return s;
    }

    public String[] getErrorTableCaptions() {
        return errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 192;
    }

    public String getShortChannelCaption(ChannelStatus s) {
        if (s.size == 1) {
            return "3";
        }
        if (s.size == 3) {
            return "4";
        }
        return "" + s.size / 3 + "c";
    }

    public String getStructureSummary(ChannelStatus[] s) {
        if (s == null) {
            return "";
        }
        boolean uniform = true;
        boolean foreignPresent = false;
        boolean currentForeign = false;
        int i = 0;
        while (i < s.length) {
            if (i == 0) {
                currentForeign = s[i].foreign;
            }
            if (s[i].foreign) {
                foreignPresent = true;
            }
            if (s[i].foreign != currentForeign) {
                uniform = false;
            }
            ++i;
        }
        if (!uniform) {
            return "MIXED";
        }
        if (foreignPresent) {
            return "SONET";
        }
        return "SDH";
    }

    public static String translateC2Byte(byte value) {
        String c2 = LayerDecoder.getString(c2Strings, value);
        if (c2 == null) {
            c2 = LayerDecoder.getUnknownString(value);
        }
        return "C2:" + c2;
    }
}

