/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.SubFrameViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;

public class AuViewerSonet
extends SubFrameViewer {
    private static final String[] errorTableCaptions = new String[]{"C2 uninitialised", "AIS", "LOP", "CVP", "RDI", "REI"};
    private static final String[] sdhStyleErrorTableCaptions = new String[]{"C2 uninitialised", "AIS", "LOP", "B3", "RDI", "REI"};
    private static final int[][] errorTableConstraints = new int[][]{{5}, {1, 1, 1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] c2Strings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(0, "Unequipped"), new LayerDecoder.KeyValuePair(1, "Equipped"), new LayerDecoder.KeyValuePair(2, "VT STS-1"), new LayerDecoder.KeyValuePair(3, "VT Locked"), new LayerDecoder.KeyValuePair(4, "Async DS3"), new LayerDecoder.KeyValuePair(18, "Async DS4NA"), new LayerDecoder.KeyValuePair(19, "ATM"), new LayerDecoder.KeyValuePair(20, "DQDB"), new LayerDecoder.KeyValuePair(21, "FDDI"), new LayerDecoder.KeyValuePair(22, "HDLC"), new LayerDecoder.KeyValuePair(24, "HDLC/LAP-S"), new LayerDecoder.KeyValuePair(26, "10GbE"), new LayerDecoder.KeyValuePair(27, "GFP"), new LayerDecoder.KeyValuePair(225, "1 VT Defects"), new LayerDecoder.KeyValuePair(226, "2 VT Defects"), new LayerDecoder.KeyValuePair(227, "3 VT Defects"), new LayerDecoder.KeyValuePair(228, "4 VT Defects"), new LayerDecoder.KeyValuePair(229, "5 VT Defects"), new LayerDecoder.KeyValuePair(230, "6 VT Defects"), new LayerDecoder.KeyValuePair(231, "7 VT Defects"), new LayerDecoder.KeyValuePair(232, "8 VT Defects"), new LayerDecoder.KeyValuePair(233, "9 VT Defects"), new LayerDecoder.KeyValuePair(234, "10 VT Defects"), new LayerDecoder.KeyValuePair(235, "11 VT Defects"), new LayerDecoder.KeyValuePair(236, "12 VT Defects"), new LayerDecoder.KeyValuePair(237, "13 VT Defects"), new LayerDecoder.KeyValuePair(238, "14 VT Defects"), new LayerDecoder.KeyValuePair(239, "15 VT Defects"), new LayerDecoder.KeyValuePair(240, "16 VT Defects"), new LayerDecoder.KeyValuePair(241, "17 VT Defects"), new LayerDecoder.KeyValuePair(242, "18 VT Defects"), new LayerDecoder.KeyValuePair(243, "19 VT Defects"), new LayerDecoder.KeyValuePair(244, "20 VT Defects"), new LayerDecoder.KeyValuePair(245, "21 VT Defects"), new LayerDecoder.KeyValuePair(246, "22 VT Defects"), new LayerDecoder.KeyValuePair(247, "23 VT Defects"), new LayerDecoder.KeyValuePair(248, "24 VT Defects"), new LayerDecoder.KeyValuePair(249, "25 VT Defects"), new LayerDecoder.KeyValuePair(250, "26 VT Defects"), new LayerDecoder.KeyValuePair(251, "27 VT Defects"), new LayerDecoder.KeyValuePair(252, "28 VT Defects"), new LayerDecoder.KeyValuePair(254, "O.181")};
    private static final int[] c2IndicatesPdh = new int[]{4, 18};
    private boolean containsPdh = false;

    public boolean containsPdh() {
        return this.containsPdh;
    }

    public String decode(byte value, ChannelStatus c) {
        this.containsPdh = false;
        int i = 0;
        while (i < c2IndicatesPdh.length) {
            if (c2IndicatesPdh[i] == value) {
                this.containsPdh = true;
                break;
            }
            ++i;
        }
        return AuViewerSonet.translateC2Byte(value);
    }

    public String getChannelCaption(ChannelStatus s) {
        return "STS-" + s.size + (s.size > 1 ? "c" : "");
    }

    public String getChannelIndex(ChannelStatus s, int totalSize) {
        if (Server.instance().context().isOldSonetNumbering()) {
            return "" + (s.start + 1);
        }
        if (totalSize > 3) {
            return "" + (s.start / 3 + 1) + ", " + (s.start % 3 + 1);
        }
        return "" + (s.start % 3 + 1);
    }

    public String[] getErrorTableCaptions() {
        boolean sdhStyle = Server.instance().context().isSdhStyleSonet();
        return sdhStyle ? sdhStyleErrorTableCaptions : errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 192;
    }

    public String getShortChannelCaption(ChannelStatus s) {
        return "" + s.size + (s.size > 1 ? "c" : "");
    }

    public String getStructureSummary(ChannelStatus[] s) {
        if (s == null) {
            return "";
        }
        boolean uniform = true;
        boolean foreignPresent = false;
        boolean currentForeign = false;
        int i = 0;
        while (i < s.length) {
            if (i == 0) {
                currentForeign = s[i].foreign;
            }
            if (s[i].foreign) {
                foreignPresent = true;
            }
            if (s[i].foreign != currentForeign) {
                uniform = false;
            }
            ++i;
        }
        if (!uniform) {
            return "MIXED";
        }
        if (foreignPresent) {
            return "SDH";
        }
        return "SONET";
    }

    public static String translateC2Byte(byte value) {
        String c2 = LayerDecoder.getString(c2Strings, value);
        if (c2 == null) {
            c2 = LayerDecoder.getUnknownString(value);
        }
        return "C2:" + c2;
    }
}

