/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.PdhViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;

public class Ds1Viewer
extends PdhViewer {
    private static final String[] errorTableCaptions = new String[]{"Framing Type", "AIS", "OOF", "RAI"};
    private static final int[][] errorTableConstraints = new int[][]{{3}, {1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] framingTypeStrings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(0, "Unframed"), new LayerDecoder.KeyValuePair(1, "D4"), new LayerDecoder.KeyValuePair(2, "ESF"), new LayerDecoder.KeyValuePair(3, "SLC-96"), new LayerDecoder.KeyValuePair(4, "No F-Bit"), new LayerDecoder.KeyValuePair(99, "Unknown")};

    public String decode(byte value, ChannelStatus c) {
        String framingType = LayerDecoder.getString(framingTypeStrings, value);
        if (framingType == null) {
            framingType = LayerDecoder.getUnknownString(value);
        }
        return framingType;
    }

    public String getChannelCaption(ChannelStatus s) {
        return "DS1";
    }

    public String[] getErrorTableCaptions() {
        return errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 4;
    }
}

