/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.PdhViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;

public class E1Viewer
extends PdhViewer {
    private static final String[] errorTableCaptions = new String[]{"Framing Type", "AIS", "LOF", "RAI", "CAS", "CRC", "RMF"};
    private static final int[][] errorTableConstraints = new int[][]{{3}, {1, 1, 1}, {1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] framingTypeStrings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(0, "Unframed"), new LayerDecoder.KeyValuePair(1, "PCM30"), new LayerDecoder.KeyValuePair(2, "PCM31"), new LayerDecoder.KeyValuePair(3, "PCM30-CRC"), new LayerDecoder.KeyValuePair(4, "PCM31-CRC"), new LayerDecoder.KeyValuePair(99, "Unknown")};

    public String decode(byte value, ChannelStatus c) {
        String framingType = LayerDecoder.getString(framingTypeStrings, value);
        if (framingType == null) {
            framingType = LayerDecoder.getUnknownString(value);
        }
        return framingType;
    }

    public String getChannelCaption(ChannelStatus s) {
        return "2Mb/s";
    }

    public String[] getErrorTableCaptions() {
        return errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 4;
    }
}

