/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;

public class FrameViewerSdh
extends LayerDecoder {
    private transient String payload = "";
    private static final String[] errorTableCaptions = new String[]{"S1 uninitialised", "LOF", "AIS", "B1", "B2", "RDI", "REI"};
    private static final int[][] errorTableConstraints = new int[][]{{3}, {1, 1, 1}, {1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] sizeCaptions = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(1, "STM-0"), new LayerDecoder.KeyValuePair(3, "STM-1"), new LayerDecoder.KeyValuePair(12, "STM-4"), new LayerDecoder.KeyValuePair(48, "STM-16"), new LayerDecoder.KeyValuePair(192, "STM-64"), new LayerDecoder.KeyValuePair(768, "STM-256")};
    private static final LayerDecoder.KeyValuePair[] s1Strings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(0, "Unknown"), new LayerDecoder.KeyValuePair(1, "Reserved"), new LayerDecoder.KeyValuePair(2, "G.811"), new LayerDecoder.KeyValuePair(3, "Reserved"), new LayerDecoder.KeyValuePair(4, "SSU-A"), new LayerDecoder.KeyValuePair(5, "Reserved"), new LayerDecoder.KeyValuePair(6, "Reserved"), new LayerDecoder.KeyValuePair(7, "Reserved"), new LayerDecoder.KeyValuePair(8, "SSU-B"), new LayerDecoder.KeyValuePair(9, "Reserved"), new LayerDecoder.KeyValuePair(10, "Reserved"), new LayerDecoder.KeyValuePair(11, "G.813 Option 1"), new LayerDecoder.KeyValuePair(12, "Reserved"), new LayerDecoder.KeyValuePair(13, "Reserved"), new LayerDecoder.KeyValuePair(14, "Reserved"), new LayerDecoder.KeyValuePair(15, "Do Not Use")};

    public String decode(byte value, ChannelStatus c) {
        return FrameViewerSdh.translateS1Byte(value);
    }

    public String getChannelCaption(ChannelStatus s) {
        String caption = LayerDecoder.getString(sizeCaptions, s.size);
        return caption == null ? "" : caption;
    }

    public String getChannelIdentifier(ChannelStatus c, int totalSize) {
        return this.payload;
    }

    public String getChannelIndex(ChannelStatus s, int totalSize) {
        return "";
    }

    public String[] getErrorTableCaptions() {
        return errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 1;
    }

    public void setPayloadSummary(String s) {
        if (Server.instance().context().isPayloadIndicatorVisible()) {
            this.payload = s;
        }
    }

    public static String translateS1Byte(byte value) {
        String s1 = LayerDecoder.getString(s1Strings, value);
        if (s1 == null) {
            s1 = LayerDecoder.getUnknownString(value);
        }
        return "S1:" + s1;
    }
}

