/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;

public class FrameViewerSonet
extends LayerDecoder {
    private transient String payload = "";
    private static final String[] errorTableCaptions = new String[]{"S1 uninitialised", "LOF", "AIS", "CVS", "CVL", "RDI", "REI"};
    private static final String[] sdhStyleErrorTableCaptions = new String[]{"S1 uninitialised", "LOF", "AIS", "B1", "B2", "RDI", "REI"};
    private static final int[][] errorTableConstraints = new int[][]{{3}, {1, 1, 1}, {1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] sizeCaptionsOptical = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(1, "OC-1"), new LayerDecoder.KeyValuePair(3, "OC-3"), new LayerDecoder.KeyValuePair(12, "OC-12"), new LayerDecoder.KeyValuePair(48, "OC-48"), new LayerDecoder.KeyValuePair(192, "OC-192"), new LayerDecoder.KeyValuePair(768, "OC-768")};
    private static final LayerDecoder.KeyValuePair[] sizeCaptionsElectrical = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(1, "STS-1"), new LayerDecoder.KeyValuePair(3, "STS-3")};
    private static final LayerDecoder.KeyValuePair[] s1Strings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(0, "Unknown"), new LayerDecoder.KeyValuePair(1, "Stratum 1"), new LayerDecoder.KeyValuePair(2, "Reserved"), new LayerDecoder.KeyValuePair(3, "Reserved"), new LayerDecoder.KeyValuePair(4, "Transit Node Clock"), new LayerDecoder.KeyValuePair(5, "Reserved"), new LayerDecoder.KeyValuePair(6, "Reserved"), new LayerDecoder.KeyValuePair(7, "Stratum 2"), new LayerDecoder.KeyValuePair(8, "Reserved"), new LayerDecoder.KeyValuePair(9, "Reserved"), new LayerDecoder.KeyValuePair(10, "Stratum 3"), new LayerDecoder.KeyValuePair(11, "Reserved"), new LayerDecoder.KeyValuePair(12, "SONET Minimum"), new LayerDecoder.KeyValuePair(13, "Stratum 3E"), new LayerDecoder.KeyValuePair(14, "Operator Defined"), new LayerDecoder.KeyValuePair(15, "Do Not Use")};

    public String decode(byte value, ChannelStatus c) {
        return FrameViewerSonet.translateS1Byte(value);
    }

    public String getChannelCaption(ChannelStatus s) {
        String caption = Server.instance().context().isOpticalInterface() ? LayerDecoder.getString(sizeCaptionsOptical, s.size) : LayerDecoder.getString(sizeCaptionsElectrical, s.size);
        return caption == null ? "" : caption;
    }

    public String getChannelIdentifier(ChannelStatus c, int totalSize) {
        return this.payload;
    }

    public String getChannelIndex(ChannelStatus s, int totalSize) {
        return "";
    }

    public String[] getErrorTableCaptions() {
        boolean sdhStyle = Server.instance().context().isSdhStyleSonet();
        return sdhStyle ? sdhStyleErrorTableCaptions : errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 1;
    }

    public void setPayloadSummary(String s) {
        if (Server.instance().context().isPayloadIndicatorVisible()) {
            this.payload = s;
        }
    }

    public static String translateS1Byte(byte value) {
        String s1 = LayerDecoder.getString(s1Strings, value);
        if (s1 == null) {
            s1 = LayerDecoder.getUnknownString(value);
        }
        return "S1:" + s1;
    }
}

