/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.DecoderFactory;
import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.AuViewerSdh;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.AuViewerSonet;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.Ds1Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.Ds2Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.Ds3Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.E1IntoDs3Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.E1Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.E2Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.E3Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.E4Viewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.FrameViewerSdh;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.FrameViewerSonet;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.TuViewerSdh;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.TuViewerSonet;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;

public class LynxLayerFactory
implements DecoderFactory {
    private static final String FRAME_VIEWER = "FrameAnalyser";
    private static final String AU_VIEWER = "AU_Analyser";
    private static final String TU_VIEWER = "TU_Analyser";
    private static final String E1_DS3_VIEWER = "E1IntoDS3Analyser";
    private static final String E1_VIEWER = "E1Analyser";
    private static final String E2_VIEWER = "E2Analyser";
    private static final String E3_VIEWER = "E3Analyser";
    private static final String E4_VIEWER = "E4Analyser";
    private static final String DS1_VIEWER = "DS1Analyser";
    private static final String DS2_VIEWER = "DS2Analyser";
    private static final String DS3_VIEWER = "DS3Analyser";

    public LayerDecoder createDecoder(String typename) {
        boolean sdh = Server.instance().context().isSdhPreferred();
        if (typename.equalsIgnoreCase(FRAME_VIEWER)) {
            if (sdh) {
                return new FrameViewerSdh();
            }
            return new FrameViewerSonet();
        }
        if (typename.equalsIgnoreCase(AU_VIEWER)) {
            if (sdh) {
                return new AuViewerSdh();
            }
            return new AuViewerSonet();
        }
        if (typename.equalsIgnoreCase(TU_VIEWER)) {
            if (sdh) {
                return new TuViewerSdh();
            }
            return new TuViewerSonet();
        }
        if (typename.equalsIgnoreCase(E1_VIEWER)) {
            return new E1Viewer();
        }
        if (typename.equalsIgnoreCase(E1_DS3_VIEWER)) {
            return new E1IntoDs3Viewer();
        }
        if (typename.equalsIgnoreCase(E2_VIEWER)) {
            return new E2Viewer();
        }
        if (typename.equalsIgnoreCase(E3_VIEWER)) {
            return new E3Viewer();
        }
        if (typename.equalsIgnoreCase(E4_VIEWER)) {
            return new E4Viewer();
        }
        if (typename.equalsIgnoreCase(DS1_VIEWER)) {
            return new Ds1Viewer();
        }
        if (typename.equalsIgnoreCase(DS2_VIEWER)) {
            return new Ds2Viewer();
        }
        if (typename.equalsIgnoreCase(DS3_VIEWER)) {
            return new Ds3Viewer();
        }
        return null;
    }
}

