/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.lynx;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.AuViewerSdh;
import com.agilent.tntd.eclipse.thinclient.signalwizard.lynx.SubFrameViewer;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;

public class TuViewerSonet
extends SubFrameViewer {
    private static final String[] errorTableCaptions = new String[]{"V5 uninitialised", "AIS", "LOP", "LOM", "CVV", "RDI", "REI", "RFI"};
    private static final String[] sdhStyleErrorTableCaptions = new String[]{"V5 uninitialised", "AIS", "LOP", "LOM", "BIP", "RDI", "REI", "RFI"};
    private static final int[][] errorTableConstraints = new int[][]{{4}, {1, 1, 1, 1}, {1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] v5Strings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(0, "Unequipped"), new LayerDecoder.KeyValuePair(1, "Non-specific"), new LayerDecoder.KeyValuePair(2, "Async"), new LayerDecoder.KeyValuePair(3, "Bit-sync"), new LayerDecoder.KeyValuePair(4, "Byte-sync"), new LayerDecoder.KeyValuePair(5, "Undefined"), new LayerDecoder.KeyValuePair(6, "Undefined"), new LayerDecoder.KeyValuePair(7, "Undefined"), new LayerDecoder.KeyValuePair(8, "Undefined")};

    public boolean containsPdh() {
        return true;
    }

    public String decode(byte value, ChannelStatus c) {
        if (c.size == 84) {
            return AuViewerSdh.translateC2Byte(value);
        }
        return TuViewerSonet.translateV5Byte(value);
    }

    public String getChannelCaption(ChannelStatus s) {
        switch (s.size) {
            case 3: {
                return "VT1.5";
            }
            case 4: {
                return "VT2";
            }
            case 12: {
                return "VT6";
            }
            case 84: {
                return "TU-3";
            }
        }
        return "????";
    }

    public String getChannelIndex(ChannelStatus c, int totalSize) {
        String s = "";
        int layerSize = totalSize;
        int layerIndex = -1;
        int start = c.start;
        short size = c.size;
        int[] layerSizesFromTu11 = new int[]{3, 12, 84, 252};
        int[] layerSizesFromTu12 = new int[]{4, 12, 84, 252};
        int[] layerSizes = c.size == 3 ? layerSizesFromTu11 : layerSizesFromTu12;
        int i = 0;
        while (i < layerSizes.length) {
            if (layerSize == layerSizes[i]) {
                layerIndex = i;
                break;
            }
            ++i;
        }
        if (layerIndex <= 0 || size >= totalSize) {
            s = "";
        } else {
            --layerIndex;
            int currentDigit = 0;
            while (layerIndex >= 0) {
                layerSize = layerSizes[layerIndex];
                currentDigit = start / layerSize + 1;
                start %= layerSize;
                if (size == layerSize) {
                    s = String.valueOf(s) + currentDigit;
                    break;
                }
                if (size > layerSize) {
                    s = String.valueOf(s) + "*";
                    break;
                }
                s = String.valueOf(s) + currentDigit + ", ";
                --layerIndex;
            }
        }
        return s;
    }

    public String[] getErrorTableCaptions() {
        boolean sdhStyle = Server.instance().context().isSdhStyleSonet();
        return sdhStyle ? sdhStyleErrorTableCaptions : errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 84;
    }

    public String getShortChannelCaption(ChannelStatus s) {
        switch (s.size) {
            case 3: {
                return "1.5";
            }
            case 4: {
                return "2";
            }
            case 12: {
                return "6";
            }
            case 84: {
                return "TU-3";
            }
        }
        return "????";
    }

    public static String translateV5Byte(byte value) {
        String v5 = LayerDecoder.getString(v5Strings, value);
        if (v5 == null) {
            v5 = LayerDecoder.getUnknownString(value);
        }
        return "V5:" + v5;
    }
}

