/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.panther;

import com.agilent.tntd.eclipse.thinclient.signalwizard.clientmodel.LayerDecoder;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;

public class OtnViewer
extends LayerDecoder {
    private static final String[] errorTableCaptions = new String[]{"PT uninitialised", "OTU", "ODU", "CFec", "UFec"};
    private static final int[][] errorTableConstraints = new int[][]{{4}, {1, 1, 1, 1}};
    private static final LayerDecoder.KeyValuePair[] ptStrings = new LayerDecoder.KeyValuePair[]{new LayerDecoder.KeyValuePair(1, "Exp. Mapping"), new LayerDecoder.KeyValuePair(2, "Async STM/SONET"), new LayerDecoder.KeyValuePair(3, "Sync STM/SONET"), new LayerDecoder.KeyValuePair(4, "ATM"), new LayerDecoder.KeyValuePair(5, "GFP"), new LayerDecoder.KeyValuePair(16, "Bit stream"), new LayerDecoder.KeyValuePair(17, "Bit stream"), new LayerDecoder.KeyValuePair(253, "NULL Client"), new LayerDecoder.KeyValuePair(254, "Test Signal")};

    public String decode(byte value, ChannelStatus c) {
        String pt = LayerDecoder.getString(ptStrings, value);
        if (pt == null) {
            pt = LayerDecoder.getUnknownString(value);
        }
        return "PT:" + pt;
    }

    public String getChannelCaption(ChannelStatus s) {
        return "OTU" + s.size;
    }

    public String getChannelIdentifier(ChannelStatus c, int totalSize) {
        return "";
    }

    public String[] getErrorTableCaptions() {
        return errorTableCaptions;
    }

    public int[][] getErrorTableConstraints() {
        return errorTableConstraints;
    }

    public int getMaxNumTiles() {
        return 1;
    }
}

