/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.rmi;

import com.agilent.tntd.eclipse.client.appmodel.ApplicationManager;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObject;
import com.agilent.tntd.eclipse.client.appmodel.ApplicationObjectObserver;
import com.agilent.tntd.eclipse.common.data.ApplicationData;
import com.agilent.tntd.eclipse.common.data.ApplicationDataReceiver;
import com.agilent.tntd.eclipse.common.data.ApplicationDataSender;
import com.agilent.tntd.eclipse.common.data.ApplicationMetaData;
import com.agilent.tntd.eclipse.common.data.BadApplicationDataReceiverException;
import com.agilent.tntd.eclipse.common.data.CcConnectedComponent;
import com.agilent.tntd.eclipse.common.util.ErrorReporter;
import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericData;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericDataReceiver;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesWriter;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.UnknownMethodException;
import com.sun.java.util.collections.HashMap;
import java.io.IOException;

public class RmiDispatcher
implements CcConnectedComponent,
ApplicationGenericDataReceiver {
    private String variable = null;
    private ApplicationObject ao = null;
    private HashMap idToObjectMap = new HashMap();
    private HashMap objectToIdMap = new HashMap();

    public RmiDispatcher(String variableName) {
        this.variable = variableName;
    }

    public void acknowledgeInitialisation(ApplicationObject anAO, ErrorReporter aReport) {
        switch (aReport.getErrorStatus()) {
            case 1: {
                EventLog.instance().log("Could not establish connection to server: " + anAO.toString() + " failed to initialise");
                this.ao = null;
                break;
            }
            case 3: {
                EventLog.instance().log("Could not establish connection to server: " + anAO.toString() + " requested from unknown domain");
                this.ao = null;
                break;
            }
            case 0: 
            case 2: {
                if (!anAO.getName().equals(this.variable)) break;
                this.ao = anAO;
            }
        }
    }

    public ApplicationGenericMetaData beginRemoteCall(RmiProxy sender, short methodId) {
        ApplicationGenericMetaData meta = null;
        short objectId = this.getProxyId(sender);
        if (objectId == 0) {
            return null;
        }
        try {
            meta = new ApplicationGenericMetaData();
            PrimitiveTypesWriter writer = meta.getPrimitiveTypesWriter();
            writer.write(objectId);
            writer.write(methodId);
        }
        catch (IOException iOException) {
            meta = null;
        }
        return meta;
    }

    public void callRemoteMethod(RmiProxy sender, short methodId) {
        ApplicationGenericMetaData meta = this.beginRemoteCall(sender, methodId);
        this.concludeRemoteCall(meta);
    }

    public void concludeRemoteCall(ApplicationGenericMetaData meta) {
        if (meta != null && this.ao != null) {
            meta.completedMetaDataInitialisation();
            this.ao.asyncQuery((ApplicationMetaData)meta, (ApplicationObjectObserver)this);
        }
    }

    public synchronized boolean contains(short id) {
        return this.idToObjectMap.containsKey((Object)new Short(id));
    }

    public void finishInitialise() {
        ApplicationManager.instance().request("ISS", 0, this.variable, (ApplicationObjectObserver)this);
    }

    private short getProxyId(RmiProxy p) {
        Short i = (Short)this.objectToIdMap.get((Object)p);
        if (i != null) {
            return i;
        }
        return 0;
    }

    private RmiProxy getReceiverFromId(short id) {
        Object o = this.idToObjectMap.get((Object)new Short(id));
        if (o != null && o instanceof RmiProxy) {
            return (RmiProxy)o;
        }
        return null;
    }

    public void receiveApplicationGenericData(ApplicationGenericData v, ApplicationDataSender s) {
        PrimitiveTypesReader reader = v.getPrimitiveTypesReader();
        short objectId = 0;
        RmiProxy receiver = null;
        try {
            objectId = reader.readShort();
            receiver = this.getReceiverFromId(objectId);
            if (receiver != null) {
                receiver.receive(reader);
            }
        }
        catch (IOException iOException) {
            if (objectId > 0) {
                EventLog.instance().log("IOException from " + receiver);
            }
        }
        catch (UnknownMethodException e) {
            EventLog.instance().log("Method " + e.getMethodId() + " not recognised by " + receiver);
        }
    }

    public synchronized boolean registerReceiver(RmiProxy p, short objectId) {
        if (this.idToObjectMap.containsKey((Object)new Short(objectId))) {
            EventLog.instance().log("receiver already exists for ID " + objectId);
            return false;
        }
        this.idToObjectMap.put((Object)new Short(objectId), (Object)p);
        this.objectToIdMap.put((Object)p, (Object)new Short(objectId));
        return true;
    }

    public void trapTransientError(boolean isInError) {
    }

    public void unregister() {
        if (this.ao != null) {
            this.ao.unregister((ApplicationObjectObserver)this);
        }
        this.ao = null;
        this.idToObjectMap.clear();
        this.objectToIdMap.clear();
    }

    public synchronized void unregisterReceiver(RmiProxy r) {
        short id = this.getProxyId(r);
        this.idToObjectMap.remove((Object)new Short(id));
        this.objectToIdMap.remove((Object)r);
    }

    public void update(ApplicationData v, ApplicationObject o) {
        try {
            if (v != null) {
                v.receivedBy((ApplicationDataReceiver)this, (ApplicationDataSender)o);
            }
        }
        catch (BadApplicationDataReceiverException badApplicationDataReceiverException) {
            EventLog.instance().log("RmiDispatcher cannot receive " + v.toString() + " from " + o.toString());
        }
    }
}

