/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel;

import com.agilent.tntd.eclipse.common.util.EventLog;
import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiDispatcher;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.UnknownMethodException;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.AnalyserUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ChannelStatus;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.StructureScopeProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.util.EventThrottle;
import com.agilent.tntd.eclipse.thinclient.signalwizard.util.ThrottleManager;
import java.io.IOException;

public class AnalyserProxy
extends RmiProxy
implements EventThrottle.Listener {
    private int id = 0;
    private int numTiles = 0;
    private int currentTile = 0;
    private AnalyserProxy parent = null;
    private int indexInParent = -1;
    private boolean viewerAdded = false;
    private boolean unregistered = false;
    private boolean valid = true;
    private StructureScopeProxy structureScope = null;
    private static final int eventsPerSecond = 4;
    private transient EventThrottle largeChangeThrottle = ThrottleManager.createThrottle(this, 4);
    private static final short GET_TYPE = 0;
    private static final short GET_NUM_TILES = 1;
    private static final short GET_CHILD_ANALYSER = 2;
    private static final short UNREGISTER = 3;
    private static final short GET_STATUS_FOR_TILES = 4;
    private static final short GET_TOTAL_STATUS_FOR_TILES = 5;
    private static final short GET_ALL_UP_STATUS_FOR_TILES = 6;
    private static final short GET_CURRENT_TILE_DETAILED_STATUS = 7;
    private static final short GET_CURRENT_TILE_TRACE_MESSAGE = 8;
    private static final short HAS_STRUCTURE_CHANGE = 9;
    private static final short SET_CURRENT_TILE = 10;
    private static final short SET_LARGE_CHANGE_THRESHOLD = 11;
    private static final short SET_AUTO_ACKNOWLEDGE_STATE = 12;
    private static final short ACKNOWLEDGE_STRUCTURE_CHANGE = 13;
    private static final short ANALYSER_SPECIAL = 14;
    private static final short NOTIFY_LARGE_CHANGE = 15;
    private static final short NOTIFY_SMALL_CHANGE = 16;
    private static final short NOTIFY_DETAIL_CHANGE = 17;
    private static final short NOTIFY_MESSAGE_CHANGE = 18;
    private static final short NOTIFY_STRUCUTRE_CHANGE = 19;
    private static final short NOTIFY_SPECIAL = 20;
    private AnalyserUI ui = null;
    private transient AnalyserProxy[] children = null;

    public AnalyserProxy(RmiDispatcher d, StructureScopeProxy s, int id, AnalyserProxy parent, int indexInParent) {
        super(d);
        this.structureScope = s;
        this.id = id;
        this.parent = parent;
        this.indexInParent = indexInParent;
    }

    public void acknowledgeStructureChange() {
        this.valid = false;
        this.callRemoteMethod(this, (short)13);
    }

    public void addChild(AnalyserProxy child, int index) {
        this.children[index] = child;
    }

    private void addUI() {
        AnalyserUI p = this.parent == null ? null : this.parent.getUI();
        this.structureScope.addAnalyserUI(this.ui, p, this.indexInParent);
        this.viewerAdded = true;
    }

    public void cleanup() {
        ThrottleManager.removeThrottle(this.largeChangeThrottle);
    }

    public void detatchFromParent() {
        if (this.parent != null) {
            this.parent.setCurrentTileSummary("");
            this.parent.removeChild(this.indexInParent);
            this.parent = null;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }

    public AnalyserProxy getParent() {
        return this.parent;
    }

    public AnalyserUI getUI() {
        return this.ui;
    }

    public void initialise() {
        this.requestType();
    }

    public void notifyEvent(EventThrottle t) {
        if (t == this.largeChangeThrottle) {
            this.requestStatusForTiles(0, this.numTiles - 1);
        }
    }

    public void receive(PrimitiveTypesReader r) throws IOException, UnknownMethodException {
        short methodId = r.readShort();
        switch (methodId) {
            case 0: {
                String type = r.readString();
                if (!this.valid && this.ui != null) break;
                this.ui = this.structureScope.createAnalyserUI(this);
                if (this.ui == null) {
                    EventLog.instance().log("Could not create viewer for analyser of type \"" + type + "\"");
                    this.unregister();
                    break;
                }
                this.ui.setType(type);
                break;
            }
            case 1: {
                this.numTiles = r.readInt();
                if (this.ui == null) break;
                if (this.numTiles < 1 || this.numTiles > this.ui.getMaxNumTiles()) {
                    EventLog.instance().log("Incorrect number of tiles reported (" + this.numTiles + ", expected between 1 and " + this.ui.getMaxNumTiles() + ")");
                    this.unregister();
                    break;
                }
                if (!this.valid) break;
                this.children = new AnalyserProxy[this.numTiles];
                int i = 0;
                while (i < this.numTiles) {
                    this.children[i] = null;
                    ++i;
                }
                this.requestTotalStatusForTiles(0, this.numTiles - 1);
                break;
            }
            case 2: {
                short objectId = r.readShort();
                short index = r.readShort();
                if (!this.valid) break;
                Server.instance().structureScope().createAnalyser(objectId, this, index);
                break;
            }
            case 4: {
                int n = r.readShort();
                if (n != this.numTiles) {
                    EventLog.instance().log("GET_STATUS_FOR_TILES: incorrect size received (" + n + ", expected " + this.numTiles + ")");
                    break;
                }
                ChannelStatus[] info = new ChannelStatus[n];
                int i = 0;
                while (i < n) {
                    short start = -1;
                    short size = -1;
                    byte status = r.readByte();
                    byte substructure = r.readByte();
                    byte foreign = r.readByte();
                    info[i] = new ChannelStatus(start, size, status, substructure != 0, foreign != 0);
                    ++i;
                }
                if (!this.valid) break;
                this.ui.setStatus(info);
                if (this.getParent() == null) break;
                this.getParent().setCurrentTileSummary(this.ui.getStructureSummary());
                break;
            }
            case 5: {
                int n = r.readShort();
                if (n != this.numTiles) {
                    EventLog.instance().log("GET_TOTAL_STATUS_FOR_TILES: incorrect size received (" + n + ", expected " + this.numTiles + ")");
                    break;
                }
                ChannelStatus[] info = new ChannelStatus[n];
                int i = 0;
                while (i < n) {
                    short start = r.readShort();
                    short size = r.readShort();
                    byte status = r.readByte();
                    byte substructure = r.readByte();
                    byte foreign = r.readByte();
                    info[i] = new ChannelStatus(start, size, status, substructure != 0, foreign != 0);
                    ++i;
                }
                if (!this.valid || this.ui == null) break;
                if (!this.viewerAdded) {
                    this.addUI();
                }
                this.ui.setStructure(info);
                if (this.getParent() != null) {
                    this.getParent().setCurrentTileSummary(this.ui.getStructureSummary());
                }
                this.setCurrentTile((short)0);
                this.requestCurrentTileTraceMessage();
                this.requestCurrentTileDetailedStatus();
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 17: {
                byte label = r.readByte();
                int numErrors = r.readByte();
                byte[] errors = new byte[numErrors];
                int i = 0;
                while (i < numErrors) {
                    errors[i] = r.readByte();
                    ++i;
                }
                if (!this.valid || this.ui == null) break;
                this.ui.setErrorState(label, errors);
                break;
            }
            case 8: 
            case 18: {
                String m = r.readString();
                if (!this.valid || this.ui == null) break;
                this.ui.setCurrentTileTraceMessage(m);
                break;
            }
            case 9: {
                break;
            }
            case 14: 
            case 20: {
                this.ui.specialOperation(r);
                break;
            }
            case 15: {
                if (!this.valid) break;
                this.largeChangeThrottle.receiveEvent();
                break;
            }
            case 16: {
                short index = r.readShort();
                byte status = r.readByte();
                byte hasSubstructure = r.readByte();
                byte foreign = r.readByte();
                if (!this.valid || this.ui == null) break;
                this.ui.smallChange(index, status, hasSubstructure != 0, foreign != 0);
                if (this.getParent() == null) break;
                this.getParent().setCurrentTileSummary(this.ui.getStructureSummary());
                break;
            }
            case 19: {
                if (this.numTiles == 0) {
                    this.acknowledgeStructureChange();
                    break;
                }
                if (this.ui == null) break;
                this.ui.structureChange();
                break;
            }
            case 3: {
                break;
            }
            case 13: {
                this.valid = true;
                this.requestNumTiles();
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                throw new UnknownMethodException(methodId);
            }
        }
    }

    public void removeChild(int index) {
        this.children[index] = null;
    }

    public void requestChildAnalyser(short channel) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)2);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(channel);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public void requestCurrentTileDetailedStatus() {
        this.callRemoteMethod(this, (short)7);
    }

    public void requestCurrentTileTraceMessage() {
        this.callRemoteMethod(this, (short)8);
    }

    public void requestNumTiles() {
        this.callRemoteMethod(this, (short)1);
    }

    public void requestStatusForTiles(int firstTile, int lastTile) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)4);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(firstTile);
                m.getPrimitiveTypesWriter().write(lastTile);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public void requestTotalStatusForTiles(int firstTile, int lastTile) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)5);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(firstTile);
                m.getPrimitiveTypesWriter().write(lastTile);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public void requestType() {
        this.callRemoteMethod(this, (short)0);
    }

    public void setCurrentTile(short index) {
        this.currentTile = index;
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)10);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(index);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public void setCurrentTileSummary(String s) {
        if (this.ui != null) {
            this.ui.setCurrentTileSummary(s);
        }
    }

    public String toString() {
        return "AnalyserProxy[" + this.id + "]";
    }

    public void unregister() {
        if (!this.unregistered) {
            this.unregistered = true;
            this.callRemoteMethod(this, (short)3);
            this.dispatcher().unregisterReceiver(this);
            this.cleanup();
            if (this.children != null) {
                int i = 0;
                while (i < this.numTiles) {
                    if (this.children[i] != null) {
                        this.children[i].unregister();
                    }
                    ++i;
                }
            }
            this.detatchFromParent();
        }
    }
}

