/*
 * Decompiled with CFR 0.152.
 */
package com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel;

import com.agilent.tntd.eclipse.issdb.common.ApplicationGenericMetaData;
import com.agilent.tntd.eclipse.middleware.PrimitiveTypesReader;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiDispatcher;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.RmiProxy;
import com.agilent.tntd.eclipse.thinclient.signalwizard.rmi.UnknownMethodException;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.ApplicationInterfaceUI;
import com.agilent.tntd.eclipse.thinclient.signalwizard.servermodel.Server;
import java.io.IOException;

public class ApplicationInterfaceProxy
extends RmiProxy {
    private static final short START = 0;
    private static final short START_SIGNAL_DISCOVERY = 1;
    private static final short START_STRUCTURE_SCOPE = 2;
    private static final short SUSPEND = 3;
    private static final short SUSPEND_SETUP_RX = 4;
    private static final short SUSPEND_SETUP_TX = 5;
    private static final short SUSPEND_SETUP_TX_RX = 6;
    private static final short DETECT_PATTERN = 7;
    private ApplicationInterfaceUI ui = null;

    protected ApplicationInterfaceProxy(RmiDispatcher d) {
        super(d);
    }

    public void detectPattern() {
        this.callRemoteMethod(this, (short)7);
    }

    public void receive(PrimitiveTypesReader r) throws IOException, UnknownMethodException {
        short methodId = r.readShort();
        switch (methodId) {
            case 0: {
                byte success = r.readByte();
                if (success != 0) {
                    this.startSignalDiscovery();
                    break;
                }
                this.ui.close();
                break;
            }
            case 1: {
                byte success = r.readByte();
                if (success == 0) break;
                this.ui.startDiscovery();
                Server.instance().signalDiscovery().start();
                break;
            }
            case 2: {
                byte success = r.readByte();
                if (success != 0) {
                    this.ui.startStructureScope();
                    Server.instance().structureScope().start();
                    break;
                }
                this.ui.close();
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                byte success = r.readByte();
                this.ui.acknowledgeSuspend(success != 0);
                break;
            }
            case 7: {
                byte success = r.readByte();
                short patternType = r.readShort();
                byte inverted = r.readByte();
                short userWord = r.readShort();
                this.ui.notifyPattern(success != 0, patternType, inverted != 0, userWord);
                break;
            }
            default: {
                throw new UnknownMethodException(methodId);
            }
        }
    }

    public void setUI(ApplicationInterfaceUI i) {
        this.ui = i;
    }

    public void start() {
        Server.instance().context().initialise();
        this.callRemoteMethod(this, (short)0);
    }

    public void startSignalDiscovery() {
        this.callRemoteMethod(this, (short)1);
    }

    public void startStructureScope(String portName) {
        try {
            ApplicationGenericMetaData m = this.beginRemoteCall(this, (short)2);
            if (m != null) {
                m.getPrimitiveTypesWriter().write(portName);
                this.concludeRemoteCall(m);
            }
        }
        catch (IOException iOException) {}
    }

    public void suspend() {
        this.callRemoteMethod(this, (short)3);
    }

    public void suspendSetupRx() {
        this.callRemoteMethod(this, (short)4);
    }

    public void suspendSetupTx() {
        this.callRemoteMethod(this, (short)5);
    }

    public void suspendSetupTxRx() {
        this.callRemoteMethod(this, (short)6);
    }

    public String toString() {
        return "ApplicationInterfaceProxy";
    }
}

